/* The main program of the Win32 interface to Xconq.
   Copyright (C) 1998-2000 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

#include "conq.h"
#include "kpublic.h"
#include "cmdline.h"
extern char *default_player_spec;

extern void make_default_player_spec(void);
extern int launch_game(void);
extern void launch_game_2(void);

#include "tcltk/tkconq.h"
extern int use_clip_mask;
extern int use_stdio;

extern void init_all_displays(void);

/* Local function declarations. */

/* The main program. */

int
main(int argc, char *argv[])
{
    use_stdio = FALSE;
    /* Tweak behavior of tcl/tk image handling. */
    use_clip_mask = FALSE;
    /* Dummy reference to get libraries pulled in */
    if (argc == -1)
      cmd_error(NULL, NULL);
    /* Shift to being the user that started the game. */
    init_library_path(NULL);
    /* Fiddle with game module structures. */
    clear_game_modules();
    /* Set up empty data structures. */
    init_data_structures();

    if (argc == 1)
      option_popup_new_game_dialog = TRUE;

    parse_command_line(argc, argv, general_options);

    initial_ui_init();

    /* If we're getting a startup dialog sequence, do it instead. */
    if (option_popup_new_game_dialog) {
	popup_game_dialog();
	ui_mainloop();
	/* Note that we never reach here. */
    }
    /* The straight-line setup sequence for a non-networked game set up
       using command-line arguments. */
    load_all_modules();
    check_game_validity();
    parse_command_line(argc, argv, variant_options);
    set_variants_from_options();
    parse_command_line(argc, argv, player_options);
    set_players_from_options();
    make_trial_assignments();
    /* Complain about anything that's left. */
    parse_command_line(argc, argv, leftover_options);
    launch_game();
    launch_game_2();
    /* Go into the main play loop. */
    ui_mainloop();

    /* Humor the compiler. */
    return 0;
}

/* The default (human) player is the current user on the current display. */

Player *
add_default_player(void)
{
    Player *player = add_player();
    
    player->name = getenv("USER");
    player->configname = getenv("XCONQCONFIG");
    player->displayname = "windows";
    return player;
}

void
make_default_player_spec(void)
{
  default_player_spec = "me@here";
}

/* Dummy versions of functions not emulated by Windows tk. */

void XSetTile(Display *dpy, GC gc, Pixmap pm) {}
void XFlush(Display *dpy) {}
/* Probably wrong, but makes cygwin b20 linking happy. */
int (*XSynchronize(Display *dpy, Bool b))(void) { return NULL; }

