/* Copyright (c) 1987, 1988  Stanley T. Shebs. */
/* Copyright (c) 1995 Michael J. Peters */
/* This program may be used, copied, modified, and redistributed freely */
/* for noncommercial purposes, so long as this notice remains intact. */

#define MINRIGHT 20

typedef struct _menu_item {
    char        *label;         /* the label for the item */
    WidgetClass *class;         /* pushbutton, label, separator... */
    char         mnemonic;      /* mnemonic; NULL if none */
    char        *accelerator;   /* accelerator; NULL if none */
    char        *accel_text;    /* to be converted to compound string */
    void       (*callback)();   /* routine to call; NULL if none */
    int         sensitivity;	/* what item is sensitive to */
    char 	*help;		/* help text */
} MenuItem;

extern MenuItem GAME_menu[];
extern MenuItem MESSAGE_menu[];
extern MenuItem OPTIONS_menu[];
extern MenuItem HELP_menu[];
extern MenuItem CONSCIOUSNESS_menu[];
extern MenuItem MOVE_menu[];
extern MenuItem PRODUCTION_menu[];
extern MenuItem TRANSPORT_menu[];
extern MenuItem MAP_menu[];
extern MenuItem MISC_menu[];

/* External functions */
extern void init_WM(Side *side);
extern void create_main_window(Side *side);
extern void create_msg_window(Side *side);
extern void create_info_window(Side *side);
extern void create_unit_menu_window(Side *side);
extern void set_menu_sensitivity(Widget menu, Boolean sensitive);
extern void set_item_sensitivity(Side *side, int sensitivity, Boolean sensitive);
extern void create_map_window(Side *side);
extern void create_sides_window(Side *side);
extern void create_timemode_window(Side *side);
extern void create_clock_window(Side *side);
extern void create_state_window(Side *side);
extern void create_world_window(Side *side);

extern void write_msg_text(Side *side, char *fmt, ... );
extern void draw_side_clock(Side *side, char *buf);
extern void draw_turn_clock(Side *side, char *buf);
extern void draw_state(Side *side, int u, char *buf);
extern void update_sides(Side *side);
extern void draw_all_sides(Side *side);
extern void draw_time(Side *side);
extern void draw_mode(Side *side);
extern void draw_info_text(Widget info_w, char* buf);

extern void add_move_callbacks(Side *side);
extern void remove_move_callbacks(Side *side);
extern void remove_map_callbacks(Side *side);
extern void create_unit_dialog(Side *side, char *prompt, int default_type,
    void (*product_callback)());
extern void create_dir_dialog(Side *side, char *prompt);
extern void create_give_dialog(Side *side, char *prompt, void (*callback)());
extern void create_map_dialog(Side *side, char *prompt, char *name, 
    void (*map_callback)(), void (*ok_callback)());
extern void create_prompt_dialog(Side *side, char *prompt, char *name, 
    void (*ok_callback)());
extern void create_question_dialog(Side *side, char *prompt, char *name, 
    void (*ok_callback)());
extern void destroy_dialog(Side *side);
extern bool dialog_active(Side *side);
extern bool side_dialog_active(Side *side);
extern void destroy_side_dialog(Side *side);
extern void create_options_dialog(Side *side, char *prompt, char *name, 
    void (*ok_callback)());
extern void create_msg_dialog(Side *side);
extern void create_declare_dialog(Side *side, char *prompt, char *name, 
    void (*ok_callback)());
extern void create_game_dialog(Side *side, char *prompt, char *name, 
    void (*ok_callback)());
extern void wait_to_exit(Side *side, void (*cancel_callback)());
extern void create_find_dialog(Side *side, Specific_unit *firstunit, int items_size);
extern void map_help_dialog(Side *side);
extern void write_help_text(Side *side, char *fmt, ... );
extern void create_utype_dialog(Side *side, int u);
extern void create_showmode_dialog(Side *side);
extern void create_legend_dialog(Side *side);
extern void create_help_dialog(Side *side);

/* command */
extern void cancel_dialog(Widget any, XtPointer client_data, XtPointer call_data);
extern void cancel_side_dialog(Widget any, XtPointer client_data, XtPointer call_data);
extern void do_survey_mode(Widget sidemode, XtPointer client_data, XtPointer call_data);
extern void do_sentry_iterate(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_sit(Widget any, XtPointer client_data, XtPointer call_data);
extern void do_wake_it(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_wake_all(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_wake_area(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_map(Widget map_area, XtPointer client_data, XtPointer call_data);
extern void x_product(Widget dialog_action, XtPointer client_data, XtPointer call_data);
extern void do_product(Widget dialog_action, XtPointer client_data, XtPointer call_data);
extern void x_next_product(Widget dialog_action, XtPointer client_data, XtPointer call_data);
extern void do_next_product(Widget dialog_action, XtPointer client_data, XtPointer call_data);
extern void do_idle(Widget dialog_action, XtPointer client_data, XtPointer call_data);
extern void do_return(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_moveto(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_follow(Widget menu, XtPointer client_data, XtPointer call_data);
extern void x_coast(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_coast(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_patrol(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_delay(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_unit_name(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_disband(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_recenter(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_occupant(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_mark_unit(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_embark_unit(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_give(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_take(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_give_unit(Widget dialog_action, XtPointer client_data, XtPointer call_data);
extern void do_center(Widget dialog_action, XtPointer client_data, XtPointer call_data);
extern void x_message(Widget dialog_action, XtPointer client_data, XtPointer call_data);
extern void x_sidelist(Widget dialog_action, XtPointer client_data, XtPointer call_data);
extern void x_sidelist2(Widget dialog_action, XtPointer client_data, XtPointer call_data);
extern void do_message(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_war(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_neutral(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_alliance(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_briefing(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_resign(Widget menu, XtPointer client_data, XtPointer call_data);
extern void x_lost(Widget menu, XtPointer client_data, XtPointer call_data);
extern void x_exit(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_save(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_rename(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_beeptime(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_itertime(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_background(Widget menu, XtPointer client_data, XtPointer call_data);
extern void x_showmode(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_showmode(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_morph(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_ident(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_flash(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_refresh(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_redraw(Widget menu, XtPointer client_data, XtPointer call_data);
extern void x_flash_unit(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_find_unit(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_find_next_unit_by_type(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_distance(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_movetounit(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_fill(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_movetotransport(Widget dialog, XtPointer client_data, XtPointer call_data);
extern void do_sentry_embark(Widget dialog, XtPointer client_data, XtPointer call_data);
extern void do_standing(Widget dialog, XtPointer client_data, XtPointer call_data);
extern void do_nothing(Widget dialog, XtPointer client_data, XtPointer call_data);
extern void do_disembark(Widget dialog, XtPointer client_data, XtPointer call_data);
extern void do_look(Widget dialog, XtPointer client_data, XtPointer call_data);
extern void do_auto(Widget dialog, XtPointer client_data, XtPointer call_data);
extern void do_next_dead(Widget dialog, XtPointer client_data, XtPointer call_data);

/* help */
extern void maybe_dump_news();
extern void describe_utype(Side *side, int u);
extern void x_unit_info(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_side_help(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_map_commands_help(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_map_help(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_period_help(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_terrain_help(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_dump_help(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_version_help(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_time(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_sideclock(Widget menu, XtPointer client_data, XtPointer call_data);
extern void do_turnclock(Widget menu, XtPointer client_data, XtPointer call_data);

