/* Main.java -- implement com.sun.tools.javac.Main
   Copyright (C) 2004  Red Hat

This file is part of java-gcj-compat.

java-gcj-compat is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

java-gcj-compat is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with java-gcj-compat; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package com.sun.tools.javac;

import java.io.*;
import java.net.*;
import java.lang.reflect.*;

public class Main
{
  Constructor ecjConstructor = null;
  Method ecjMethod = null;

  public Main () throws Exception
  {
    String classname = "org.eclipse.jdt.internal.compiler.batch.Main";
    Class klass = null;
    try
      {
	klass = Class.forName (classname);
      }
    catch (ClassNotFoundException e)
      {
	File jar = new File (Config.JAR_INST_DIR + "/jdtcore.jar");
	if (!jar.exists () || !jar.canRead ())
	  throw e;

	ClassLoader loader = new URLClassLoader(new URL[] {jar.toURL ()});
	try
	  {
	    klass = loader.loadClass (classname);
	  }
	catch (ClassNotFoundException f)
	  {
	    throw e;
	  }
      }

    ecjConstructor = klass.getConstructor (new Class[] {
      PrintWriter.class, PrintWriter.class, Boolean.TYPE});
    ecjMethod = klass.getMethod ("compile", new Class[] {String[].class});
  }
    
  public int compile (String[] args) throws Exception
  {
    // FIXME: Remove arguments supported by javac but not by ecj.  We
    // should add support for these to ecj.
    int removeCount = 0;

    // We must manually add sourcepath to the classpath.
    int classpathIndex = -1;
    String sourcepath = null;

    // We must set the bootclasspath if this isn't already done for us.
    boolean hasBootclasspath = false;

    for (int i = 0; i < args.length; i++)
      {
        if (args[i].equals ("-bootclasspath"))
          {
            hasBootclasspath = true;
          }
        if (args[i].equals ("-classpath"))
          {
            classpathIndex = i+1;
          }
        else if (args[i].equals ("-sourcepath"))
          {
            sourcepath = args[i+1];
            args[i] = "-REMOVETHISARGUMENT";
            args[i + 1] = "-REMOVETHISARGUMENT";
            removeCount += 2;
          }
        else if (args[i].equals ("-O"))
          {
            args[i] = "-REMOVETHISARGUMENT";
            removeCount++;
          }
      }

    // Append the sourcepath to the classpath.
    if (sourcepath != null && classpathIndex != -1)
      args[classpathIndex] += ":" + sourcepath;

    String[] strippedArgs = new String[args.length - removeCount 
                                       + (hasBootclasspath ? 0 : 2)];
    int k = 0;
    for (int i = 0; i < args.length; i++)
      {
        if (!args[i].equals ("-REMOVETHISARGUMENT"))
          strippedArgs[k++] = args[i];
      }
    if (! hasBootclasspath)
      {
        strippedArgs[k++] = "-bootclasspath";
        strippedArgs[k++] = System.getProperty ("sun.boot.class.path");
      }

    Object ecjInstance = ecjConstructor.newInstance (new Object[] {
      new PrintWriter (System.out),
      new PrintWriter (System.err),
      Boolean.FALSE});
    return ((Boolean) ecjMethod.invoke (ecjInstance, new Object[] {
      strippedArgs})).booleanValue() ? 0 : -1;
  }

  public static void main (String[] args) throws Exception
  {
    Main javac = new Main ();

    int result = javac.compile (args);

    Runtime.getRuntime ().exit (result);
  }
}
