// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_BASE_OBJECT_H_
#define _INTI_BASE_OBJECT_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/slot.h>
#include <inti/ptr.h>
#include <inti/destroy-notify.h>
#include <inti/signal-system.h>
#include <glib-object.h>
#include <string>

namespace Inti
{
  namespace Private
  {
    extern "C" void object_destroy_notify (void* data);
    
    class ObjectClass;
  }; // namespace Private

  namespace Gtk
  {
    // immediate subclasses of GtkObject
    class Widget;
    class Adjustment;
    class Tooltips;
  }
  
  class Object
    : public DestroyNotifier, public SignalEmitterBase
  {
  public:
    
    GObject * g_object () const { return object_; }
    
    // This direct struct access is a hack to reduce code size for
    // smart pointers and such
    void ref () { object_->ref_count += 1; }
    void unref ();
    void sink ();

    void set_data (const string & key, void *data,
                   void (* destroy_notify) (void*));

    void set_data (const char * key, void *data,
                   void (* destroy_notify) (void*));
    
    void * get_data (const string & key) const;
    void * get_data (const char * key) const;
    
    void remove_data (const string & key, bool notify = true);
    void remove_data (const char * key, bool notify = true);

    static void register_wrapper (const char * orig_type_name,
                                  Object * (* get_wrapper_func) (GObject*));

    static Object * wrap (GObject * obj);
    static Object * _private_wrap (GObject * obj, bool is_floating);

    // DestroyNotifier implementation
    virtual void add_destroy_listener (DestroyListener * listener);
    virtual void remove_destroy_listener (DestroyListener * listener);

      // SignalEmitter implementation
    virtual void add_signal_connection (Inti::Private::NativeConnectionImpl * impl);

    virtual void get_signal_connections (const Signal * signal,
                                         ConnectionList * connections);

    virtual void remove_signal_connection (Inti::Private::NativeConnectionImpl * impl);

  protected:
    friend class Private::ObjectClass;
    friend void Private::object_destroy_notify (void*);

    Object ();
    explicit Object (GObject *src, GObjectClass * orig);
    virtual ~Object () = 0;
    
    // set up the object post-construction
    void init_from_g_object (GObject *obj, GObjectClass * orig);

    GObjectClass * original_class () const
    {
      return original_class_;
    }
    
  private:
    GObject *object_;
    GObjectClass *original_class_;

    Object(const Object&);
    Object& operator=(const Object&);
    
    friend class Gtk::Widget; // to override sink_impl and disconnect signals in destroy
    friend class Gtk::Adjustment;
    friend class Gtk::Tooltips;
    virtual void sink_impl ();
    virtual bool floating () const;
    void disconnect_native_connections ();
    
  }; // class Object

}; // namespace Inti

#endif // _INTI_BASE_OBJECT_H_
