// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_STYLE_H_
#define _INTI_GTK_STYLE_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/object.h>
#include <gtk/gtkstyle.h>
#include <inti/gtk/gtkbase.h>

namespace Inti
{
  namespace Pango
  {
    class FontDescription;
  };
  
  namespace Gdk
  {
    class Color;
    class GC;
    class Window;
    class Pixmap;
    class Drawable;
    class Rectangle;
    class Point;
  }; // namespace Gdk
  
  namespace Gtk
  {
    namespace Private
    {
      class StyleClass;
    }; // namespace Private
    
    class Style : public Object
    {
    public:

      GtkStyle * gtk_style () const
      {
        return (GtkStyle*)g_object ();
      }

      Style ();

      // attach/detach/attached do not wrap nicely and aren't useful
      // to users really, so they aren't here.

      Style * copy () const;
      
      const Gdk::Color & fg (StateType state) const;
      const Gdk::Color & bg (StateType state) const;
      const Gdk::Color & light (StateType state) const;
      const Gdk::Color & dark (StateType state) const;
      const Gdk::Color & mid (StateType state) const;
      const Gdk::Color & text (StateType state) const;
      const Gdk::Color & base (StateType state) const;
      const Gdk::Color & black () const;
      const Gdk::Color & white () const;

      const Pango::FontDescription & font_description () const;
      void set_font_description (const Pango::FontDescription & desc);

      Gdk::GC * fg_gc (StateType state) const;
      Gdk::GC * bg_gc (StateType state) const;
      Gdk::GC * light_gc (StateType state) const;
      Gdk::GC * dark_gc (StateType state) const;
      Gdk::GC * mid_gc (StateType state) const;
      Gdk::GC * text_gc (StateType state) const;
      Gdk::GC * base_gc (StateType state) const;
      Gdk::GC * black_gc () const;
      Gdk::GC * white_gc () const;

      Gdk::Pixmap * bg_pixmap (StateType state) const;

      int xthickness () const { return gtk_style ()->xthickness; }
      int ythickness () const { return gtk_style ()->ythickness; }
      
      void set_fg (StateType state, const Gdk::Color & color);
      void set_bg (StateType state, const Gdk::Color & color);
      void set_light (StateType state, const Gdk::Color & color);
      void set_dark (StateType state, const Gdk::Color & color);
      void set_mid (StateType state, const Gdk::Color & color);
      void set_text (StateType state, const Gdk::Color & color);
      void set_base (StateType state, const Gdk::Color & color);
      
      void set_xthickness (int size);
      void set_ythickness (int size);

      void install_window_background (Gdk::Window * window,
                                      StateType state);

      //////////// FIXME the gtk_paint_ functions! or should
      //////////// they be widget methods? (probably not)
      
    protected:
      friend class Private::StyleClass;
      
      Style (GtkStyle *src,
             GtkStyleClass * orig);
      virtual ~Style ();

      Style * copy_impl () const;
      
      void draw_hline_impl (Gdk::Drawable *drawable,
                            StateType state_type,
                            const Gdk::Rectangle *area,
                            Gtk::Widget *widget,
                            const string &detail,
                            int x1,
                            int x2,
                            int y);
      void draw_vline_impl (Gdk::Drawable *drawable,
                            StateType state_type,
                            const Gdk::Rectangle *area,
                            Gtk::Widget *widget,
                            const string &detail,
                            int y1,
                            int y2,
                            int x);
      void draw_shadow_impl (Gdk::Drawable *drawable,
                             StateType state_type,
                             ShadowType shadow_type,
                             const Gdk::Rectangle *area,
                             Gtk::Widget *widget,
                             const string &detail,
                             int x,
                             int y,
                             int width,
                             int height);
      void draw_polygon_impl (Gdk::Drawable *drawable,
                              StateType state_type,
                              ShadowType shadow_type,
                              const Gdk::Rectangle *area,
                              Gtk::Widget *widget,
                              const string &detail,
                              const Gdk::Point * points,
                              int npoints,
                              bool fill);
      void draw_arrow_impl (Gdk::Drawable *drawable,
                            StateType state_type,
                            ShadowType shadow_type,
                            const Gdk::Rectangle *area,
                            Gtk::Widget *widget,
                            const string &detail,
                            ArrowType arrow_type,
                            bool fill,
                            int x,
                            int y,
                            int width,
                            int height);
      void draw_diamond_impl (Gdk::Drawable *drawable,
                              StateType state_type,
                              ShadowType shadow_type,
                              const Gdk::Rectangle *area,
                              Gtk::Widget *widget,
                              const string &detail,
                              int x,
                              int y,
                              int width,
                              int height);
      void draw_oval_impl (Gdk::Drawable *drawable,
                           StateType state_type,
                           ShadowType shadow_type,
                           const Gdk::Rectangle *area,
                           Gtk::Widget *widget,
                           const string &detail,
                           int x,
                           int y,
                           int width,
                           int height);
      void draw_string_impl (Gdk::Drawable *drawable,
                             StateType state_type,
                             const Gdk::Rectangle *area,
                             Gtk::Widget *widget,
                             const string &detail,
                             int x,
                             int y,
                             const string &string);
      void draw_box_impl (Gdk::Drawable *drawable,
                          StateType state_type,
                          ShadowType shadow_type,
                          const Gdk::Rectangle *area,
                          Gtk::Widget *widget,
                          const string &detail,
                          int x,
                          int y,
                          int width,
                          int height);
      void draw_flat_box_impl (Gdk::Drawable *drawable,
                               StateType state_type,
                               ShadowType shadow_type,
                               const Gdk::Rectangle *area,
                               Gtk::Widget *widget,
                               const string &detail,
                               int x,
                               int y,
                               int width,
                               int height);
      void draw_check_impl (Gdk::Drawable *drawable,
                            StateType state_type,
                            ShadowType shadow_type,
                            const Gdk::Rectangle *area,
                            Gtk::Widget *widget,
                            const string &detail,
                            int x,
                            int y,
                            int width,
                            int height);
      void draw_option_impl (Gdk::Drawable *drawable,
                             StateType state_type,
                             ShadowType shadow_type,
                             const Gdk::Rectangle *area,
                             Gtk::Widget *widget,
                             const string &detail,
                             int x,
                             int y,
                             int width,
                             int height);
      void draw_cross_impl (Gdk::Drawable *drawable,
                            StateType state_type,
                            ShadowType shadow_type,
                            const Gdk::Rectangle *area,
                            Gtk::Widget *widget,
                            const string &detail,
                            int x,
                            int y,
                            int width,
                            int height);
      void draw_ramp_impl (Gdk::Drawable *drawable,
                           StateType state_type,
                           ShadowType shadow_type,
                           const Gdk::Rectangle *area,
                           Gtk::Widget *widget,
                           const string &detail,
                           ArrowType arrow_type,
                           int x,
                           int y,
                           int width,
                           int height);
      void draw_tab_impl (Gdk::Drawable *drawable,
                          StateType state_type,
                          ShadowType shadow_type,
                          const Gdk::Rectangle *area,
                          Gtk::Widget *widget,
                          const string &detail,
                          int x,
                          int y,
                          int width,
                          int height); 
      void draw_shadow_gap_impl (Gdk::Drawable *drawable,
                                 StateType state_type,
                                 ShadowType shadow_type,
                                 const Gdk::Rectangle *area,
                                 Gtk::Widget *widget,
                                 const string &detail,
                                 int x,
                                 int y,
                                 int width,
                                 int height,
                                 PositionType gap_side,
                                 int gap_x,
                                 int gap_width);
      void draw_box_gap_impl (Gdk::Drawable *drawable,
                              StateType state_type,
                              ShadowType shadow_type,
                              const Gdk::Rectangle *area,
                              Gtk::Widget *widget,
                              const string &detail,
                              int x,
                              int y,
                              int width,
                              int height,
                              PositionType gap_side,
                              int gap_x,
                              int gap_width);
      void draw_extension_impl (Gdk::Drawable *drawable,
                                StateType state_type,
                                ShadowType shadow_type,
                                const Gdk::Rectangle *area,
                                Gtk::Widget *widget,
                                const string &detail,
                                int x,
                                int y,
                                int width,
                                int height,
                                PositionType gap_side);
      void draw_focus_impl (Gdk::Drawable *drawable,
                            const Gdk::Rectangle *area,
                            Gtk::Widget *widget,
                            const string &detail,
                            int x,
                            int y,
                            int width,
                            int height);
      void draw_slider_impl (Gdk::Drawable *drawable,
                             StateType state_type,
                             ShadowType shadow_type,
                             const Gdk::Rectangle *area,
                             Gtk::Widget *widget,
                             const string &detail,
                             int x,
                             int y,
                             int width,
                             int height,
                             Orientation orientation);
      void draw_handle_impl (Gdk::Drawable *drawable,
                             StateType state_type,
                             ShadowType shadow_type,
                             const Gdk::Rectangle *area,
                             Gtk::Widget *widget,
                             const string &detail,
                             int x,
                             int y,
                             int width,
                             int height,
                             Orientation orientation);
      
    private:
      Style(const Style&);
      Style& operator=(const Style&);

      const Gdk::Color & get_color (GdkColor * array, StateType state) const;
      Gdk::GC * get_gc (GdkGC ** array, StateType state) const;
      
      static void draw_hline_proxy (GtkStyle *style,
                                    GdkWindow *window,
                                    GtkStateType state_type,
                                    GdkRectangle *area,
                                    GtkWidget *widget,
                                    const gchar *detail,
                                    gint x1,
                                    gint x2,
                                    gint y);
      static void draw_vline_proxy (GtkStyle *style,
                                    GdkWindow *window,
                                    GtkStateType state_type,
                                    GdkRectangle *area,
                                    GtkWidget *widget,
                                    const gchar *detail,
                                    gint y1,
                                    gint y2,
                                    gint x);
      static void draw_shadow_proxy (GtkStyle *style,
                                     GdkWindow *window,
                                     GtkStateType state_type,
                                     GtkShadowType shadow_type,
                                     GdkRectangle *area,
                                     GtkWidget *widget,
                                     const gchar *detail,
                                     gint x,
                                     gint y,
                                     gint width,
                                     gint height);
      static void draw_polygon_proxy (GtkStyle *style,
                                      GdkWindow *window,
                                      GtkStateType state_type,
                                      GtkShadowType shadow_type,
                                      GdkRectangle *area,
                                      GtkWidget *widget,
                                      const gchar *detail,
                                      GdkPoint *point,
                                      gint npoints,
                                      gboolean fill);
      static void draw_arrow_proxy (GtkStyle *style,
                                    GdkWindow *window,
                                    GtkStateType state_type,
                                    GtkShadowType shadow_type,
                                    GdkRectangle *area,
                                    GtkWidget *widget,
                                    const gchar *detail,
                                    GtkArrowType arrow_type,
                                    gboolean fill,
                                    gint x,
                                    gint y,
                                    gint width,
                                    gint height);
      static void draw_diamond_proxy (GtkStyle *style,
                                      GdkWindow *window,
                                      GtkStateType state_type,
                                      GtkShadowType shadow_type,
                                      GdkRectangle *area,
                                      GtkWidget *widget,
                                      const gchar *detail,
                                      gint x,
                                      gint y,
                                      gint width,
                                      gint height);
      static void draw_oval_proxy (GtkStyle *style,
                                   GdkWindow *window,
                                   GtkStateType state_type,
                                   GtkShadowType shadow_type,
                                   GdkRectangle *area,
                                   GtkWidget *widget,
                                   const gchar *detail,
                                   gint x,
                                   gint y,
                                   gint width,
                                   gint height);
      static void draw_string_proxy (GtkStyle *style,
                                     GdkWindow *window,
                                     GtkStateType state_type,
                                     GdkRectangle *area,
                                     GtkWidget *widget,
                                     const gchar *detail,
                                     gint x,
                                     gint y,
                                     const gchar *string);
      static void draw_box_proxy (GtkStyle *style,
                                  GdkWindow *window,
                                  GtkStateType state_type,
                                  GtkShadowType shadow_type,
                                  GdkRectangle *area,
                                  GtkWidget *widget,
                                  const gchar *detail,
                                  gint x,
                                  gint y,
                                  gint width,
                                  gint height);
      static void draw_flat_box_proxy (GtkStyle *style,
                                       GdkWindow *window,
                                       GtkStateType state_type,
                                       GtkShadowType shadow_type,
                                       GdkRectangle *area,
                                       GtkWidget *widget,
                                       const gchar *detail,
                                       gint x,
                                       gint y,
                                       gint width,
                                       gint height);
      static void draw_check_proxy (GtkStyle *style,
                                    GdkWindow *window,
                                    GtkStateType state_type,
                                    GtkShadowType shadow_type,
                                    GdkRectangle *area,
                                    GtkWidget *widget,
                                    const gchar *detail,
                                    gint x,
                                    gint y,
                                    gint width,
                                    gint height);
      static void draw_option_proxy (GtkStyle *style,
                                     GdkWindow *window,
                                     GtkStateType state_type,
                                     GtkShadowType shadow_type,
                                     GdkRectangle *area,
                                     GtkWidget *widget,
                                     const gchar *detail,
                                     gint x,
                                     gint y,
                                     gint width,
                                     gint height);
      static void draw_cross_proxy (GtkStyle *style,
                                    GdkWindow *window,
                                    GtkStateType state_type,
                                    GtkShadowType shadow_type,
                                    GdkRectangle *area,
                                    GtkWidget *widget,
                                    const gchar *detail,
                                    gint x,
                                    gint y,
                                    gint width,
                                    gint height);
      static void draw_ramp_proxy (GtkStyle *style,
                                   GdkWindow *window,
                                   GtkStateType state_type,
                                   GtkShadowType shadow_type,
                                   GdkRectangle *area,
                                   GtkWidget *widget,
                                   const gchar *detail,
                                   GtkArrowType arrow_type,
                                   gint x,
                                   gint y,
                                   gint width,
                                   gint height);
      static void draw_tab_proxy (GtkStyle *style,
                                  GdkWindow *window,
                                  GtkStateType state_type,
                                  GtkShadowType shadow_type,
                                  GdkRectangle *area,
                                  GtkWidget *widget,
                                  const gchar *detail,
                                  gint x,
                                  gint y,
                                  gint width,
                                  gint height); 
      static void draw_shadow_gap_proxy (GtkStyle *style,
                                         GdkWindow *window,
                                         GtkStateType state_type,
                                         GtkShadowType shadow_type,
                                         GdkRectangle *area,
                                         GtkWidget *widget,
                                         const gchar *detail,
                                         gint x,
                                         gint y,
                                         gint width,
                                         gint height,
                                         GtkPositionType gap_side,
                                         gint gap_x,
                                         gint gap_width);
      static void draw_box_gap_proxy (GtkStyle *style,
                                      GdkWindow *window,
                                      GtkStateType state_type,
                                      GtkShadowType shadow_type,
                                      GdkRectangle *area,
                                      GtkWidget *widget,
                                      const gchar *detail,
                                      gint x,
                                      gint y,
                                      gint width,
                                      gint height,
                                      GtkPositionType gap_side,
                                      gint gap_x,
                                      gint gap_width);
      static void draw_extension_proxy (GtkStyle *style,
                                        GdkWindow *window,
                                        GtkStateType state_type,
                                        GtkShadowType shadow_type,
                                        GdkRectangle *area,
                                        GtkWidget *widget,
                                        const gchar *detail,
                                        gint x,
                                        gint y,
                                        gint width,
                                        gint height,
                                        GtkPositionType gap_side);
      static void draw_focus_proxy (GtkStyle *style,
                                    GdkWindow *window,
                                    GdkRectangle *area,
                                    GtkWidget *widget,
                                    const gchar *detail,
                                    gint x,
                                    gint y,
                                    gint width,
                                    gint height);
      static void draw_slider_proxy (GtkStyle *style,
                                     GdkWindow *window,
                                     GtkStateType state_type,
                                     GtkShadowType shadow_type,
                                     GdkRectangle *area,
                                     GtkWidget *widget,
                                     const gchar *detail,
                                     gint x,
                                     gint y,
                                     gint width,
                                     gint height,
                                     GtkOrientation orientation);
      static void draw_handle_proxy (GtkStyle *style,
                                     GdkWindow *window,
                                     GtkStateType state_type,
                                     GtkShadowType shadow_type,
                                     GdkRectangle *area,
                                     GtkWidget *widget,
                                     const gchar *detail,
                                     gint x,
                                     gint y,
                                     gint width,
                                     gint height,
                                     GtkOrientation orientation);
      
    }; // class Style

  }; // namespace Gtk

}; // namespace Inti

#endif // _INTI_GTK_STYLE_H_
