// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "statusbar.h"
#include "statusbar-class.h"
#include <inti/private-util.h>
#include <inti/gtk/marshal.h>

Inti::Gtk::Statusbar::Statusbar ()
  : HBox ((GtkHBox*)Private::StatusbarClass::make_proxy(),
          (GtkHBoxClass*)Private::StatusbarClass::original_class())
{

}

Inti::Gtk::Statusbar::Statusbar (GtkStatusbar *obj,
                                    GtkStatusbarClass *orig)
  : HBox ((GtkHBox*)obj,
          (GtkHBoxClass*)orig)
{

}

Inti::Gtk::Statusbar::~Statusbar ()
{

}


unsigned int
Inti::Gtk::Statusbar::push (const ustring & text)
{
  return gtk_statusbar_push (gtk_statusbar (),
                             0,
                             text.c_str ());

}

unsigned int
Inti::Gtk::Statusbar::push (const char * text)
{
  return gtk_statusbar_push (gtk_statusbar (),
                             0,
                             text);

}

void
Inti::Gtk::Statusbar::pop ()
{
  gtk_statusbar_pop (gtk_statusbar (),
                     0);
}

void
Inti::Gtk::Statusbar::remove (unsigned int id)
{
  gtk_statusbar_remove (gtk_statusbar (),
                        0, id);
}

void
Inti::Gtk::Statusbar::text_pushed_proxy (GtkStatusbar * statusbar,
                                            guint id, const gchar * text)
{
  Statusbar * s = dynamic_cast<Statusbar*>(Object::wrap((GObject*)statusbar));

  ustring t (text);
  s->text_pushed_impl (t);
  s->on_text_pushed (t);
}

void
Inti::Gtk::Statusbar::text_popped_proxy (GtkStatusbar * statusbar,
                                            guint id, const gchar * text)
{
  Statusbar * s = dynamic_cast<Statusbar*>(Object::wrap((GObject*)statusbar));

  ustring t (text);
  s->text_popped_impl (t);
  s->on_text_popped (t);
}

void
Inti::Gtk::Statusbar::text_pushed_impl (const ustring & text)
{
  GtkStatusbarClass * orig =
    (GtkStatusbarClass *) original_class();

  // This is conceptually broken; text_pushed_proxy may have
  // had a different context ID. However, I think it's OK
  // in practice.
  if (orig->text_pushed)
    (* orig->text_pushed) (gtk_statusbar (), 0, text.c_str ());
}

void
Inti::Gtk::Statusbar::text_popped_impl (const ustring & text)
{
  GtkStatusbarClass * orig =
    (GtkStatusbarClass *) original_class();

  // This is conceptually broken; text_pushed_proxy may have
  // had a different context ID. However, I think it's OK
  // in practice.
  if (orig->text_popped)
    (* orig->text_popped) (gtk_statusbar (), 0, text.c_str ());
}


void
Inti::Gtk::Statusbar::on_text_pushed (const ustring & text)
{
  // nothing
}

void
Inti::Gtk::Statusbar::on_text_popped (const ustring & text)
{
  // nothing
}

/////////// Everything below here is machine-generated
const Inti::Gtk::Statusbar::TextPushedSignalType
Inti::Gtk::Statusbar::text_pushed_signal ("text_pushed", (Private::SignalFunc)Private::slot1_void_uint_string_callback);

const Inti::Gtk::Statusbar::TextPoppedSignalType
Inti::Gtk::Statusbar::text_popped_signal ("text_popped", (Private::SignalFunc)Private::slot1_void_uint_string_callback);

