// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_SCALE_H_
#define _INTI_GTK_SCALE_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/range.h>
#include <gtk/gtkhscale.h>
#include <gtk/gtkvscale.h>
#include <string>

/*$ doc header
  $short The #Inti::Gtk::Scale class (a slider)
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class ScaleClass;
      class HScaleClass;
      class VScaleClass;
    };
    
    class Scale : public Range
    {
    public:
      /*$ doc class Scale
        $short slider widget base class (superclass of #HScale and #VScale)

        $copy none
        $memory floating
        
        $long

        <para>

        </para>

        <para>

        </para>
        
        $*/
        
      GtkScale * gtk_scale () const
      {
        return (GtkScale*)g_object ();
      }

      void set_decimal_places (int digits);
      int decimal_places () const;
      void set_draws_value (bool setting);
      bool draws_value () const;
      void set_value_position (PositionType pos);
      PositionType value_position () const;
      
    protected:
      friend class Private::ScaleClass;

      Scale ();
      Scale (Adjustment * adj);
      explicit Scale (GtkScale *src, GtkScaleClass* orig);
      virtual ~Scale () = 0; // abstract
      
    private:
      Scale(const Scale&);
      Scale& operator=(const Scale&);
      
    }; // class Scale

    class HScale : public Scale
    {
    public:
      /*$ doc class HScale
        $short horizontal slider widget

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/
        
      GtkHScale * gtk_hscale () const
      {
        return (GtkHScale*)g_object ();
      }

      HScale ();
      HScale (float lower, float upper);
      HScale (Adjustment * adj);
      
    protected:
      friend class Private::HScaleClass;
      
      explicit HScale (GtkHScale *src, GtkHScaleClass* orig);
      virtual ~HScale ();
      
    private:
      HScale(const HScale&);
      HScale& operator=(const HScale&);
      
    }; // class HScale

    
    class VScale : public Scale
    {
    public:
      /*$ doc class VScale
        $short vertical slider widget

        $copy none
        $memory floating
        
        $long

        <para>

        </para>
        
        $*/
        
      GtkVScale * gtk_vscale () const
      {
        return (GtkVScale*)g_object ();
      }

      VScale ();
      VScale (float lower, float upper);
      VScale (Adjustment * adj);
      
    protected:
      friend class Private::VScaleClass;
      
      explicit VScale (GtkVScale *src, GtkVScaleClass* orig);
      virtual ~VScale ();
      
    private:
      VScale(const VScale&);
      VScale& operator=(const VScale&);
      
    }; // class VScale


    
  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_SCALE_H_
