// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_PROGRESSBAR_H_
#define _INTI_GTK_PROGRESSBAR_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/gtkbase.h>
#include <inti/gtk/widget.h>
#include <gtk/gtkprogressbar.h>

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class ProgressBarClass;
    };
    
    class ProgressBar : public Widget
    {
    public:
      typedef enum
      {
        PROGRESS_LEFT_TO_RIGHT = GTK_PROGRESS_LEFT_TO_RIGHT,
        PROGRESS_RIGHT_TO_LEFT = GTK_PROGRESS_RIGHT_TO_LEFT,
        PROGRESS_BOTTOM_TO_TOP = GTK_PROGRESS_BOTTOM_TO_TOP,
        PROGRESS_TOP_TO_BOTTOM = GTK_PROGRESS_TOP_TO_BOTTOM
      } Orientation;
      
      GtkProgressBar * gtk_progress_bar () const
      {
        return (GtkProgressBar*)g_object ();
      }
      
      ProgressBar ();
      ProgressBar (Orientation o);
      
      void pulse ();

      void set_pulse_step (float fraction);
      float pulse_step () const;
      
      void set_fraction (float fraction);
      float fraction () const;
      
      void set_text (const char *text);
      void set_text (const ustring &text);
      ustring text () const;
      
      void set_orientation (Orientation o);
      Orientation orientation () const;
      
    protected:
      friend class Private::ProgressBarClass;
      
      explicit ProgressBar (GtkProgressBar *src, GtkProgressBarClass *orig);
      virtual ~ProgressBar ();
      
    private:
      ProgressBar(const ProgressBar&);
      ProgressBar& operator=(const ProgressBar&);
      
    }; // class ProgressBar

  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_PROGRESSBAR_H_
