// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_MISC_H_
#define _INTI_GTK_MISC_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/widget.h>
#include <gtk/gtkmisc.h>

/*$ doc header
  $short The #Inti::Gtk::Misc abstract class
  $*/

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class MiscClass;
    };
    
    class Misc : public Widget
    {
    public:
      /*$ doc class Misc
        $short abstract base class for widgets that can be aligned and padded

        $copy none
        $memory floating
        
        $long

        <para>

        </para>

        <para>

        </para>
        
        $*/
        
      GtkMisc * gtk_misc () const
      {
        return (GtkMisc*)g_object ();
      }

      /*$ doc constructor
        $short Construct a new Misc
        $long

        <para>

        </para>
        
        $*/
      Misc ();

      void set_alignment (float xalign, float yalign);
      void set_padding (int xpad, int ypad);

      void set_x_alignment (float align);
      void set_y_alignment (float align);
      void set_x_padding (int pad);
      void set_y_padding (int pad);

      float x_align () const { return gtk_misc ()->xalign; }
      float y_align () const { return gtk_misc ()->yalign; }
      int x_padding () const { return gtk_misc ()->xpad; }
      int y_padding () const { return gtk_misc ()->ypad; }
      
    protected:
      friend class Private::MiscClass;
      
      explicit Misc (GtkMisc *src, GtkMiscClass *orig);
      virtual ~Misc () = 0; // abstract base class
      
    private:
      Misc(const Misc&);
      Misc& operator=(const Misc&);
      
    }; // class Misc

  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_MISC_H_
