// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "gtkbase.h"
#include <stdio.h>
#include "adjustment-class.h"
#include "bin-class.h"
#include "button-class.h"
#include "container-class.h"
#include "label-class.h"
#include "misc-class.h"
#include <inti/object.h>
#include <inti/object-class.h>
#include "widget-class.h"
#include "window-class.h"
#include <inti/gdk/gdkbase.h>
#include "dnd.h"

bool
Inti::Gtk::init (int *argc, char ***argv, bool fatal_errors)
{
  using namespace Private;

  // registers the Gdk GObject types
  Inti::Gdk::Private::internal_init ();

  // This one overrides a get_wrapper from GDK
  Object::register_wrapper ("GdkDragContext", Gtk::DragContext::_private_get_wrapper);
  
  // Please keep these alphabetized
  Object::register_wrapper ("GtkAdjustment", AdjustmentClass::get_wrapper);
  Object::register_wrapper ("GtkBin", BinClass::get_wrapper);
  Object::register_wrapper ("GtkButton", ButtonClass::get_wrapper);
  Object::register_wrapper ("GtkContainer", ContainerClass::get_wrapper);
  Object::register_wrapper ("GtkLabel", LabelClass::get_wrapper);
  Object::register_wrapper ("GtkMisc", MiscClass::get_wrapper);
  Object::register_wrapper ("GtkWidget", WidgetClass::get_wrapper);
  Object::register_wrapper ("GtkWindow", WindowClass::get_wrapper);
  
  if (!gtk_init_check (argc, argv))
    {
      if (fatal_errors)
        {
          fprintf (stderr, "Unable to open a connection to the X display.\n");
          exit (1);
          return false; // compiler warnings
        }
      else
        return false;
    }
  else
    return true;
}

/////////// Everything below here is machine-generated
