// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_FRAME_H_
#define _INTI_GTK_FRAME_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/bin.h>
#include <inti/gtk/gtkbase.h>
#include <gtk/gtkframe.h>
#include <string>

namespace Inti
{
  namespace Gtk
  {
    namespace Private
    {
      class FrameClass;
    };

    class Frame : public Bin
    {
    public:

      GtkFrame * gtk_frame () const
      {
        return (GtkFrame*)g_object ();
      }

      Frame ();

      Frame (const ustring & text);
      Frame (const char * text);

      void set_shadow_type (Gtk::ShadowType type);
      ShadowType shadow_type () const { return (ShadowType) gtk_frame ()->shadow_type; }

      void set_label_widget (Widget * title_widget);
      const Widget * label_widget () const;
      Widget * label_widget ();

      void set_label_align (float xalign, float yalign);
      float x_align () const;
      float y_align () const;
      
    protected:
      friend class Private::FrameClass;

      Frame (GtkFrame *src, GtkFrameClass *orig);
      virtual ~Frame ();

    private:
      Frame(const Frame&);
      Frame& operator=(const Frame&);

    }; // class Frame

  }; // namespace Gtk

}; // namespace Inti

#endif // _INTI_GTK_FRAME_H_
