// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
// Example/test hello world program
/*
  The following license applies to this example code, but not to
  the Inti library itself:
  
    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
    DISTRIBUTOR OF THE SOFTWARE BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
    OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
    OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <inti/gtk/window.h>
#include <inti/gtk/button.h>
#include <inti/main.h>
#include <iostream>

using namespace Inti;

void
on_button_clicked ()
{
  cout << "Button was clicked!" << endl;
}

int
main (int argc, char **argv)
{
  using namespace Gtk;
  
  Main::Loop loop;
  
  init (&argc, &argv);

  Window * win = new Window;
  Button * button = new Button ("Hello, World!");

  win->add (button);
  
  win->sig_destroy ().connect (&loop, &Main::Loop::quit);
  button->sig_clicked ().connect (on_button_clicked);
  
  win->show_all ();
  
  loop.run ();

  return 0;
}
