#!/usr/bin/env python
# -*- Mode: Python; py-indent-offset: 4 -*-

from string import *
import sys
import exceptions

class OutputTarget:
    def __init__ (self):
        self.header_target = None
        self.impl_target = None
        self.current_target = None

    def set (self, header_target, impl_target):
        self.header_target = header_target
        self.impl_target = impl_target
        self.current_target = self.header_target

    def set_target_implementation (self):
        self.current_target = self.impl_target

    def is_targetting_implementation (self):
        return self.current_target == self.impl_target

    def write (self, s):
        self.current_target.write (s)

    def write_to_header (self, s):
        self.header_target.write (s)

    def write_to_impl (self, s):
        self.impl_target.write (s)

    def header_handle (self):
        return self.header_target

    def impl_handle (self):
        return self.impl_target
