// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "main.h"
#include "private-marshal.h"

static Inti::Main *main_loop = 0;
Inti::Main::Loop * Inti::Main::primary_loop_ = 0;

Inti::Main::Loop *
Inti::Main::primary ()
{
  return primary_loop_;
}

Inti::Main *
Inti::Main::get ()
{
  if (main_loop == 0)
    main_loop = new Main;
  
  return main_loop;
}

Inti::Main::Main ()
{

}

Inti::Main::~Main ()
{
  
}

bool
Inti::Main::iterate (bool block)
{
  return g_main_iteration (block) != FALSE;
}

bool
Inti::Main::events_pending () const
{
  return g_main_pending () != FALSE;
}

void
Inti::Main::flush ()
{
  while (iterate())
    ;
}

const int Inti::Main::DEFAULT = G_PRIORITY_DEFAULT;
const int Inti::Main::HIGH = G_PRIORITY_HIGH;
const int Inti::Main::HIGH_IDLE = G_PRIORITY_HIGH_IDLE;
const int Inti::Main::DEFAULT_IDLE = G_PRIORITY_DEFAULT_IDLE;
const int Inti::Main::LOW = G_PRIORITY_LOW;

namespace Inti
{
  namespace Private
  {
    class MainConnectionImpl : public Private::ConnectionImpl
    {
    public:
      virtual void disconnect ();
      virtual void block ();
      virtual void unblock ();

      void destroy_notify ();

      void add ();
  
    protected:
      MainConnectionImpl ();
      ~MainConnectionImpl ();
  
      virtual unsigned int readd () = 0;

    private:
      unsigned int block_count_;
      unsigned int id_;
      bool removal_is_block_;
    };
  }; // namespace Private
}; // namespace Inti

extern "C" void
inti_connection_destroy_notify (gpointer data)
{
  Inti::Private::MainConnectionImpl * impl =
    (Inti::Private::MainConnectionImpl *) data;

  // We may be disconnected, or we may be blocked.
  impl->destroy_notify ();
}

Inti::Private::MainConnectionImpl::MainConnectionImpl ()
  : block_count_ (0), id_ (0), removal_is_block_ (false)
{
  
}

Inti::Private::MainConnectionImpl::~MainConnectionImpl ()
{

}

void
Inti::Private::MainConnectionImpl::add ()
{
  if (disconnected ())
    return;
  
  if (id_ == 0)
    id_ = readd ();
}

void
Inti::Private::MainConnectionImpl::disconnect ()
{
  if (disconnected ())
    return;
  
  set_disconnected (true);
  
  if (id_ != 0)
    {
      ref ();
      removal_is_block_ = false;
      g_source_remove (id_);
      id_ = 0;
      unref ();
    }
}

void
Inti::Private::MainConnectionImpl::block ()
{
  if (disconnected ())
    return;
  
  if (block_count_ == 0)
    {
      // We may need to remove the source
      if (id_ != 0)
        {
          removal_is_block_ = true;
          g_source_remove (id_); // results in destroy_notify
          removal_is_block_ = false;
          id_ = 0;
        }
    }

  block_count_ += 1;
}

void
Inti::Private::MainConnectionImpl::unblock ()
{
  if (disconnected ())
    return;
  
  if (block_count_ == 1)
    {
      // re-add the source
      g_assert (id_ == 0);
      add ();
    }
  
  block_count_ -= 1;
}

void
Inti::Private::MainConnectionImpl::destroy_notify ()
{
  if (removal_is_block_)
    return;
  else
    {
      set_disconnected (true);
      unref (); // GTK held a reference
    }
}

namespace Inti
{
  namespace Private
  {
    class TimeoutConnectionImpl : public MainConnectionImpl
    {
    public:
      TimeoutConnectionImpl (int interval,
                             Slot0<bool> * slot,
                             int priority);

      ~TimeoutConnectionImpl ();

      Slot0<bool> * slot () { return slot_; }
      
    protected:
      virtual unsigned int readd ();
  
    private:
      Slot0<bool> * slot_;
      int interval_;
      int priority_;
    };
  }; // namespace Private
}; // namespace Inti
    
extern "C" gint
inti_timeout_callback (gpointer data)
{
  Inti::Private::TimeoutConnectionImpl * impl =
    (Inti::Private::TimeoutConnectionImpl*) data;

  return impl->slot ()->invoke ();
}

Inti::Private::TimeoutConnectionImpl::TimeoutConnectionImpl (int interval,
                                                                Slot0<bool> * slot,
                                                                int priority)
  : slot_ (slot), interval_(interval), priority_(priority)
{
  slot_->ref ();
  slot_->sink ();
}

Inti::Private::TimeoutConnectionImpl::~TimeoutConnectionImpl ()
{
  slot_->unref ();
}

unsigned int
Inti::Private::TimeoutConnectionImpl::readd ()
{
  return g_timeout_add_full (priority_, interval_,
                             inti_timeout_callback,
                             (void*) this,
                             inti_connection_destroy_notify);
}

Inti::Connection
Inti::Main::connect_timeout (int interval,
                                Slot0<bool> *slot,
                                int priority)
{
  Private::TimeoutConnectionImpl * impl =
    new Private::TimeoutConnectionImpl (interval, slot, priority);

  impl->add ();
  
  // The impl owns a reference to itself, which is decremented on disconnect

  return Connection (impl);
}

///////////////////////////////// Source

namespace Inti
{
  namespace Private
  {
    class SourceConnectionImpl : public MainConnectionImpl
    {
    public:
      SourceConnectionImpl (Main::Source * source,
                            bool can_recurse,
                            int priority);
  
      ~SourceConnectionImpl ();

      Main::Source * source () { return source_; }
  
    protected:
      virtual unsigned int readd ();
  
    private:
      Main::Source * source_;
      bool can_recurse_;
      int priority_;
    };
  }; // namespace Private
}; // namespace Inti


static gboolean
source_prepare (gpointer  source_data, 
                GTimeVal *current_time,
                gint     *timeout,
                gpointer  user_data)
{
  using namespace Inti;

  Private::SourceConnectionImpl *impl =
    (Private::SourceConnectionImpl*) source_data;
  TimeStamp stamp (current_time);

  return impl->source ()->prepare (stamp, timeout);
}

static gboolean
source_check (gpointer  source_data,
              GTimeVal *current_time,
              gpointer  user_data)
{
  using namespace Inti;
  
  Private::SourceConnectionImpl *impl =
    (Private::SourceConnectionImpl*) source_data;
  TimeStamp stamp (current_time);

  return impl->source ()->check (stamp);
}

static gboolean
source_dispatch (gpointer  source_data, 
                 GTimeVal *dispatch_time,
                 gpointer  user_data)
{
  using namespace Inti;
  
  Private::SourceConnectionImpl *impl =
    (Private::SourceConnectionImpl*) source_data;
  TimeStamp stamp (dispatch_time);

  return impl->source ()->dispatch (stamp);
}

GSourceFuncs source_funcs =
{
  source_prepare,
  source_check,
  source_dispatch,
  inti_connection_destroy_notify
};

Inti::Private::SourceConnectionImpl::SourceConnectionImpl (Main::Source * source,
                                                              bool can_recurse,
                                                              int priority)
  : source_ (source), can_recurse_ (can_recurse), priority_ (priority)
{
  source_->ref ();
  source_->sink ();
}

Inti::Private::SourceConnectionImpl::~SourceConnectionImpl ()
{
  source_->unref ();
}

unsigned int
Inti::Private::SourceConnectionImpl::readd ()
{
  return g_source_add (priority_,
                       can_recurse_,
                       &source_funcs,
                       this, // source_data
                       0,  // user data
                       0); // user data dnotify
}


Inti::Connection
Inti::Main::connect_source (Source *source,
                               bool can_recurse,
                               int priority)
{
  Private::SourceConnectionImpl * impl =
    new Private::SourceConnectionImpl (source, can_recurse, priority);

  impl->add ();
  
  // The impl owns a reference to itself, which is decremented on disconnect

  return Connection (impl);
}

////////////////////////////////// Idle

namespace Inti
{
  namespace Private
  {
    class IdleConnectionImpl : public MainConnectionImpl
    {
    public:
      IdleConnectionImpl (Slot0<bool> * slot,
                          int priority);
  
      ~IdleConnectionImpl ();

       Slot0<bool> * slot () { return slot_; }
      
    protected:
      virtual unsigned int readd ();
  
    private:
      Slot0<bool> * slot_;
      int priority_;
    };
  }; // namespace Private
}; // namespace Inti

    
extern "C" gint
inti_idle_callback (gpointer data)
{
  Inti::Private::IdleConnectionImpl * impl =
    (Inti::Private::IdleConnectionImpl*) data;

  return impl->slot ()->invoke ();
}

Inti::Private::IdleConnectionImpl::IdleConnectionImpl (Slot0<bool> * slot,
                                                          int priority)
  : slot_ (slot), priority_ (priority)
{
  slot_->ref ();
  slot_->sink ();
}

Inti::Private::IdleConnectionImpl::~IdleConnectionImpl ()
{
  slot_->unref ();
}

unsigned int
Inti::Private::IdleConnectionImpl::readd ()
{
  return g_idle_add_full (priority_,
                          inti_idle_callback,
                          (void*) this,
                          inti_connection_destroy_notify);
}

    
Inti::Connection
Inti::Main::connect_idle (Slot0<bool> *handler,
                             int priority)
{
  Private::IdleConnectionImpl * impl =
    new Private::IdleConnectionImpl (handler, priority);

  impl->add ();
  
  // The impl owns a reference to itself, which is decremented on disconnect

  return Connection (impl);
}

////////////////////////////////// Input


namespace Inti
{
  namespace Private
  {
    class IOConnectionImpl : public MainConnectionImpl
    {
    public:
      IOConnectionImpl (int fd,
                        IO::ConditionFlagsField condition_flags,
                        Slot2<bool,int,IO::ConditionFlagsField> * slot,
                        int priority);
  
      ~IOConnectionImpl ();

       Slot2<bool,int,IO::ConditionFlagsField> * slot () { return slot_; }
      
    protected:
      virtual unsigned int readd ();
  
    private:
      GIOChannel * channel_;
      IO::ConditionFlagsField flags_;
      Slot2<bool,int,IO::ConditionFlagsField> * slot_;
      int priority_;
    };
  }; // namespace Private
}; // namespace Inti

    
extern "C" gboolean
inti_io_callback (GIOChannel * channel,
                     GIOCondition condition_flags,
                     gpointer data)
{
  Inti::Private::IOConnectionImpl * impl =
    (Inti::Private::IOConnectionImpl*) data;

  return impl->slot ()->invoke (g_io_channel_unix_get_fd (channel),
                                (Inti::IO::ConditionFlagsField) condition_flags);
}

Inti::Private::IOConnectionImpl::IOConnectionImpl (int fd,
                                                      IO::ConditionFlagsField condition_flags,
                                                      Slot2<bool,int,IO::ConditionFlagsField> * slot,
                                                      int priority)
  : channel_(0), flags_ (condition_flags), slot_ (slot), priority_ (priority)
{
  slot_->ref ();
  slot_->sink ();

  channel_ = g_io_channel_unix_new (fd);
}

Inti::Private::IOConnectionImpl::~IOConnectionImpl ()
{
  slot_->unref ();
  g_io_channel_unref (channel_);
}

unsigned int
Inti::Private::IOConnectionImpl::readd ()
{
  return g_io_add_watch_full (channel_,
                              priority_,
                              (GIOCondition)flags_,
                              inti_io_callback,
                              (void*) this,
                              inti_connection_destroy_notify);
}


Inti::Connection
Inti::Main::connect_io (int file_descriptor,
                           IO::ConditionFlagsField condition_flags,
                           Slot2<bool,int,IO::ConditionFlagsField> *handler,
                           int priority)
{
  Private::IOConnectionImpl * impl =
    new Private::IOConnectionImpl (file_descriptor, condition_flags,
                                   handler, priority);

  impl->add ();
  
  // The impl owns a reference to itself, which is decremented on disconnect

  return Connection (impl);
}

////////// Loop

Inti::Main::Loop::Loop (bool primary, Inti::Main *main_loop)
  : main_(main_loop)
{
  if (main_ == 0)
    main_ = Main::get();
  
  if (primary)
    {
      if (main_->primary_loop_ != 0)
        g_warning ("Can only have one primary loop per Inti::Main");
      else
        main_->primary_loop_ = this;
    }
      
  loop_ = g_main_new (FALSE);
}

Inti::Main::Loop::~Loop ()
{
  if (main_->primary_loop_ == this)
    main_->primary_loop_ = 0;
  
  // quit if we haven't
  if (g_main_is_running (loop_))
    g_main_quit (loop_);

  g_main_destroy (loop_);
}

void
Inti::Main::Loop::run ()
{
  g_main_run (loop_);
}

void
Inti::Main::Loop::quit ()
{
  g_main_quit (loop_);
}

//////////// Source

Inti::Main::Source::Source ()
  : ref_count_ (1), floating_(true)
{


}

Inti::Main::Source::~Source ()
{

}

void
Inti::Main::Source::ref ()
{
  ref_count_ += 1;
}

void
Inti::Main::Source::unref ()
{
  ref_count_ -= 1;
  if (ref_count_ == 0)
    delete this;
}

void
Inti::Main::Source::sink ()
{
  if (floating_)
    {
      floating_ = false;
      unref ();
    }
}



/////////// Everything below here is machine-generated
