// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_WINDOW_H_
#define _INTI_GTK_WINDOW_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/utf-string.h>
#include <inti/gtk/bin.h>
#include <gtk/gtkwindow.h>

/*$ doc header
  $short The #Inti::Gtk::Window class, representing a toplevel window
  $*/

namespace Inti
{
  namespace Gdk
  {
    class Geometry;
  }; // namespace Gdk
  
  namespace Gtk
  {
    namespace Private
    {
      class WindowClass;
    };
    
    class Window : public Bin
    {
    public:
      /*$ doc class Window
        $short toplevel window widget

        $copy none
        $memory floating
        
        $long

        <para>

        </para>

        <para>

        </para>
        
        $*/
        
      GtkWindow * gtk_window () const
      {
        return (GtkWindow*)g_object ();
      }

      typedef enum
      {
        WINDOW_TOPLEVEL = GTK_WINDOW_TOPLEVEL,
        WINDOW_DIALOG = GTK_WINDOW_DIALOG,
        WINDOW_POPUP = GTK_WINDOW_POPUP
      } Type;
      typedef enum
      {
        WIN_POS_NONE = GTK_WIN_POS_NONE,
        WIN_POS_CENTER = GTK_WIN_POS_CENTER,
        WIN_POS_MOUSE = GTK_WIN_POS_MOUSE,
        WIN_POS_CENTER_ALWAYS = GTK_WIN_POS_CENTER_ALWAYS
      } Position;
      
      /*$ doc constructor
        $short Construct a new Window with type %TOPLEVEL
        $long

        <para>

        </para>
        
        $*/
      Window ();

      /*$ doc constructor
        $short Construct a new Window with type @type
        @type the type of window to create -- normal toplevel (%TOPLEVEL),
        dialog (%DIALOG), or popup menu/tooltip window (%POPUP).
        $long

        <para>

        </para>
        
        $*/
      Window (Type type);

      void set_title (const std::string& title);
      void set_wmclass (const std::string& wmclass_name, const std::string& wmclass_class);
      
      // FIXME set_user_resizeable
      // FIXME accel group

      void set_position (Position pos);
      bool activate_focus ();
      bool activate_default ();

      void set_transient_for (Window * parent);
      void set_geometry_hints (Widget * geometry_widget,
                               const Gdk::Geometry & geometry);

      void set_default_size (int width, int height);
      void set_default_width (int width);
      void set_default_height (int height);
      void set_modal (bool modal);
      
      ustring title () const;
      string wmclass_name () const;
      string wmclass_class () const;
      Position position () const { return (Position) gtk_window ()->position; }
      Window * transient_for () const;
      Widget * focus_widget () const;
      Widget * default_widget () const;
      Type type () const { return (Type) gtk_window ()->type; }
      bool modal () const { return gtk_window ()->modal; }
      
    protected:
      typedef WrapSignal1<void,Widget * > SetFocusSignalType;
      static const SetFocusSignalType set_focus_signal;

    public:
      typedef SignalProxy<Object,SetFocusSignalType> SetFocusProxyType;
      const SetFocusProxyType sig_set_focus ()
      {
        return SetFocusProxyType (this, &set_focus_signal);
      }

      static vector<Widget*> list_toplevels ();
      
    protected:
      friend class Private::WindowClass;
      
      explicit Window (GtkWindow *src, GtkWindowClass *orig);
      virtual ~Window ();
      
      virtual void set_focus_impl (Widget * focus_widget);
      virtual void on_set_focus (Widget * focus_widget);
      
    private:
      Window(const Window&);
      Window& operator=(const Window&);

      static void set_focus_proxy (GtkWindow * window,
                                   GtkWidget * focus_widget);
      
    }; // class Window

  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_WINDOW_H_
