// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_WIDGET_H_
#define _INTI_GTK_WIDGET_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/object.h>
#include <inti/gtk/gtk-signals.h>
#include <inti/gtk/gtkbase.h>
#include <inti/gdk/gdkbase.h>
#include <inti/utf-string.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkdnd.h>

namespace Inti
{
  namespace Gdk
  {
    class Drawable;
    class Pixmap;
    class Bitmap;
    class DragContext;
    class Window;
    class Visual;
    class Colormap;
    
    class Event;
    class EventExpose;
    class EventNoExpose;
    class EventVisibility;
    class EventMotion;
    class EventButton;
    class EventScroll;
    class EventKey;
    class EventCrossing;
    class EventFocus;
    class EventConfigure;
    class EventProperty;
    class EventSelection;
    class EventProximity;
    class EventClient;
    class EventDND;
    
  }; // namespace Gdk

  namespace Gtk
  {
    namespace Private
    {
      class WidgetClass;

    };

    class Container;
    class DragContext;
    class TargetEntry;
    class DragTargetEntry;
    class RcStyle;
    class SelectionData;
    class Style;
    
    typedef enum
    {
      DEST_DEFAULT_MOTION = GTK_DEST_DEFAULT_MOTION,
      DEST_DEFAULT_HIGHLIGHT = GTK_DEST_DEFAULT_HIGHLIGHT,
      DEST_DEFAULT_DROP = GTK_DEST_DEFAULT_DROP,
      DEST_DEFAULT_ALL = GTK_DEST_DEFAULT_ALL
    } DestDefaults;
    typedef unsigned int DestDefaultsField;
    
    class Allocation : public Gdk::Rectangle
    {
    public:
      Allocation ();
      Allocation (int x, int y, int width, int height);
      
      GtkAllocation * gtk_allocation () const
      {
        return (GtkAllocation*) this;
      }

      static inline Allocation * wrap (GtkAllocation * src) { return (Allocation*) src; }

    }; // class Allocation

    class Requisition : private GtkRequisition
    {
    private:
      typedef GtkRequisition Base;
    public:
      Requisition ();
      Requisition (int width, int height);
      
      // using default destructor
      // using default copy constructor and assignment

      int width () const { return Base::width; }
      int height () const { return Base::height; }

      void set_width (int w) { Base::width = w; }
      void set_height (int h) { Base::height = h; }

      void set (int width, int height);

      bool operator== (const Requisition & rhs) const;
      bool operator!= (const Requisition & rhs) const;

      GtkRequisition * gtk_requisition () const
      {
        return (GtkRequisition*) this;
      }

      static inline Requisition * wrap (GtkRequisition * src) { return (Requisition*) src; }
    }; // class Requisition

    class Widget : public Object
    {
    public:
      /*$ doc class Widget
        $short represents an element of a graphical user interface

        $copy none
        $memory floating

        $long

        <para>

        </para>

        <para>

        </para>

        $*/

      GtkWidget * gtk_widget () const
      {
        return (GtkWidget*)g_object ();
      }

      typedef enum
      {
        TOPLEVEL = GTK_TOPLEVEL,
        NO_WINDOW = GTK_NO_WINDOW,
        REALIZED = GTK_REALIZED,
        MAPPED = GTK_MAPPED,
        VISIBLE = GTK_VISIBLE,
        SENSITIVE = GTK_SENSITIVE,
        PARENT_SENSITIVE = GTK_PARENT_SENSITIVE,
        CAN_FOCUS = GTK_CAN_FOCUS,
        HAS_FOCUS = GTK_HAS_FOCUS,
        CAN_DEFAULT = GTK_CAN_DEFAULT,
        HAS_DEFAULT = GTK_HAS_DEFAULT,
        HAS_GRAB = GTK_HAS_GRAB,
        RC_STYLE = GTK_RC_STYLE,
        COMPOSITE_CHILD = GTK_COMPOSITE_CHILD,
        NO_REPARENT = GTK_NO_REPARENT,
        APP_PAINTABLE = GTK_APP_PAINTABLE,
        RECEIVES_DEFAULT = GTK_RECEIVES_DEFAULT
      } Flags;
      typedef unsigned int FlagsField;

      // Fairly low-level flags cruft.

      StateType state () const { return (StateType) GTK_WIDGET_STATE (gtk_widget ()); }

      FlagsField flags () const { return (FlagsField) GTK_WIDGET_FLAGS (gtk_widget ()); }
      void set_flags (FlagsField flags) { GTK_WIDGET_SET_FLAGS (gtk_widget (), flags); }
      void unset_flags (FlagsField flags) { GTK_WIDGET_UNSET_FLAGS (gtk_widget (), flags); }

      void toggle_flag (Flags flag, bool setting);

      bool toplevel () const { return GTK_WIDGET_TOPLEVEL (gtk_widget ()); }
      bool no_window () const { return GTK_WIDGET_NO_WINDOW (gtk_widget ()); }
      bool realized () const { return GTK_WIDGET_REALIZED (gtk_widget ()); }
      bool mapped () const { return GTK_WIDGET_MAPPED (gtk_widget ()); }
      bool visible () const { return GTK_WIDGET_VISIBLE (gtk_widget ()); }
      bool drawable () const { return GTK_WIDGET_DRAWABLE (gtk_widget ()); }
      bool sensitive () const { return GTK_WIDGET_IS_SENSITIVE (gtk_widget ()); }
      // FIXME GTK_WIDGET_SENSITIVE() and GTK_WIDGET_PARENT_SENSITIVE - what to do with these?

      bool can_focus () const { return GTK_WIDGET_CAN_FOCUS (gtk_widget ()); }
      bool has_focus () const { return GTK_WIDGET_HAS_FOCUS (gtk_widget ()); }
      bool can_default () const { return GTK_WIDGET_CAN_DEFAULT (gtk_widget ()); }
      bool has_default () const { return GTK_WIDGET_HAS_DEFAULT (gtk_widget ()); }
      bool has_grab () const { return GTK_WIDGET_HAS_GRAB (gtk_widget ()); }
      bool has_rc_style () const { return GTK_WIDGET_RC_STYLE (gtk_widget ()); }
      bool composite_child () const { return GTK_WIDGET_COMPOSITE_CHILD (gtk_widget ()); }
      bool app_paintable () const { return GTK_WIDGET_APP_PAINTABLE (gtk_widget ()); }
      bool receives_default () const { return GTK_WIDGET_RECEIVES_DEFAULT (gtk_widget ()); }

      void set_can_focus (bool setting) { toggle_flag (CAN_FOCUS, setting); }
      void set_can_default (bool setting) { toggle_flag (CAN_DEFAULT, setting); }

      const Allocation & allocation () const
      {
        return *(Allocation*)&gtk_widget ()->allocation;
      }

      const Requisition & requisition () const
      {
        return *(Requisition*)&gtk_widget ()->requisition;
      }

      Gdk::Window * window () const;

      Container * parent () const;

      void destroy ();
      
      // gtkselection.h
      int selection_owner_set (Inti::Gdk::Atom selection, guint32 time);
      void selection_add_target (Inti::Gdk::Atom selection, Inti::Gdk::Atom target, unsigned int info);
      int selection_convert (Inti::Gdk::Atom selection, Inti::Gdk::Atom target, guint32 time);
      void selection_remove_all ();

      void selection_add_target (const TargetEntry & target);
      void selection_add_targets (const vector<TargetEntry> & targets);
      
      // gtkdnd.h

      void drag_get_data (Gtk::DragContext * context,
                          Gdk::Atom target,
                          guint32 time);

      void drag_highlight ();
      void drag_unhighlight ();

      void drag_dest_set (DestDefaultsField defaults,
                          const vector<DragTargetEntry> & targets,
                          Gdk::DragActionField actions);

      void drag_dest_unset ();

      void drag_dest_set_proxy (Gdk::Window * proxy_window,
                                Gdk::DragProtocol protocol,
                                bool use_coordinates);

      void drag_source_set (Gdk::ModifierTypeField start_button_mask,
                            const vector<DragTargetEntry> & targets,
                            Gdk::DragActionField actions);

      void drag_source_unset ();

      // FIXME drag_source_set_icon, do in a convenient way

      Gtk::DragContext * drag_begin (const vector<TargetEntry> & targets,
                                     Gdk::DragActionField actions,
                                     int button,
                                     const Gdk::Event & event);

      void show ();
      void show_now ();
      void show_all ();
      void hide ();
      void hide_all ();
      void realize ();
      void unrealize ();

      void queue_draw ();
      void queue_draw_area (int x, int y, int width, int height);
      void queue_clear ();
      void queue_clear_area (int x, int y, int width, int height);
      void queue_resize ();
      void draw (const Inti::Gdk::Rectangle& area);
      void draw_focus ();
      void draw_default ();
      void size_request (const Inti::Gtk::Requisition& requisition);
      void size_allocate (const Inti::Gtk::Allocation& allocation);
      void get_child_requisition (const Inti::Gtk::Requisition& requisition);

      // FIXME all the accelerators functions

      bool event (const Gdk::Event & event);
      void set_parent (Container * parent);

      void popup (int x, int y);
      
      bool intersect (const Gdk::Rectangle & area,
                      Gdk::Rectangle * intersection);
      
      void grab_focus ();
      void grab_default ();
      void set_name (const std::string& name);
      ustring name () const;
      void set_state (Gtk::StateType state);

      void set_sensitive (bool sensitive);
      void set_app_paintable (bool app_paintable);
      void set_uposition (int x, int y);
      void set_usize (int width, int height);

      void set_events (Gdk::EventMaskField mask);
      void add_events (Gdk::EventMaskField mask);
      Gdk::EventMaskField events () const;

      void set_extension_events (Gdk::ExtensionModeField extension_events);
      Gdk::ExtensionModeField extension_events () const;

      Container * toplevel_container () const;

      Gdk::Colormap * colormap () const;
      const Gdk::Visual & visual () const;

      void get_pointer (int * x, int * y) const;

      bool contained_by (Container * ancestor) const;

      const Style * style () const;
      Style * style ();

      void set_style (Style * style);
      void ensure_style ();
      void restore_default_style ();
      void modify_style (RcStyle * rc_style);

      static void push_style (Style * style);
      static void pop_style ();
      static void push_colormap (Gdk::Colormap * colormap);
      static void pop_colormap ();
      static void push_composite_child ();
      static void pop_composite_child ();
      

      // FIXME get/set default visual/colormap/style

      void shape_combine_mask (Gdk::Bitmap * mask,
                               int x_offset,
                               int y_offset);

      // FIXME path and class_path

      void grab_add ();
      void grab_remove ();
      static Widget * grab_get_current ();

      static Widget * event_widget (const Gdk::Event & event);

    protected:
      typedef Signal0<void> DestroySignalType;
      static const DestroySignalType destroy_signal;

    public:
      typedef SignalProxy<Object,DestroySignalType> DestroyProxyType;
      const DestroyProxyType sig_destroy ()
      {
        return DestroyProxyType (this, &destroy_signal);
      }
      
    protected:
      typedef WrapSignal0<void> ShowSignalType;
      static const ShowSignalType show_signal;

    public:
      typedef SignalProxy<Object,ShowSignalType> ShowProxyType;
      const ShowProxyType sig_show ()
      {
        return ShowProxyType (this, &show_signal);
      }
    protected:
      typedef WrapSignal0<void> HideSignalType;
      static const HideSignalType hide_signal;

    public:
      typedef SignalProxy<Object,HideSignalType> HideProxyType;
      const HideProxyType sig_hide ()
      {
        return HideProxyType (this, &hide_signal);
      }
    protected:
      typedef WrapSignal0<void> RealizeSignalType;
      static const RealizeSignalType realize_signal;

    public:
      typedef SignalProxy<Object,RealizeSignalType> RealizeProxyType;
      const RealizeProxyType sig_realize ()
      {
        return RealizeProxyType (this, &realize_signal);
      }
    protected:
      typedef WrapSignal0<void> UnrealizeSignalType;
      static const UnrealizeSignalType unrealize_signal;

    public:
      typedef SignalProxy<Object,UnrealizeSignalType> UnrealizeProxyType;
      const UnrealizeProxyType sig_unrealize ()
      {
        return UnrealizeProxyType (this, &unrealize_signal);
      }
    protected:
      typedef WrapSignal1<void,const Gdk::Rectangle &> DrawSignalType;
      static const DrawSignalType draw_signal;

    public:
      typedef SignalProxy<Object,DrawSignalType> DrawProxyType;
      const DrawProxyType sig_draw ()
      {
        return DrawProxyType (this, &draw_signal);
      }
    protected:
      typedef WrapSignal0<void> DrawFocusSignalType;
      static const DrawFocusSignalType draw_focus_signal;

    public:
      typedef SignalProxy<Object,DrawFocusSignalType> DrawFocusProxyType;
      const DrawFocusProxyType sig_draw_focus ()
      {
        return DrawFocusProxyType (this, &draw_focus_signal);
      }
    protected:
      typedef WrapSignal0<void> DrawDefaultSignalType;
      static const DrawDefaultSignalType draw_default_signal;

    public:
      typedef SignalProxy<Object,DrawDefaultSignalType> DrawDefaultProxyType;
      const DrawDefaultProxyType sig_draw_default ()
      {
        return DrawDefaultProxyType (this, &draw_default_signal);
      }

    protected:
      typedef WrapSignal1<void,Requisition * > SizeRequestSignalType;
      static const SizeRequestSignalType size_request_signal;

    public:
      typedef SignalProxy<Object,SizeRequestSignalType> SizeRequestProxyType;
      const SizeRequestProxyType sig_size_request ()
      {
        return SizeRequestProxyType (this, &size_request_signal);
      }

    protected:
      typedef WrapSignal1<void,const Allocation &> SizeAllocateSignalType;
      static const SizeAllocateSignalType size_allocate_signal;

    public:
      typedef SignalProxy<Object,SizeAllocateSignalType> SizeAllocateProxyType;
      const SizeAllocateProxyType sig_size_allocate ()
      {
        return SizeAllocateProxyType (this, &size_allocate_signal);
      }
    protected:
      typedef WrapSignal1<void,StateType> StateChangedSignalType;
      static const StateChangedSignalType state_changed_signal;

    public:
      typedef SignalProxy<Object,StateChangedSignalType> StateChangedProxyType;
      const StateChangedProxyType sig_state_changed ()
      {
        return StateChangedProxyType (this, &state_changed_signal);
      }
    protected:
      typedef WrapSignal1<void,Widget * > ParentSetSignalType;
      static const ParentSetSignalType parent_set_signal;

    public:
      typedef SignalProxy<Object,ParentSetSignalType> ParentSetProxyType;
      const ParentSetProxyType sig_parent_set ()
      {
        return ParentSetProxyType (this, &parent_set_signal);
      }

    protected:
      typedef WrapSignal1<void,Style * > StyleSetSignalType;
      static const StyleSetSignalType style_set_signal;

    public:
      typedef SignalProxy<Object,StyleSetSignalType> StyleSetProxyType;
      const StyleSetProxyType sig_style_set ()
      {
        return StyleSetProxyType (this, &style_set_signal);
      }

      // FIXME wrap accelerator signals

    protected:
      typedef WrapSignal0<void> GrabFocusSignalType;
      static const GrabFocusSignalType grab_focus_signal;

    public:
      typedef SignalProxy<Object,GrabFocusSignalType> GrabFocusProxyType;
      const GrabFocusProxyType sig_grab_focus ()
      {
        return GrabFocusProxyType (this, &grab_focus_signal);
      }

    protected:
      typedef WrapSignal1<bool,const Gdk::Event &> EventSignalType;
      static const EventSignalType event_signal;

    public:
      typedef SignalProxy<Object,EventSignalType> EventProxyType;
      const EventProxyType sig_event ()
      {
        return EventProxyType (this, &event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventButton &> ButtonPressEventSignalType;
      static const ButtonPressEventSignalType button_press_event_signal;

    public:
      typedef SignalProxy<Object,ButtonPressEventSignalType> ButtonPressEventProxyType;
      const ButtonPressEventProxyType sig_button_press_event ()
      {
        return ButtonPressEventProxyType (this, &button_press_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventButton &> ButtonReleaseEventSignalType;
      static const ButtonReleaseEventSignalType button_release_event_signal;

    public:
      typedef SignalProxy<Object,ButtonReleaseEventSignalType> ButtonReleaseEventProxyType;
      const ButtonReleaseEventProxyType sig_button_release_event ()
      {
        return ButtonReleaseEventProxyType (this, &button_release_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventScroll &> ScrollEventSignalType;
      static const ScrollEventSignalType scroll_event_signal;

    public:
      typedef SignalProxy<Object,ScrollEventSignalType> ScrollEventProxyType;
      const ScrollEventProxyType sig_scroll_event ()
      {
        return ScrollEventProxyType (this, &scroll_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventMotion &> MotionNotifyEventSignalType;
      static const MotionNotifyEventSignalType motion_notify_event_signal;

    public:
      typedef SignalProxy<Object,MotionNotifyEventSignalType> MotionNotifyEventProxyType;
      const MotionNotifyEventProxyType sig_motion_notify_event ()
      {
        return MotionNotifyEventProxyType (this, &motion_notify_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::Event &> DeleteEventSignalType;
      static const DeleteEventSignalType delete_event_signal;

    public:
      typedef SignalProxy<Object,DeleteEventSignalType> DeleteEventProxyType;
      const DeleteEventProxyType sig_delete_event ()
      {
        return DeleteEventProxyType (this, &delete_event_signal);
      }
      // destroy_event is deliberately not wrapped
    protected:
      typedef WrapSignal1<bool,const Gdk::EventExpose &> ExposeEventSignalType;
      static const ExposeEventSignalType expose_event_signal;

    public:
      typedef SignalProxy<Object,ExposeEventSignalType> ExposeEventProxyType;
      const ExposeEventProxyType sig_expose_event ()
      {
        return ExposeEventProxyType (this, &expose_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventKey &> KeyPressEventSignalType;
      static const KeyPressEventSignalType key_press_event_signal;

    public:
      typedef SignalProxy<Object,KeyPressEventSignalType> KeyPressEventProxyType;
      const KeyPressEventProxyType sig_key_press_event ()
      {
        return KeyPressEventProxyType (this, &key_press_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventKey &> KeyReleaseEventSignalType;
      static const KeyReleaseEventSignalType key_release_event_signal;

    public:
      typedef SignalProxy<Object,KeyReleaseEventSignalType> KeyReleaseEventProxyType;
      const KeyReleaseEventProxyType sig_key_release_event ()
      {
        return KeyReleaseEventProxyType (this, &key_release_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventCrossing &> EnterNotifyEventSignalType;
      static const EnterNotifyEventSignalType enter_notify_event_signal;

    public:
      typedef SignalProxy<Object,EnterNotifyEventSignalType> EnterNotifyEventProxyType;
      const EnterNotifyEventProxyType sig_enter_notify_event ()
      {
        return EnterNotifyEventProxyType (this, &enter_notify_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventCrossing &> LeaveNotifyEventSignalType;
      static const LeaveNotifyEventSignalType leave_notify_event_signal;

    public:
      typedef SignalProxy<Object,LeaveNotifyEventSignalType> LeaveNotifyEventProxyType;
      const LeaveNotifyEventProxyType sig_leave_notify_event ()
      {
        return LeaveNotifyEventProxyType (this, &leave_notify_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventConfigure &> ConfigureEventSignalType;
      static const ConfigureEventSignalType configure_event_signal;

    public:
      typedef SignalProxy<Object,ConfigureEventSignalType> ConfigureEventProxyType;
      const ConfigureEventProxyType sig_configure_event ()
      {
        return ConfigureEventProxyType (this, &configure_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventFocus &> FocusInEventSignalType;
      static const FocusInEventSignalType focus_in_event_signal;

    public:
      typedef SignalProxy<Object,FocusInEventSignalType> FocusInEventProxyType;
      const FocusInEventProxyType sig_focus_in_event ()
      {
        return FocusInEventProxyType (this, &focus_in_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventFocus &> FocusOutEventSignalType;
      static const FocusOutEventSignalType focus_out_event_signal;

    public:
      typedef SignalProxy<Object,FocusOutEventSignalType> FocusOutEventProxyType;
      const FocusOutEventProxyType sig_focus_out_event ()
      {
        return FocusOutEventProxyType (this, &focus_out_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::Event &> MapEventSignalType;
      static const MapEventSignalType map_event_signal;

    public:
      typedef SignalProxy<Object,MapEventSignalType> MapEventProxyType;
      const MapEventProxyType sig_map_event ()
      {
        return MapEventProxyType (this, &map_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::Event &> UnmapEventSignalType;
      static const UnmapEventSignalType unmap_event_signal;

    public:
      typedef SignalProxy<Object,UnmapEventSignalType> UnmapEventProxyType;
      const UnmapEventProxyType sig_unmap_event ()
      {
        return UnmapEventProxyType (this, &unmap_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventProperty &> PropertyNotifyEventSignalType;
      static const PropertyNotifyEventSignalType property_notify_event_signal;

    public:
      typedef SignalProxy<Object,PropertyNotifyEventSignalType> PropertyNotifyEventProxyType;
      const PropertyNotifyEventProxyType sig_property_notify_event ()
      {
        return PropertyNotifyEventProxyType (this, &property_notify_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventSelection &> SelectionClearEventSignalType;
      static const SelectionClearEventSignalType selection_clear_event_signal;

    public:
      typedef SignalProxy<Object,SelectionClearEventSignalType> SelectionClearEventProxyType;
      const SelectionClearEventProxyType sig_selection_clear_event ()
      {
        return SelectionClearEventProxyType (this, &selection_clear_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventSelection &> SelectionRequestEventSignalType;
      static const SelectionRequestEventSignalType selection_request_event_signal;

    public:
      typedef SignalProxy<Object,SelectionRequestEventSignalType> SelectionRequestEventProxyType;
      const SelectionRequestEventProxyType sig_selection_request_event ()
      {
        return SelectionRequestEventProxyType (this, &selection_request_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventSelection &> SelectionNotifyEventSignalType;
      static const SelectionNotifyEventSignalType selection_notify_event_signal;

    public:
      typedef SignalProxy<Object,SelectionNotifyEventSignalType> SelectionNotifyEventProxyType;
      const SelectionNotifyEventProxyType sig_selection_notify_event ()
      {
        return SelectionNotifyEventProxyType (this, &selection_notify_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventProximity &> ProximityInEventSignalType;
      static const ProximityInEventSignalType proximity_in_event_signal;

    public:
      typedef SignalProxy<Object,ProximityInEventSignalType> ProximityInEventProxyType;
      const ProximityInEventProxyType sig_proximity_in_event ()
      {
        return ProximityInEventProxyType (this, &proximity_in_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventProximity &> ProximityOutEventSignalType;
      static const ProximityOutEventSignalType proximity_out_event_signal;

    public:
      typedef SignalProxy<Object,ProximityOutEventSignalType> ProximityOutEventProxyType;
      const ProximityOutEventProxyType sig_proximity_out_event ()
      {
        return ProximityOutEventProxyType (this, &proximity_out_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventVisibility &> VisibilityNotifyEventSignalType;
      static const VisibilityNotifyEventSignalType visibility_notify_event_signal;

    public:
      typedef SignalProxy<Object,VisibilityNotifyEventSignalType> VisibilityNotifyEventProxyType;
      const VisibilityNotifyEventProxyType sig_visibility_notify_event ()
      {
        return VisibilityNotifyEventProxyType (this, &visibility_notify_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::EventClient &> ClientEventSignalType;
      static const ClientEventSignalType client_event_signal;

    public:
      typedef SignalProxy<Object,ClientEventSignalType> ClientEventProxyType;
      const ClientEventProxyType sig_client_event ()
      {
        return ClientEventProxyType (this, &client_event_signal);
      }
    protected:
      typedef WrapSignal1<bool,const Gdk::Event &> NoExposeEventSignalType;
      static const NoExposeEventSignalType no_expose_event_signal;

    public:
      typedef SignalProxy<Object,NoExposeEventSignalType> NoExposeEventProxyType;
      const NoExposeEventProxyType sig_no_expose_event ()
      {
        return NoExposeEventProxyType (this, &no_expose_event_signal);
      }

      ///////// end of event signals

      ///////// Selection signals

    protected:
      typedef WrapSignal3<void,Gtk::SelectionData * ,unsigned int,unsigned int> SelectionGetSignalType;
      static const SelectionGetSignalType selection_get_signal;

    public:
      typedef SignalProxy<Object,SelectionGetSignalType> SelectionGetProxyType;
      const SelectionGetProxyType sig_selection_get ()
      {
        return SelectionGetProxyType (this, &selection_get_signal);
      }
    protected:
      typedef WrapSignal2<void,const Gtk::SelectionData&,unsigned int> SelectionReceivedSignalType;
      static const SelectionReceivedSignalType selection_received_signal;

    public:
      typedef SignalProxy<Object,SelectionReceivedSignalType> SelectionReceivedProxyType;
      const SelectionReceivedProxyType sig_selection_received ()
      {
        return SelectionReceivedProxyType (this, &selection_received_signal);
      }

      ///////// End of selection signals

      ///////// Drag and Drop signals
      
    protected:
      typedef WrapSignal1<void,Gtk::DragContext* > DragBeginSignalType;
      static const DragBeginSignalType drag_begin_signal;

    public:
      typedef SignalProxy<Object,DragBeginSignalType> DragBeginProxyType;
      const DragBeginProxyType sig_drag_begin ()
      {
        return DragBeginProxyType (this, &drag_begin_signal);
      }
    protected:
      typedef WrapSignal1<void,Gtk::DragContext* > DragEndSignalType;
      static const DragEndSignalType drag_end_signal;

    public:
      typedef SignalProxy<Object,DragEndSignalType> DragEndProxyType;
      const DragEndProxyType sig_drag_end ()
      {
        return DragEndProxyType (this, &drag_end_signal);
      }
    protected:
      typedef WrapSignal4<void,Gtk::DragContext* ,Gtk::SelectionData * ,unsigned int,unsigned int> DragDataGetSignalType;
      static const DragDataGetSignalType drag_data_get_signal;

    public:
      typedef SignalProxy<Object,DragDataGetSignalType> DragDataGetProxyType;
      const DragDataGetProxyType sig_drag_data_get ()
      {
        return DragDataGetProxyType (this, &drag_data_get_signal);
      }
    protected:
      typedef WrapSignal1<void,Gtk::DragContext* > DragDataDeleteSignalType;
      static const DragDataDeleteSignalType drag_data_delete_signal;

    public:
      typedef SignalProxy<Object,DragDataDeleteSignalType> DragDataDeleteProxyType;
      const DragDataDeleteProxyType sig_drag_data_delete ()
      {
        return DragDataDeleteProxyType (this, &drag_data_delete_signal);
      }
    protected:
      typedef WrapSignal2<void,Gtk::DragContext* ,unsigned int> DragLeaveSignalType;
      static const DragLeaveSignalType drag_leave_signal;

    public:
      typedef SignalProxy<Object,DragLeaveSignalType> DragLeaveProxyType;
      const DragLeaveProxyType sig_drag_leave ()
      {
        return DragLeaveProxyType (this, &drag_leave_signal);
      }
    protected:
      typedef WrapSignal4<bool,Gtk::DragContext* ,int,int,unsigned int> DragMotionSignalType;
      static const DragMotionSignalType drag_motion_signal;

    public:
      typedef SignalProxy<Object,DragMotionSignalType> DragMotionProxyType;
      const DragMotionProxyType sig_drag_motion ()
      {
        return DragMotionProxyType (this, &drag_motion_signal);
      }
    protected:
      typedef WrapSignal4<bool,Gtk::DragContext* ,int,int,unsigned int> DragDropSignalType;
      static const DragDropSignalType drag_drop_signal;

    public:
      typedef SignalProxy<Object,DragDropSignalType> DragDropProxyType;
      const DragDropProxyType sig_drag_drop ()
      {
        return DragDropProxyType (this, &drag_drop_signal);
      }
    protected:
      typedef WrapSignal6<void,Gtk::DragContext* ,int,int,const Gtk::SelectionData&,unsigned int,unsigned int> DragDataReceivedSignalType;
      static const DragDataReceivedSignalType drag_data_received_signal;

    public:
      typedef SignalProxy<Object,DragDataReceivedSignalType> DragDataReceivedProxyType;
      const DragDataReceivedProxyType sig_drag_data_received ()
      {
        return DragDataReceivedProxyType (this, &drag_data_received_signal);
      }
      
      ///////// End of Drag and Drop signals

    protected:
      friend class Private::WidgetClass;

      explicit Widget (GtkWidget *src, GtkWidgetClass * orig);
      virtual ~Widget () = 0; // abstract base class

      /*$ doc constructor Widget
        $short Construct a new widget
        $long

        <para>

        </para>

        $*/
      Widget ();

      void set_allocation (const Allocation & allocation)
      {
        gtk_widget ()->allocation = *allocation.gtk_allocation ();
      }

      void set_requisition (const Requisition & requisition)
      {
        gtk_widget ()->requisition = *requisition.gtk_requisition ();
      }

      void map ();
      void unmap ();

      void set_colormap (Gdk::Colormap * cmap);
      void set_window (Gdk::Window * window);
      
      // These are used in custom widget implementations
      void set_toplevel (bool setting) { toggle_flag (TOPLEVEL, setting); }
      void set_no_window (bool setting) { toggle_flag (NO_WINDOW, setting); }
      void set_realized (bool setting) { toggle_flag (REALIZED, setting); }
      void set_mapped (bool setting) { toggle_flag (MAPPED, setting); }
      void set_visible (bool setting) { toggle_flag (VISIBLE, setting); }

      // Virtual functions that are not associated with signals
      virtual void map_impl ();
      virtual void unmap_impl ();
      virtual void show_all_impl ();
      virtual void hide_all_impl ();
      
      // Virtual functions that are associated with signals

      virtual void destroy_impl ();
      virtual void show_impl ();
      virtual void hide_impl ();
      virtual void realize_impl ();
      virtual void unrealize_impl ();
      virtual void draw_impl (const Gdk::Rectangle & area);
      virtual void draw_focus_impl ();
      virtual void draw_default_impl ();
      virtual void size_request_impl (Requisition * requisition);
      virtual void size_allocate_impl (const Allocation& allocation);
      virtual void state_changed_impl (StateType previous_state);
      virtual void parent_set_impl (Widget * parent);
      virtual void style_set_impl (Style * previous_style);
      virtual void grab_focus_impl ();
      virtual bool event_impl (const Gdk::Event & event);
      virtual bool button_press_event_impl (const Gdk::EventButton & event);
      virtual bool button_release_event_impl (const Gdk::EventButton & event);
      virtual bool scroll_event_impl (const Gdk::EventScroll & event);
      virtual bool motion_notify_event_impl (const Gdk::EventMotion & event);
      virtual bool delete_event_impl (const Gdk::Event & event);
      virtual bool expose_event_impl (const Gdk::EventExpose & event);
      virtual bool key_press_event_impl (const Gdk::EventKey & event);
      virtual bool key_release_event_impl (const Gdk::EventKey & event);
      virtual bool enter_notify_event_impl (const Gdk::EventCrossing & event);
      virtual bool leave_notify_event_impl (const Gdk::EventCrossing & event);
      virtual bool configure_event_impl (const Gdk::EventConfigure & event);
      virtual bool focus_in_event_impl (const Gdk::EventFocus & event);
      virtual bool focus_out_event_impl (const Gdk::EventFocus & event);
      virtual bool map_event_impl (const Gdk::Event & event);
      virtual bool unmap_event_impl (const Gdk::Event & event);
      virtual bool property_notify_event_impl (const Gdk::EventProperty & event);
      virtual bool selection_clear_event_impl (const Gdk::EventSelection & event);
      virtual bool selection_request_event_impl (const Gdk::EventSelection & event);
      virtual bool selection_notify_event_impl (const Gdk::EventSelection & event);
      virtual bool proximity_in_event_impl (const Gdk::EventProximity & event);
      virtual bool proximity_out_event_impl (const Gdk::EventProximity & event);
      virtual bool visibility_notify_event_impl (const Gdk::EventVisibility & event);
      virtual bool client_event_impl (const Gdk::EventClient & event);
      virtual bool no_expose_event_impl (const Gdk::Event & event);


      virtual void selection_get_impl (Gtk::SelectionData * data,
                                       unsigned int info,
                                       unsigned int time);
      virtual void selection_received_impl (const Gtk::SelectionData & data,
                                            unsigned int time);

      virtual void drag_begin_impl (Gtk::DragContext * context);
      virtual void drag_end_impl (Gtk::DragContext * context);
      virtual void drag_data_get_impl (Gtk::DragContext * context,
                                       Gtk::SelectionData * data,
                                       unsigned int info,
                                       unsigned int time);
      virtual void drag_data_delete_impl (Gtk::DragContext * context);

      virtual void drag_leave_impl (Gtk::DragContext * context,
                                    unsigned int time);
      virtual bool drag_motion_impl (Gtk::DragContext * context,
                                     int x,
                                     int y,
                                     unsigned int time);
      virtual bool drag_drop_impl (Gtk::DragContext * context,
                                   int x, int y,
                                   unsigned int time);
      virtual void drag_data_received_impl (Gtk::DragContext * context,
                                            int x, int y,
                                            const Gtk::SelectionData & sel_data,
                                            unsigned int info,
                                            unsigned int time);
      
      virtual void on_destroy ();
      virtual void on_show ();
      virtual void on_hide ();
      virtual void on_realize ();
      virtual void on_unrealize ();
      virtual void on_draw (const Gdk::Rectangle & area);
      virtual void on_draw_focus ();
      virtual void on_draw_default ();
      virtual void on_size_request (Requisition * requisition);
      virtual void on_size_allocate (const Allocation& allocation);
      virtual void on_state_changed (StateType previous_state);
      virtual void on_parent_set (Widget * parent);
      virtual void on_style_set (Style * previous_style);
      virtual void on_grab_focus ();
      virtual bool on_event (const Gdk::Event & event);
      virtual bool on_button_press_event (const Gdk::EventButton & event);
      virtual bool on_button_release_event (const Gdk::EventButton & event);
      virtual bool on_scroll_event (const Gdk::EventScroll & event);
      virtual bool on_motion_notify_event (const Gdk::EventMotion & event);
      virtual bool on_delete_event (const Gdk::Event & event);
      virtual bool on_expose_event (const Gdk::EventExpose & event);
      virtual bool on_key_press_event (const Gdk::EventKey & event);
      virtual bool on_key_release_event (const Gdk::EventKey & event);
      virtual bool on_enter_notify_event (const Gdk::EventCrossing & event);
      virtual bool on_leave_notify_event (const Gdk::EventCrossing & event);
      virtual bool on_configure_event (const Gdk::EventConfigure & event);
      virtual bool on_focus_in_event (const Gdk::EventFocus & event);
      virtual bool on_focus_out_event (const Gdk::EventFocus & event);
      virtual bool on_map_event (const Gdk::Event & event);
      virtual bool on_unmap_event (const Gdk::Event & event);
      virtual bool on_property_notify_event (const Gdk::EventProperty & event);
      virtual bool on_selection_clear_event (const Gdk::EventSelection & event);
      virtual bool on_selection_request_event (const Gdk::EventSelection & event);
      virtual bool on_selection_notify_event (const Gdk::EventSelection & event);
      virtual bool on_proximity_in_event (const Gdk::EventProximity & event);
      virtual bool on_proximity_out_event (const Gdk::EventProximity & event);
      virtual bool on_visibility_notify_event (const Gdk::EventVisibility & event);
      virtual bool on_client_event (const Gdk::EventClient & event);
      virtual bool on_no_expose_event (const Gdk::Event & event);

      virtual void on_selection_get (Gtk::SelectionData * data,
                                     unsigned int info,
                                     unsigned int time);
      virtual void on_selection_received (const Gtk::SelectionData & data,
                                          unsigned int time);

      virtual void on_drag_begin (Gtk::DragContext * context);
      virtual void on_drag_end (Gtk::DragContext * context);
      virtual void on_drag_data_get (Gtk::DragContext * context,
                                     Gtk::SelectionData * data,
                                     unsigned int info,
                                     unsigned int time);
      virtual void on_drag_data_delete (Gtk::DragContext * context);

      virtual void on_drag_leave (Gtk::DragContext * context,
                                  unsigned int time);
      virtual bool on_drag_motion (Gtk::DragContext * context,
                                   int x,
                                   int y,
                                   unsigned int time);
      virtual bool on_drag_drop (Gtk::DragContext * context,
                                 int x, int y,
                                 unsigned int time);
      virtual void on_drag_data_received (Gtk::DragContext * context,
                                          int x, int y,
                                          const Gtk::SelectionData & sel_data,
                                          unsigned int info,
                                          unsigned int time);
      
    private:
      Widget(const Widget&);
      Widget& operator=(const Widget&);

      virtual void sink_impl ();
      virtual bool floating () const;
      
      // Virtual functions that are not associated with signals
      static void map_proxy (GtkWidget * obj);
      static void unmap_proxy (GtkWidget * obj);
      static void show_all_proxy (GtkWidget * w);
      static void hide_all_proxy (GtkWidget * w);
      
      // Virtual functions that are associated with signals
      static void destroy_proxy (GtkObject * obj);
      static void show_proxy (GtkWidget * w);
      static void hide_proxy (GtkWidget * w);
      static void realize_proxy (GtkWidget * w);
      static void unrealize_proxy (GtkWidget * w);
      static void draw_proxy (GtkWidget * w, GdkRectangle * area);
      static void draw_focus_proxy (GtkWidget * w);
      static void draw_default_proxy (GtkWidget * w);
      static void size_request_proxy (GtkWidget * w, GtkRequisition * requisition);
      static void size_allocate_proxy (GtkWidget *obj,
                                       GtkAllocation * allocation);
      static void state_changed_proxy (GtkWidget * w, GtkStateType state);
      static void parent_set_proxy (GtkWidget * w, GtkWidget * parent);
      static void style_set_proxy (GtkWidget * w, GtkStyle * previous_style);
      static void grab_focus_proxy (GtkWidget * w);

      static gint event_proxy (GtkWidget * w,
                               GdkEvent * event);
      static gint button_press_event_proxy (GtkWidget * w,
                                            GdkEventButton * event);
      static gint button_release_event_proxy (GtkWidget * w,
                                              GdkEventButton * event);
      static gint scroll_event_proxy (GtkWidget * w,
                                      GdkEventScroll * event);
      static gint motion_notify_event_proxy (GtkWidget * w,
                                             GdkEventMotion * event);
      static gint delete_event_proxy  (GtkWidget * w,
                                       GdkEventAny * event);
      static gint expose_event_proxy (GtkWidget * w,
                                      GdkEventExpose * event);
      static gint key_press_event_proxy (GtkWidget * w,
                                         GdkEventKey * event);
      static gint key_release_event_proxy (GtkWidget * w,
                                           GdkEventKey * event);
      static gint enter_notify_event_proxy (GtkWidget * w,
                                            GdkEventCrossing * event);
      static gint leave_notify_event_proxy (GtkWidget * w,
                                            GdkEventCrossing * event);
      static gint configure_event_proxy (GtkWidget * w,
                                         GdkEventConfigure * event);
      static gint focus_in_event_proxy (GtkWidget * w,
                                        GdkEventFocus * event);
      static gint focus_out_event_proxy (GtkWidget * w,
                                         GdkEventFocus * event);
      static gint map_event_proxy (GtkWidget * w,
                                   GdkEventAny * event);
      static gint unmap_event_proxy (GtkWidget * w,
                                     GdkEventAny * event);
      static gint property_notify_event_proxy (GtkWidget * w,
                                               GdkEventProperty * event);
      static gint selection_clear_event_proxy (GtkWidget * w,
                                               GdkEventSelection * event);
      static gint selection_request_event_proxy (GtkWidget * w,
                                                 GdkEventSelection * event);
      static gint selection_notify_event_proxy (GtkWidget * w,
                                                GdkEventSelection * event);
      static gint proximity_in_event_proxy (GtkWidget * w,
                                            GdkEventProximity * event);
      static gint proximity_out_event_proxy (GtkWidget * w,
                                             GdkEventProximity * event);
      static gint visibility_notify_event_proxy (GtkWidget * w,
                                                 GdkEventVisibility * event);
      static gint client_event_proxy (GtkWidget * w,
                                      GdkEventClient * event);
      static gint no_expose_event_proxy (GtkWidget * w,
                                         GdkEventAny * event);

      static void selection_get_proxy (GtkWidget *widget,
                                       GtkSelectionData *selection_data,
                                       guint info,
                                       guint time);
      static void selection_received_proxy (GtkWidget *widget,
                                            GtkSelectionData *selection_data,
                                            guint time);


      static void drag_begin_proxy (GtkWidget *widget,
                                        GdkDragContext *context);
      static void drag_end_proxy (GtkWidget *widget,
                                  GdkDragContext *context);
      static void drag_data_get_proxy (GtkWidget *widget,
                                       GdkDragContext *context,
                                       GtkSelectionData *selection_data,
                                       guint info,
                                       guint time);
      static void drag_data_delete_proxy (GtkWidget *widget,
                                          GdkDragContext *context);

      static void drag_leave_proxy (GtkWidget *widget,
                                    GdkDragContext *context,
                                    guint time);
      static gboolean drag_motion_proxy (GtkWidget *widget,
                                         GdkDragContext *context,
                                         gint x,
                                         gint y,
                                         guint time);
      static gboolean drag_drop_proxy (GtkWidget *widget,
                                       GdkDragContext *context,
                                       gint x,
                                       gint y,
                                       guint time);
      static void drag_data_received_proxy (GtkWidget *widget,
                                            GdkDragContext *context,
                                            gint x,
                                            gint y,
                                            GtkSelectionData *selection_data,
                                            guint info,
                                            guint time);
      
    }; // class Widget

  }; // namespace Gtk

}; // namespace Inti

#endif // _INTI_GTK_WIDGET_H_
