// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "table.h"
#include "table-class.h"
#include <inti/private-util.h>
#include <inti/gtk/marshal.h>

/////////// Object

Inti::Gtk::Table::Table (unsigned int rows,
                            unsigned int columns,
                            bool homogeneous_)
  : Container ((GtkContainer*)Private::TableClass::make_proxy (),
               (GtkContainerClass*)Private::TableClass::original_class ())
{
  resize (rows, columns);
  set_homogeneous (homogeneous_);
}

Inti::Gtk::Table::Table (GtkTable *obj,
                            GtkTableClass *orig)
  : Container ((GtkContainer*)obj,
               (GtkContainerClass*)orig)
{
  
}

Inti::Gtk::Table::~Table ()
{

}

void
Inti::Gtk::Table::attach (Widget * child,
                             unsigned int left_attach,
                             unsigned int right_attach,
                             unsigned int top_attach,
                             unsigned int bottom_attach,
                             AttachOptionsField x_options,
                             AttachOptionsField y_options,
                             unsigned int x_padding,
                             unsigned int y_padding)
{
  gtk_table_attach (gtk_table (),
                    child->gtk_widget (),
                    left_attach,
                    right_attach,
                    top_attach,
                    bottom_attach,
                    (GtkAttachOptions) x_options,
                    (GtkAttachOptions) y_options,
                    x_padding,
                    y_padding);
}

void
Inti::Gtk::Table::set_row_spacing (unsigned int row,
                                      unsigned int spacing)
{
  gtk_table_set_row_spacing (gtk_table (), row, spacing);
}

void
Inti::Gtk::Table::set_column_spacing (unsigned int column,
                                         unsigned int spacing)
{
  gtk_table_set_col_spacing (gtk_table (), column, spacing);
}

void
Inti::Gtk::Table::set_row_spacings (unsigned int spacing)
{
  gtk_table_set_row_spacings (gtk_table (), spacing);
}

void
Inti::Gtk::Table::set_column_spacings (unsigned int spacing)
{
  gtk_table_set_col_spacings (gtk_table (), spacing);
}

void
Inti::Gtk::Table::set_homogeneous (bool setting)
{
  gtk_table_set_homogeneous (gtk_table (), setting);
}

unsigned int
Inti::Gtk::Table::row_spacings () const
{
  return gtk_table ()->row_spacing;
}

unsigned int
Inti::Gtk::Table::column_spacings () const
{
  return gtk_table ()->column_spacing;
}

unsigned int
Inti::Gtk::Table::row_spacing (unsigned int row) const
{
  g_return_val_if_fail (row < gtk_table ()->nrows, 0);

  return gtk_table ()->rows[row].spacing;
}

unsigned int
Inti::Gtk::Table::column_spacing (unsigned int column) const
{
  g_return_val_if_fail (column < gtk_table ()->ncols, 0);

  return gtk_table ()->cols[column].spacing;
}

bool
Inti::Gtk::Table::homogeneous () const
{
  return gtk_table ()->homogeneous;
}

/////////// Everything below here is machine-generated
void
Inti::Gtk::Table::resize (unsigned int rows, unsigned int columns)
{
   gtk_table_resize (gtk_table (), rows, columns);
}
