// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GTK_OPTIONMENU_H_
#define _INTI_GTK_OPTIONMENU_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gtk/button.h>
#include <inti/gtk/gtkbase.h>
#include <gtk/gtkoptionmenu.h>

namespace Inti
{  
  namespace Gtk
  {
    namespace Private
    {
      class OptionMenuClass;
    };

    class Menu;
    class MenuItem;
    
    class OptionMenu : public Button
    {
    public:
        
      GtkOptionMenu * gtk_option_menu () const
      {
        return (GtkOptionMenu*)g_object ();
      }
      
      OptionMenu ();
      OptionMenu (Menu * menu);
      
      Menu * menu () const;
      void set_menu (Menu * menu);
      void remove_menu ();

      int history () const;
      void set_history (int history);

      MenuItem * active () const;
      void set_active (MenuItem * menu_item);
      
    protected:
      friend class Private::OptionMenuClass;
      
      explicit OptionMenu (GtkOptionMenu *src, GtkOptionMenuClass *orig);
      virtual ~OptionMenu ();
      
    private:
      OptionMenu(const OptionMenu&);
      OptionMenu& operator=(const OptionMenu&);
      
    }; // class OptionMenu

  }; // namespace Gtk
  
}; // namespace Inti

#endif // _INTI_GTK_OPTIONMENU_H_
