// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This source file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
#include "accelerators.h"
#include <gtk/gtkaccelgroup.h>

void
Inti::Gtk::Accelerator::unserialize (const string & spec)
{
  unserialize (spec.c_str ());
}

void
Inti::Gtk::Accelerator::unserialize (const char * spec)
{
  if (spec)
    gtk_accelerator_parse (spec,
                           &keyval_,
                           (GdkModifierType*)&modifiers_);
  else
    {
      keyval_ = 0;
      modifiers_ = default_modifiers ();
    }
}

Inti::ustring
Inti::Gtk::Accelerator::serialize () const
{
  gchar * s = gtk_accelerator_name (keyval_, (GdkModifierType) modifiers_);

  ustring str (s);

  g_free (s);

  return str;
}

bool
Inti::Gtk::Accelerator::valid () const
{
  return gtk_accelerator_valid (keyval_, (GdkModifierType) modifiers_);
}

void
Inti::Gtk::Accelerator::set_key_val (unsigned int val)
{
  keyval_ = val;
}

void
Inti::Gtk::Accelerator::set_modifiers (Gdk::ModifierTypeField mods)
{
  modifiers_ = mods;
}

Inti::Gtk::Accelerator::Accelerator (const string & spec)
  : keyval_ (0), modifiers_ (default_modifiers ())
{
  unserialize (spec);
}

Inti::Gtk::Accelerator::Accelerator (const char * spec)
  : keyval_ (0), modifiers_ (default_modifiers ())
{
  unserialize (spec);
}

Inti::Gtk::Accelerator::Accelerator (unsigned int keyval, Gdk::ModifierTypeField mod)
  : keyval_ (keyval), modifiers_ (default_modifiers ())
{
  
}

Inti::Gtk::Accelerator::Accelerator (unsigned int keyval)
  : keyval_ (keyval), modifiers_ (default_modifiers ())
{
  
}

void
Inti::Gtk::Accelerator::set_default_modifiers (Gdk::ModifierTypeField mods)
{
  gtk_accelerator_set_default_mod_mask ((GdkModifierType) mods);

}

Inti::Gdk::ModifierTypeField
Inti::Gtk::Accelerator::default_modifiers ()
{
  return (Gdk::ModifierTypeField) gtk_accelerator_get_default_mod_mask ();
}



/////////// Everything below here is machine-generated
