// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GDK_WINDOW_H_
#define _INTI_GDK_WINDOW_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <inti/gdk/drawable.h>
#include <inti/gdk/gdkbase.h>
#include <gdk/gdkwindow.h>
#include <inti/utf-string.h>

/*$ doc header
  $short The #Inti::Gdk::Window class (a primitive window in the target
  windowing system)
  $*/

namespace Inti
{  
  namespace Gdk
  {
    namespace Private
    {
      class WindowClass;
    }; // namespace Private

    class Visual;
    class Cursor;
    class Pixmap;
    class Bitmap;

    typedef enum
    {
      DECOR_ALL = GDK_DECOR_ALL,
      DECOR_BORDER = GDK_DECOR_BORDER,
      DECOR_RESIZEH = GDK_DECOR_RESIZEH,
      DECOR_TITLE = GDK_DECOR_TITLE,
      DECOR_MENU = GDK_DECOR_MENU,
      DECOR_MINIMIZE = GDK_DECOR_MINIMIZE,
      DECOR_MAXIMIZE = GDK_DECOR_MAXIMIZE
    } WMDecoration;
    typedef unsigned int WMDecorationField;
    
    typedef enum
    {
      FUNC_ALL = GDK_FUNC_ALL,
      FUNC_RESIZE = GDK_FUNC_RESIZE,
      FUNC_MOVE = GDK_FUNC_MOVE,
      FUNC_MINIMIZE = GDK_FUNC_MINIMIZE,
      FUNC_MAXIMIZE = GDK_FUNC_MAXIMIZE,
      FUNC_CLOSE = GDK_FUNC_CLOSE
    } WMFunction;
    typedef unsigned int WMFunctionField;
    
    class Geometry
    {
    public:
      Geometry ();
      // default copy, assignment, destructor

      void set_min_size (int width, int height);
      void set_max_size (int width, int height);
      void set_base_size (int width, int height);
      void set_resize_increments (int width_inc, int height_inc);
      void set_aspect_range (double min_aspect_ratio,
                             double max_aspect_ratio);

      void unset_min_size ();
      void unset_max_size ();
      void unset_base_size ();
      void unset_resize_increments ();
      void unset_aspect_range ();

      bool min_size_set () const
      {
        return (hints_ & GDK_HINT_MIN_SIZE) != 0;
      }

      bool max_size_set () const
      {
        return (hints_ & GDK_HINT_MAX_SIZE) != 0;
      }

      bool base_size_set () const
      {
        return (hints_ & GDK_HINT_BASE_SIZE) != 0;
      }

      bool aspect_range_set () const
      {
        return (hints_ & GDK_HINT_ASPECT) != 0;
      }

      bool resize_increments_set () const
      {
        return (hints_ & GDK_HINT_RESIZE_INC) != 0;
      }
        
      int min_width () const { return geometry_.min_width; }
      int min_height () const { return geometry_.min_height; }
      int max_width () const { return geometry_.max_width; }
      int max_height () const { return geometry_.max_height; }
      int base_width () const { return geometry_.base_width; }
      int base_height () const { return geometry_.base_height; }
      int width_increment () const { return geometry_.width_inc; }
      int height_increment () const { return geometry_.height_inc; }
      double min_aspect_ratio () const { return geometry_.min_aspect; }
      double max_aspect_ratio () const { return geometry_.max_aspect; }
        
      GdkGeometry * gdk_geometry () const
      {
        return const_cast<GdkGeometry*>(&geometry_);
      }

      GdkWindowHints gdk_window_hints () const
      {
        return (GdkWindowHints) hints_;
      }
        
    private:
      GdkGeometry geometry_;
      int hints_;

    }; // class Geometry
    
    class Window : public Drawable
    {
    public:
      GdkWindow * gdk_window () const
      {
        return (GdkWindow*)gdk_drawable ();
      }

      typedef enum
      {
        INPUT_OUTPUT = GDK_INPUT_OUTPUT,
        INPUT_ONLY = GDK_INPUT_ONLY
      } Class;

      // We don't use a straight wrap of GdkWindowType,
      // because we want only those types that are valid
      // for creating new windows.
      typedef enum
      {
        TOPLEVEL = GDK_WINDOW_TOPLEVEL,
        CHILD = GDK_WINDOW_CHILD,
        DIALOG = GDK_WINDOW_DIALOG,
        TEMP = GDK_WINDOW_TEMP
      } Type;
      
      class Attributes
      {
      public:

        Attributes (Type t,
                    Class c,
                    EventMaskField mask,
                    int width,
                    int height);

        ~Attributes ();

        Attributes (const Attributes & src);
        Attributes & operator=(const Attributes & src);
        
        void set_title (const string & title);
        void set_title (const char * title);
        void set_event_mask (EventMaskField mask);
        void set_position (int x, int y);
        void set_position (const Point & point);
        void set_size (int width, int height);
        void set_visual (const Visual & visual);
        // FIXME void set_colormap ();
        void set_cursor (const Cursor & cursor);
        void set_wm_class (const string & wm_class,
                           const string & wm_name);
        void set_wm_class (const char * wm_class,
                           const char * wm_name);
        void set_override_redirect (bool setting);
        
        void unset_title ();
        void unset_visual ();
        void unset_colormap ();
        void unset_cursor ();
        void unset_wm_class ();
        void unset_override_redirect ();

        bool title_set () const
        {
          return (attr_mask_ & GDK_WA_TITLE) != 0;
        }

        bool visual_set () const
        {
          return (attr_mask_ & GDK_WA_VISUAL) != 0;
        }

        bool colormap_set () const
        {
          return (attr_mask_ & GDK_WA_COLORMAP) != 0;
        }
        
        bool cursor_set () const
        {
          return (attr_mask_ & GDK_WA_CURSOR) != 0;
        }

        bool wm_class_set () const
        {
          return (attr_mask_ & GDK_WA_WMCLASS) != 0;
        }

        bool override_redirect_set () const
        {
          return (attr_mask_ & GDK_WA_NOREDIR) != 0;
        }


        const ustring & title () const { return title_; }
        int event_mask () const { return attr_.event_mask; }
        int x () const { return attr_.x; }
        int y () const { return attr_.y; }
        int width () const { return attr_.width; }
        int height () const { return attr_.height; }
        Class window_class () const { return (Class) attr_.wclass; }
        const Visual & visual () const { return *visual_; }
        // FIXME colormap
        Type window_type () const { return (Type) attr_.window_type; }
        const Cursor & cursor () const { return *cursor_; }
        const ustring & wm_name () const { return wm_name_; }
        const ustring & wm_class () const { return wm_class_; }
        bool override_redirect () const { return attr_.override_redirect; }
        
        GdkWindowAttr * gdk_window_attr () const;
        GdkWindowAttributesType gdk_window_attributes_type () const;
        
      private:
        mutable GdkWindowAttr attr_;
        int attr_mask_;
        Cursor * cursor_;
        const Visual * visual_;
        // FIXME colormap
        ustring title_;
        ustring wm_name_;
        ustring wm_class_;
      };

      Window (Window * parent,
              const Attributes & attributes);

      void destroy ();

      Type type ();
      
      void show ();
      void hide ();
      void withdraw ();
      void move (int x, int y);
      void resize (int width, int height);
      void move_resize (int x, int y, int width, int height);
      void reparent (Window * parent,
                     int x, int y);
      void clear ();
      void clear (int x, int y, int width, int height);
      void raise ();
      void lower ();

      void set_override_redirect (bool setting);

      void shape_combine_mask (Bitmap * shape_mask,
                               int x_offset,
                               int y_offset);

      bool is_visible () const;
      bool is_viewable () const;

      bool set_static_gravities (bool setting);
      void set_geometry_hints (const Geometry & geometry);

      void begin_paint (const Rectangle & rect);
      void begin_paint (const Region & region);
      void end_paint ();

      void set_title (const string & str);
      void set_title (const char * str);
      void set_role (const string & str);
      void set_role (const char * str);

      void set_transient_for (Window * transient_parent);

      void set_background (const Color & color);
      void unset_background ();

      void set_background_pixmap (Pixmap * pixmap,
                                  bool parent_relative = false);

      void set_cursor (const Cursor & cursor);
      void unset_cursor ();
      
      void get_geometry (int * x, int * y,
                         int * width, int * height, int * depth = 0) const;

      void get_position (int * x, int * y) const;

      // FIXME the three origin functions

      Window * get_pointer (int * x, int * y, ModifierTypeField * modifiers) const;

      Window * parent () const;

      Window * toplevel () const;

      vector<Window*> children () const;

      EventMaskField events () const;
      void set_events (EventMaskField event_mask);

      void set_icon (Window * window);
      void set_icon (Bitmap * icon, Bitmap * mask);

      void set_icon_name (const string & str);
      void set_icon_name (const char * str);

      void set_group (Window * group_leader);

      void set_decorations (WMDecorationField decorations);
      void set_functions (WMFunctionField functions);

      void register_dnd ();

      void invalidate (const Rectangle & rect, bool invalidate_children);
      void invalidate (const Region & region, bool invalidate_children);

      Region * get_update_area () const;

      void freeze_updates ();
      void thaw_updates ();
      
      void process_updates (bool update_children);

      static void process_all_updates ();
      static vector<Window*> list_toplevels ();
      
    protected:
      friend class Private::WindowClass;
      explicit Window (GdkWindowObject * src, GdkWindowObjectClass *orig);

    private:
      virtual ~Window ();
      Window (const Window&);
      Window& operator=(const Window&);

    };

    Window * window_at_pointer (int * x, int * y);
    
  }; // namespace Gdk
  
}; // namespace Inti

#endif // _INTI_GDK_WINDOW_H_
