// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_GDK_DRAWABLE_H_
#define _INTI_GDK_DRAWABLE_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gdk/gdkdrawable.h>
#include <inti/object.h>
#include <inti/gdk/gdkbase.h>
#include <inti/gdk/gc.h>

namespace Inti
{  

  namespace Gdk
  {

    class Drawable;
    class Visual;    
    class Colormap;
    class Image;
    
    namespace Private
    {
      class DrawableClass;
    }; // namespace Private
    
    class Drawable : public Object
    {
    public:
      GdkDrawable * gdk_drawable () const { return (GdkDrawable*) g_object (); }
      
      int width () const;
      int height () const;

      void get_size (int * width, int * height) const; 

      const Visual & visual () const;
      int depth () const;

      void set_colormap (Colormap * cmap);
      Colormap * colormap () const;

      GC * create_gc () const;
      GC * create_gc (const GC::Values & values) const;

      void draw_point (GC * gc, int x, int y);
      void draw_point (GC * gc, const Point & point);


      void draw_points (GC * gc,
                        const vector<Point> & points);

      void draw_points (GC * gc,
                        const Point * points_array,
                        unsigned int points_array_length);
      
      void draw_line (GC * gc,
                      int x1, int y1, int x2, int y2);
      void draw_line (GC * gc,
                      const Point & point1,
                      const Point & point2);
      
      void draw_lines (GC * gc,
                       const vector<Point> & points);

      void draw_lines (GC * gc,
                       const Point * points_array,
                       unsigned int points_array_length);
      
      void draw_segments (GC * gc,
                          const vector<Segment> & segments);

      void draw_segments (GC * gc,
                          const Segment * segments_array,
                          unsigned int segments_array_length);
      
      void draw_rectangle (GC * gc,
                           bool filled,
                           int x, int y, int width, int height);

      void draw_rectangle (GC * gc,
                           bool filled,
                           const Gdk::Rectangle & rect);
      
      void draw_arc (GC * gc,
                     bool filled,
                     int x, int y, int width, int height,
                     int angle1, int angle2);

      void draw_polygon (GC * gc,
                         bool filled,
                         const vector<Point> & points);

      void draw_polygon (GC * gc,
                         bool filled,
                         const Point * points_array,
                         unsigned int points_array_length);

      // FIXME text-drawing stuff

      void draw_drawable (GC * gc,
                          Drawable * src,
                          int src_x, int src_y,
                          int dest_x, int dest_y,
                          int width, int height);

      void draw_image (GC * gc,
                       Image * src,
                       int src_x, int src_y,
                       int dest_x, int dest_y,
                       int width, int height);
      

      Image * get_image (int x, int y,
                         int width, int height) const;
      
    protected:
      virtual ~Drawable () = 0; // abstract base class
      Drawable (GdkDrawable * src, GdkDrawableClass * orig);
      Drawable ();
      
      virtual GC * create_gc_impl (const GC::Values & values);
      virtual GC * create_gc_impl ();
      
      virtual void draw_rectangle_impl (GC * gc,
                                        bool filled,
                                        int x, int y,
                                        int width, int height);
      virtual void draw_arc_impl (GC * gc,
                                  bool filled,
                                  int x, int y,
                                  int width, int height,
                                  int angle1, int angle2);

      virtual void draw_polygon_impl (GC * gc,
                                      bool filled,
                                      const Point * points_array,
                                      unsigned int points_array_length);

      // FIXME text

      virtual void draw_drawable_impl (GC * gc,
                                       Drawable * drawable,
                                       int src_x, int src_y,
                                       int dest_x, int dest_y,
                                       int width, int height);

      virtual void draw_points_impl (GC * gc,
                                     const Point * points_array,
                                     unsigned int points_array_length);

      virtual void draw_segments_impl (GC * gc,
                                       const Segment * segments_array,
                                       unsigned int segments_array_length);

      virtual void draw_lines_impl (GC * gc,
                                    const Point * points_array,
                                    unsigned int points_array_length);

      virtual void draw_image_impl (GC * gc,
                                    Image * image,
                                    int src_x, int src_y,
                                    int dest_x, int dest_y,
                                    int width, int height);

      virtual int depth_impl ();
      virtual void get_size_impl (int * width, int * height);
      virtual void set_colormap_impl (Colormap * cmap);
      virtual Colormap * colormap_impl ();
      virtual const Visual & visual_impl ();
      
    private:
      Drawable (const Drawable&);
      Drawable& operator=(const Drawable&);

      friend class Private::DrawableClass;
      
      static GdkGC *create_gc_proxy (GdkDrawable *drawable,
                                     GdkGCValues *values,
                                     GdkGCValuesMask mask);
      static void draw_rectangle_proxy (GdkDrawable  *drawable,
                                        GdkGC *gc,
                                        gint filled,
                                        gint x,
                                        gint y,
                                        gint width,
                                        gint height);
      static void draw_arc_proxy (GdkDrawable  *drawable,
                                  GdkGC *gc,
                                  gint filled,
                                  gint x,
                                  gint y,
                                  gint width,
                                  gint height,
                                  gint angle1,
                                  gint angle2);
      static void draw_polygon_proxy (GdkDrawable  *drawable,
                                      GdkGC *gc,
                                      gint filled,
                                      GdkPoint *points,
                                      gint npoints);
      static void draw_drawable_proxy (GdkDrawable  *drawable,
                                       GdkGC *gc,
                                       GdkDrawable *src,
                                       gint xsrc,
                                       gint ysrc,
                                       gint xdest,
                                       gint ydest,
                                       gint width,
                                       gint height);
      static void draw_points_proxy (GdkDrawable *drawable,
                                     GdkGC *gc,
                                     GdkPoint *points,
                                     gint npoints);
      static void draw_segments_proxy (GdkDrawable *drawable,
                                       GdkGC *gc,
                                       GdkSegment *segs,
                                       gint nsegs);
      static void draw_lines_proxy (GdkDrawable *drawable,
                                    GdkGC *gc,
                                    GdkPoint *points,
                                    gint npoints);

      static void draw_image_proxy (GdkDrawable *drawable,
                                    GdkGC *gc,
                                    GdkImage *image,
                                    gint xsrc,
                                    gint ysrc,
                                    gint xdest,
                                    gint ydest,
                                    gint width,
                                    gint height);
  
      static gint get_depth_proxy (GdkDrawable *drawable);
      static void get_size_proxy (GdkDrawable *drawable,
                                  gint *width,
                                  gint *height);

      static void set_colormap_proxy (GdkDrawable *drawable,
                                      GdkColormap *cmap);
      
      static GdkColormap* get_colormap_proxy (GdkDrawable *drawable);
      static GdkVisual*   get_visual_proxy (GdkDrawable *drawable);
      
    };
    
  }; // namespace Gdk
  
}; // namespace Inti

#endif // _INTI_GDK_DRAWABLE_H_
