// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
#ifndef _INTI_BASE_DESTROY_NOTIFY_H_
#define _INTI_BASE_DESTROY_NOTIFY_H_

/*
  Inti is a C++ development platform based on glib, GTK+, and the
  Standard Template Library. This header file is machine-generated
  by a script; do not edit it directly.

  This file is distributed under the GNU Library General Public License.
*/
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <vector>

/*$ doc header
  $short the #Inti::DestroyNotifier class, which notifies the
  a #Inti::DestroyListener instance when it's destroyed
  $*/

namespace Inti
{
  class DestroyListener;
  
  class DestroyNotifier
  {
  public:
    virtual ~DestroyNotifier();

    // Note that THE SAME listener can be added multiple times,
    // and if so can be removed the same number of times.
    virtual void add_destroy_listener (DestroyListener * listener) = 0;
    virtual void remove_destroy_listener (DestroyListener * listener) = 0;
    
  };
  
  class DestroyListener
  {
  public:
    virtual ~DestroyListener();
    
    // the DestroyNotifier may be half-destroyed at this point,
    // so don't go doing anything with it.
    virtual void notifier_destroyed (const DestroyNotifier * notifier) = 0;
  };
  

  class SimpleDestroyNotifier : public DestroyNotifier
  {
  public:
    virtual ~SimpleDestroyNotifier();

    virtual void add_destroy_listener (DestroyListener * listener);
    virtual void remove_destroy_listener (DestroyListener * listener);

  private:
    vector<DestroyListener*> listeners_;
  };
  
}; // namespace Inti

#endif // _INTI_BASE_DESTROY_NOTIFY_H_
