// -*- C++ -*-
// Copyright (C) 2000 Red Hat, Inc.
// Typing game example
/*
  The following license applies to this example code, but not to
  the Inti library itself:
  
    Permission is hereby granted, free of charge, to any person obtaining
    a copy of this software and associated documentation files (the
    "Software"), to deal in the Software without restriction, including
    without limitation the rights to use, copy, modify, merge, publish,
    distribute, sublicense, and/or sell copies of the Software, and to
    permit persons to whom the Software is furnished to do so, subject to
    the following conditions:

    The above copyright notice and this permission notice shall be
    included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
    DISTRIBUTOR OF THE SOFTWARE BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
    OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
    OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "gameview.h"
#include "game.h"
#include "player.h"
#include <inti/main.h>
#include <inti/gtk/window.h>
#include <iostream>

class MainWindow : public Gtk::Window
{
public:
  MainWindow ();

protected:
  ~MainWindow ();

  virtual bool key_press_event_impl (const Gdk::EventKey & event);
  virtual void on_destroy ();
  
private:
  Player * player_;
  Game * game_;
  ptr<GameView> view_;
};

int
main (int argc, char ** argv)
{
  Gtk::init (&argc, &argv);

  Main::Loop loop;
  
  ptr<MainWindow> mw (new MainWindow);

  mw->show ();
  
  loop.run ();
  
  return 0;
}

///////////////////////////////////

MainWindow::MainWindow ()
{
  set_default_size (400, 400);
  
  player_ = new Player;
  game_ = new Game (player_);
  view_ = new GameView;
  
  view_->set_game (game_);

  add (view_);
  view_->show ();
}

MainWindow::~MainWindow ()
{
  if (view_)
    view_->set_game (0);
  
  if (game_)
    delete game_;

  if (player_)
    delete player_;
}

bool
MainWindow::key_press_event_impl (const Gdk::EventKey & event)
{
  if (game_ && game_->process_key (event))
    return true;
  else
    return Gtk::Window::key_press_event_impl (event);
}

void
MainWindow::on_destroy ()
{
  if (Main::primary ())
    Main::primary ()->quit ();
}

