
#include <gtk/gtk.h>
#include <stdio.h>

static gint
delete_event_callback (GtkWidget * window, GdkEventAny * event, gpointer data)
{
  gtk_main_quit ();
  return FALSE;
}

static void
clicked_callback (GtkWidget * button, gpointer data)
{
  printf ("I was clicked!\n");
}

int
main (int argc, char ** argv)
{
  GtkWidget * window;
  GtkWidget * button;
  
  gtk_init (&argc, &argv);

  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  button = gtk_button_new_with_label ("Hello, World!");

  gtk_container_add (GTK_CONTAINER (window), button);

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                      GTK_SIGNAL_FUNC (delete_event_callback),
                      NULL);

  gtk_signal_connect (GTK_OBJECT (button), "clicked",
                      GTK_SIGNAL_FUNC (clicked_callback),
                      NULL);
  
  gtk_widget_show_all (window);

  gtk_main ();
  
  return 0;
}
