/* $Id: switch.xc,v 1.2 1996/10/24 17:26:14 jt Exp $ */
/* Switch between various algorithms at run-time, using the function
   gsl_ran_use_xxx() to start using xxx.  The function gsl_ran_name()
   returns the name of the algorithm currently in use.
   */

#include "gsl_ran.h"         /* defines gsl_ran_ prototypes */

#define MAXALGNAMELEN 10        /* only short algorithm names allowed */
typedef struct {
    char name[MAXALGNAMELEN];
    unsigned long (*random_wstate)(void *);
    double (*uniform_wstate)(void *);
    double (*max)();
    void (*seed_wstate)(void *,int);
    unsigned long (*random)();
    double (*uniform)();
    void (*seed)();
    void *(*getRandomState)();
    void (*setRandomState)(void *);    
} AlgorithmSwitch;

AlgorithmSwitch A;

char *gsl_ran_name() {
    return A.name;
}

inline unsigned long gsl_ran_random_wstate(void *vState) {
    return A.random_wstate(vState);
}
inline double gsl_ran_uniform_wstate(void *vState) {
    return A.uniform_wstate(vState);
}
inline double gsl_ran_max() {
    return A.max();
}
inline void gsl_ran_seed_wstate(void *vState, int seed) {
    A.seed_wstate(vState,seed);
}
inline unsigned long gsl_ran_random() {
    return A.random();
}
inline double gsl_ran_uniform() {
    return A.uniform();
}
inline void gsl_ran_seed(int seed) {
    A.seed(seed);
}
inline void *gsl_ran_getRandomState() {
    return A.getRandomState();
}
inline void gsl_ran_setRandomState(void *vState) {
    A.setRandomState(vState);
}

/*
 * The following function is a template which the shell script will
 * expand into a set of funtions, one for each algorithm: mrg, cmrg, etc
 */
#include "mrg.h"
void gsl_ran_use_mrg() {
    strncpy(A.name,"mrg",MAXALGNAMELEN);
    A.random_wstate = gsl_ran_mrg_random_wstate;
    A.uniform_wstate = gsl_ran_mrg_uniform_wstate;
    A.max = gsl_ran_mrg_max;
    A.random = gsl_ran_mrg_random;
    A.uniform = gsl_ran_mrg_uniform;
    A.seed = gsl_ran_mrg_seed;
    A.getRandomState = gsl_ran_mrg_getRandomState;
    A.setRandomState = gsl_ran_mrg_setRandomState;
}

#include "cmrg.h"
void gsl_ran_use_cmrg() {
    strncpy(A.name,"cmrg",MAXALGNAMELEN);
    A.random_wstate = gsl_ran_cmrg_random_wstate;
    A.uniform_wstate = gsl_ran_cmrg_uniform_wstate;
    A.max = gsl_ran_cmrg_max;
    A.random = gsl_ran_cmrg_random;
    A.uniform = gsl_ran_cmrg_uniform;
    A.seed = gsl_ran_cmrg_seed;
    A.getRandomState = gsl_ran_cmrg_getRandomState;
    A.setRandomState = gsl_ran_cmrg_setRandomState;
}

#include "taus.h"
void gsl_ran_use_taus() {
    strncpy(A.name,"taus",MAXALGNAMELEN);
    A.random_wstate = gsl_ran_taus_random_wstate;
    A.uniform_wstate = gsl_ran_taus_uniform_wstate;
    A.max = gsl_ran_taus_max;
    A.random = gsl_ran_taus_random;
    A.uniform = gsl_ran_taus_uniform;
    A.seed = gsl_ran_taus_seed;
    A.getRandomState = gsl_ran_taus_getRandomState;
    A.setRandomState = gsl_ran_taus_setRandomState;
}

#include "uni.h"
void gsl_ran_use_uni() {
    strncpy(A.name,"uni",MAXALGNAMELEN);
    A.random_wstate = gsl_ran_uni_random_wstate;
    A.uniform_wstate = gsl_ran_uni_uniform_wstate;
    A.max = gsl_ran_uni_max;
    A.random = gsl_ran_uni_random;
    A.uniform = gsl_ran_uni_uniform;
    A.seed = gsl_ran_uni_seed;
    A.getRandomState = gsl_ran_uni_getRandomState;
    A.setRandomState = gsl_ran_uni_setRandomState;
}

#include "uni32.h"
void gsl_ran_use_uni32() {
    strncpy(A.name,"uni32",MAXALGNAMELEN);
    A.random_wstate = gsl_ran_uni32_random_wstate;
    A.uniform_wstate = gsl_ran_uni32_uniform_wstate;
    A.max = gsl_ran_uni32_max;
    A.random = gsl_ran_uni32_random;
    A.uniform = gsl_ran_uni32_uniform;
    A.seed = gsl_ran_uni32_seed;
    A.getRandomState = gsl_ran_uni32_getRandomState;
    A.setRandomState = gsl_ran_uni32_setRandomState;
}

#include "zuf.h"
void gsl_ran_use_zuf() {
    strncpy(A.name,"zuf",MAXALGNAMELEN);
    A.random_wstate = gsl_ran_zuf_random_wstate;
    A.uniform_wstate = gsl_ran_zuf_uniform_wstate;
    A.max = gsl_ran_zuf_max;
    A.random = gsl_ran_zuf_random;
    A.uniform = gsl_ran_zuf_uniform;
    A.seed = gsl_ran_zuf_seed;
    A.getRandomState = gsl_ran_zuf_getRandomState;
    A.setRandomState = gsl_ran_zuf_setRandomState;
}

#include "rand.h"
void gsl_ran_use_rand() {
    strncpy(A.name,"rand",MAXALGNAMELEN);
    A.random_wstate = gsl_ran_rand_random_wstate;
    A.uniform_wstate = gsl_ran_rand_uniform_wstate;
    A.max = gsl_ran_rand_max;
    A.random = gsl_ran_rand_random;
    A.uniform = gsl_ran_rand_uniform;
    A.seed = gsl_ran_rand_seed;
    A.getRandomState = gsl_ran_rand_getRandomState;
    A.setRandomState = gsl_ran_rand_setRandomState;
}

