.\" Copyright (c) 1993 Free Software Foundation, Inc.
.\" See section COPYING for conditions for redistribution
.TH queue-pr 8 "October 1993" "GNATS @VERSION@" "GNATS Administration Utilities"
.de BP
.sp
.ti -.2i
\(**
..
.SH NAME
queue-pr \- incoming mail control for
.B GNATS
.SH SYNOPSIS
.hy 0
.na
.TP 1i
.B queue-pr
[
.B \-q | \-\-queue
]
[
.B \-r | \-\-run
]
.br
[
.B \-f \fIfilename\fB | \-\-file=\fIfilename\fR
]
.br
[
.B \-d \fIdirectory\fB | \-\-directory=\fIdirectory\fR
]
.ad b
.hy 1
.SH DESCRIPTION
.B `queue-pr -q' 
should run through a 
.BR pipe (2V)
via the mail 
.BR aliases (5)
mechanism to automatically place incoming bug reports in a queue 
directory for
.B GNATS.
.LP
Run
.B `queue-pr -r'
via
.BR cron (8)
to periodically empty the 
.B GNATS
queue, filing new bug reports in the database.
.LP
Always use one of [
.B \-q | \-\-queue
] or [
.B \-r | \-\-run
] (but not both), in each call to 
.B queue-pr.
These are mutually exclusive functions in order to avoid collisions.
.SH OPTIONS
.TP 1i
.B \-q, \-\-queue
Accept standard input as an incoming mail message, placing this message in
an incrementally numbered file in the directory
.B xGNATS_ROOTx/gnats-queue
for future handling.
.TP
.B \-r, \-\-run
Redirect files from the directory
.B xGNATS_ROOTx/gnats-queue
to
.BR file-pr (8)
which files and creates index entries for each.
.TP
.B \-f \fIfilename\fR or \fB\-\-file=\fIfilename\fR
Treat
.I filename
as input rather than reading from standard input (used with the
.B \-\-queue
option).
.TP
.B \-d \fIdirectory\fR or \fB\-\-directory=\fIdirectory\fR
Used with the 
.B \-\-queue
option, file incoming messages into 
.I directory
rather than 
.BR xGNATS_ROOTx/gnats-queue .

Used with the
.B \-\-run
option, operate on the files in 
.I directory
rather than 
.BR xGNATS_ROOTx/gnats-queue .
.SH FILES
.B xGNATS_ROOTx/gnats-queue
.SH "SEE ALSO"
.I Keeping Track: Managing Messages With GNATS
(also installed as the GNU Info file
.BR gnats.info )
and
.I Reporting Problems Using send-pr
(also installed as the GNU Info file
.BR send-pr.info ).
.LP
.BR gnats (l),
.BR send-pr (1),
.BR query-pr (1),
.BR edit-pr (1),
.BR file-pr (8),
.BR mkcat (8),
.BR rmcat (8),
.BR gen-index (8),
.BR mkdist (8).
.SH COPYING
Copyright (c) 1993 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
