/* Return the address for a person in the GNATS responsible file.
   Copyright (C) 1993-96, 1997 Free Software Foundation, Inc.
   Contributed by Brendan Kehoe (brendan@cygnus.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111, USA.  */

#include "config.h"
#include "gnats.h"

/* The name this program was run with.  */
char *program_name;

void usage (), version ();

/* If 1, we're running the daemon.  */
int is_daemon = 0;

struct option long_options[] =
{
  {"version", 0, NULL, 'V'},
  {"help", 0, NULL, 'h'},
  {"full", 0, NULL, 'F'},
  {"strict", 0, NULL, 's'},
  {NULL, 0, NULL, 0}
};

int
main (argc, argv)
     int argc;
     char **argv;
{
  Responsible *r;
  char *p;
  int option;
  int full = 0, strict = 0;
  char *name;
  extern char *basename ();

  program_name = (char *) basename (argv[0]);

  while ((option = getopt_long (argc, argv, "VhFs", long_options, 0)) != EOF)
    switch (option)
      {
      case 'h':
	usage ();
	return 0;

      case 'V':
	version ();
	return 0;

      case 'F':
	full = 1;
	break;

      case 's':
	strict = 1;
	break;

      default:
	usage ();
	return 3;
      }

  if (optind != argc - 1)
    {
      usage ();
      return 3;
    }

  name = argv[optind];
  if (*name == '\0')
    {
      fprintf (stderr, "%s: name must be non-null\n", program_name);
      return 3;
    }

  configure ();
  
  p = (char *) strchr (name, ' ');
  if (p != (char *) NULL)
    *p = '\0';
  p = (char *) strchr (name, '(');
  if (p != (char *) NULL)
    *p = '\0';
  r = get_responsible_address (name);
  if (r && (r->authentic || !strict))
    {
      if (full)
	printf ("%s:%s:%s\n", r->key, r->fullname, r->alias);
      else
	{
	  if (r->alias[0]
	      /* Make sure if the person putting the entry in accidentally
		 added a space after the colon, we don't accept that as
		 an address.  */
	      && isalpha (r->alias[0]))
	    printf ("%s\n", r->alias);
	  else
	    printf ("%s\n", r->key);
	}
    }
  else
    {
      fprintf (stderr, "%s: could not find the requested address\n",
	       program_name);
      return 2;
    }
  
  return 0;
}

void
usage ()
{
  fprintf (stderr, "Usage: %s [-FVhs] [--full] [--strict] [--version] [--help] name\n",
	   program_name);
}

void
version ()
{
  printf ("pr-addr %s\n", version_string);
}

