/* Routines to provide lists of the GNATS low-level files.
   Copyright (C) 1995 Free Software Foundation, Inc.
   Contributed by Brendan Kehoe (brendan@cygnus.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "config.h"
#include "gnats.h"
#include "query.h"

int
get_gnats_file (type, file)
     unsigned int type;
     char *file;
{
  char *outf = NULL, *infile;
  FILE *fpout, *fpin;
  char line[STR_MAX];
  char *path = (char *) alloca (PATH_MAX);
  extern int doret;

  if (file)
    {
      outf = (char *) xmalloc (strlen (file) + 5);
      strcpy (outf, file);
    }
  else
    fpout = stdout;

  if (type == LIST_CATEGORIES)
    {
      if (outf)
	strcat (outf, ".cat");
      infile = CATEGORIES;
    }
  else if (type == LIST_SUBMITTERS)
    {
      if (outf)
	strcat (outf, ".sub");
      infile = SUBMITTERS;
    }
  else if (type == LIST_RESPONSIBLE)
    {
      if (outf)
	strcat (outf, ".res");
      infile = RESPONSIBLE_FILE;
    }
  else if (type == LIST_STATES)
    {
      if (outf)
	strcat (outf, ".sta");
      infile = STATES;
    }
  else if (type == LIST_CLASSES)
    {
      if (outf)
	strcat (outf, ".cla");
      infile = CLASSES;
    }
  else if (type == LIST_CONFIG)
    {
      if (outf)
	strcat (outf, ".cfg");
      infile = CONFIG;
    }
  else
    {
      if (outf)
	xfree (outf);
      return -1;
    }

  if (outf)
    {
      fpout = fopen (outf, "w");
      if (fpout == (FILE *)NULL)
        return -1; /* XXX */
    }

  if (type == LIST_CLASSES)
    {
      if (class_chain != NULL)
        {
          Classes *c;
          for (c = class_chain; c; c = c->next)
            {
              fprintf (fpout, "%s:%s:%s\r\n", c->key, c->type, c->description);
            }
        }
      else
        return -1;
    }
  else if (type == LIST_STATES)
    {
      if (state_chain != NULL)
        {
          States *s;
          for (s = state_chain; s; s = s->next)
            {
              fprintf (fpout, "%s:%s:%s\r\n", s->key, s->type, s->description);
            }
        }
      else
        return -1;
    }
  else
    {
      sprintf (path, "%s/gnats-adm/%s", gnats_root, infile);
      fpin = fopen (path, "r");
      if (fpin == (FILE *)NULL)
          return -1; /* XXX */
      while (read_string (line, fpin) > 0)
        if (line[0] != '#' && line[0] != ' ' && line[0] != '\n')
          {
	    if (! outf && doret)
	      {
	        char *s = strchr (line, '\n');
	        if (s)
	          {
                    s[0] = '\0';
                    fprintf (fpout, "%s\r\n", line);
	          }
	      }
	    else
              fputs (line, fpout);
          }
      fclose (fpin);
    }    

  if (outf)
    fclose (fpout);

  return 0;
}
