/* Typedefs and defines for the daemon files GNATS will read.
   Copyright (C) 1993-96, 1997 Free Software Foundation, Inc.
   Originally contributed by Mike Sutton (mike_sutton@dayton.saic.com).

This file is part of GNU GNATS.

GNU GNATS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU GNATS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GNATS; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111, USA.  */

#ifndef _db_conf_h_
#define _db_conf_h_

typedef struct db_conf_file_entry {
  char *key;
  char *value;

  struct db_conf_file_entry *next;
} Conf_entry;

/* public functions */
extern int    init_db_conf        PARAMS((void));
extern void   free_db_conf        PARAMS((void));
extern char * lookup_conf_alias    PARAMS((char *key));
extern int    get_conf_aliases     PARAMS((char ***aliases, int *count));
extern int    get_conf_databases   PARAMS((char ***databases, int *count));
extern int    local_chdb 	   PARAMS((char **new_root, char *program_name));

#endif /* _db_conf_h_ */
