#!/bin/sh
# Check whether a PR has been analyzed within the acknowledgment period.
# Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.
# Contributed by Brendan Kehoe (brendan@cygnus.com).
#
# This file is part of GNU GNATS.
#
# GNU GNATS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# GNU GNATS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU GNATS; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

prog=`basename $0`
USAGE="$prog: [-h] [-d gnats_root]  arguments

 Arguments coming in are (all are required):

 1 - response time
 2 - PR number
 3 - path to the PR file
 4 - submitter-id
 5 - full name of the submitter
 6 - contact for the submitter
 7 - address for GNATS_ADMIN

"

PATH=/bin:/usr/bin; export PATH

# process command line options
while [ $# -gt 0 ]; do
  case "$1" in
    -d | --directory)
      if [ $# -eq 1 ]; then echo "value required for $1 option"; exit 1; fi
      shift ; GNATS_ROOT="$1" ;;
    --directory=*) GNATS_ROOT="`echo $1 | sed 's/^[-a-z]*=//'`" ;;

    -*) echo "$USAGE"; exit 1 ;;
  esac
  shift
done

GNATS_ROOT=${GNATS_ROOT:-xGNATS_ROOTx} ; export GNATS_ROOT
VERSION=xVERSIONx
LIBEXECDIR=xLIBEXECDIRx
MAIL_AGENT="xMAIL_AGENTx"
GNATS_USER="xGNATS_USERx"

STATES_FILE=${GNATS_ROOT}/gnats-adm/states

# Newer config information?
[ -f ${GNATS_ROOT}/gnats-adm/config ] && . ${GNATS_ROOT}/gnats-adm/config

if [ $# != 7 ]; then
  echo "$prog: called with the incorrect number of arguments"
  echo "$USAGE"
  exit 1
fi
 
if [ ! -d $GNATS_ROOT ]; then
  echo "$prog: GNATS base directory $GNATS_ROOT does not exist."
  echo "$USAGE"
  exit 1
fi

# If the PR file isn't there, it may have been reclassified, so don't
# fret about it.
if [ ! -f $3 ]; then exit 0; fi

# Grab the current state of the PR, and the synopsis.
STATE=`grep '^>State:' $3 | sed -e 's,^>State:[ 	]*,,g'`
SYNOPSIS=`grep '^>Synopsis:' $3 | sed -e 's,^>Synopsis:[ 	]*,,g'`
RESPONSIBLE=`grep '^>Responsible:' $3 | sed -e 's,^>Responsible:[ 	]*,,g'`
RESP_ADDR=`$LIBEXECDIR/gnats/pr-addr "$RESPONSIBLE"`

# $DEBUG_MODE is set to 0 when debug is off in the config file
if [ "x$DEBUG_MODE" = "x1" ]; then
  STEALTH_HEADER="From: $GNATS_USER (GNATS Management)
To: $GNATS_ADMIN
Subject: mail output from at-pr


"
fi

# Read the default (first) state from the gnats-adm/states file.
get_default_state ()
{
    if [ ! -f ${STATES_FILE} ]; then
      echo "open";
      return 0;
    fi

    LINES=`grep '^[A-Za-z0-9_.-]' ${STATES_FILE} 2>/dev/null`

    if [ -z "${LINES}" ]; then
      echo "open"
      return 0;
    fi

    # else get the first state

    # Yes, this is as gross as you think it is.
    # Tried to use `read', but that didn't work...
    SAVED_IFS=${IFS}
    IFS="${IFS}:"
    for name in ${LINES}
    do
        echo "${name}"
        IFS=${SAVED_IFS}
        break
    done
}
OPEN_STATE=`get_default_state`

if [ "$STATE" = "${OPEN_STATE}" ]; then
  $MAIL_AGENT << __EOF__
${STEALTH_HEADER}From: $GNATS_USER (GNATS Management)
To: $6, $RESP_ADDR, $7
Subject: PR $2 not analyzed in $1 hours


PR $2 was not analyzed within the acknowledgment period
of $1 business hours.  The pertinent information is:

 Submitter-Id: $4
 Originator: $5
 Synopsis: $SYNOPSIS
 Person responsible for the PR: $RESPONSIBLE

--
The GNU Problem Report Management System (GNATS)
__EOF__
fi

exit 0
