//==========================================================================
//
//      wallclock_mpc5xx.cxx
//
//      mpc5xx RTC module driver.
//
//==========================================================================
//####COPYRIGHTBEGIN####
//                                                                          
// -------------------------------------------                              
// The contents of this file are subject to the Red Hat eCos Public License 
// Version 1.1 (the "License"); you may not use this file except in         
// compliance with the License.  You may obtain a copy of the License at    
// http://www.redhat.com/                                                   
//                                                                          
// Software distributed under the License is distributed on an "AS IS"      
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the 
// License for the specific language governing rights and limitations under 
// the License.                                                             
//                                                                          
// The Original Code is eCos - Embedded Configurable Operating System,      
// released September 30, 1998.                                             
//                                                                          
// The Initial Developer of the Original Code is Red Hat.                   
// Portions created by Red Hat are                                          
// Copyright (C) 1998, 1999, 2000 Red Hat, Inc.                             
// All Rights Reserved.                                                     
// -------------------------------------------                              
//                                                                          
//####COPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     Bob Koninckx
// Contributors:  Bob Koninckx
// Date:          2002-01-18
// Purpose:       Wallclock driver for mpc5xx
//
//####DESCRIPTIONEND####
//
//==========================================================================

#include <pkgconf/wallclock.h>            // Wallclock device config

#include <cyg/hal/hal_io.h>               // IO macros
#include <cyg/infra/cyg_type.h>           // Common type definitions and support

#include <cyg/io/wallclock.hxx>           // The WallClock API
#include <cyg/io/wallclock/wallclock.inl> // Helpers

#include <cyg/hal/hal_arch.h>             // RTC register definitions

#include <cyg/infra/diag.h>               // For debugging

//-----------------------------------------------------------------------------
// Functions required for the hardware-driver API.

// Returns the number of seconds elapsed since 1970-01-01 00:00:00.
cyg_uint32 
Cyg_WallClock::get_hw_seconds(void)
{
  cyg_uint32 now;
  HAL_READ_UINT32(CYGARC_REG_IMM_RTC, now);

  return now;
}

#ifndef CYGSEM_WALLCLOCK_SET_GET_MODE

void
Cyg_WallClock::init_hw_seconds(void)
{
  cyg_uint32 key = 0x55ccaa33;
  cyg_uint16 rtcsc;

  // Write zero to the time register
  // and start up the RTC
  HAL_WRITE_UINT32(CYGARC_REG_IMM_RTCK, key);
  HAL_WRITE_UINT32(CYGARC_REG_IMM_RTCSCK, key);
  
  key = 0;
  HAL_WRITE_UINT32(CYGARC_REG_IMM_RTC, key);
  HAL_READ_UINT16(CYGARC_REG_IMM_RTCSC, rtcsc);
  rtcsc |= 0x0001;
  HAL_WRITE_UINT16(CYGARC_REG_IMM_RTCSC, rtcsc);
}

#endif // CYGSEM_WALLCLOCK_SET_GET_MODE

//-----------------------------------------------------------------------------
// End of wallclock_mpc5xx.cxx
