#ifndef QSPI_H
#define QSPI_H

//----------------------------------
// Includes and forward declarations
//----------------------------------
#include <cyg/infra/cyg_type.h>

//--------------------------------------------------------------------------
// Type definitions for the Queued serial multi-channel module on the MPC555
//--------------------------------------------------------------------------
typedef struct qsmcm_port {
  volatile cyg_uint16 qsmcmmcr;                // 0x305000
  volatile cyg_uint16 qtest;                   // 0x305002
  volatile cyg_uint16 qdsci_il;                // 0x305004
  volatile cyg_uint16 qspi_il;                 // 0x305006
  volatile cyg_uint16 scc1r0;                  // 0x305008
  volatile cyg_uint16 scc1r1;                  // 0x30500a
  volatile cyg_uint16 sc1sr;                   // 0x30500c
  volatile cyg_uint16 sc1dr;                   // 0x30500e
  volatile cyg_uint16 unused1;                 // 0x305010
  volatile cyg_uint16 unused2;                 // 0x305012
  volatile cyg_uint16 portqs;                  // 0x305014
  volatile cyg_uint16 pqspar_ddrqs;            // 0x305016
  volatile cyg_uint16 spcr0;                   // 0x305018
  volatile cyg_uint16 spcr1;                   // 0x30501a
  volatile cyg_uint16 spcr2;                   // 0x30501c
  volatile cyg_uint16 spcr3_spsr;              // 0x30501e
  volatile cyg_uint16 scc2r0;                  // 0x305020
  volatile cyg_uint16 scc2r1;                  // 0x305022
  volatile cyg_uint16 sc2sr;                   // 0x305024
  volatile cyg_uint16 sc2dr;                   // 0x305026
  volatile cyg_uint16 qsci1cr;                 // 0x305028
  volatile cyg_uint16 qsci1sr;                 // 0x30502a
  volatile cyg_uint16 sctq[16];
  volatile cyg_uint16 scrq[16];
  volatile cyg_uint16 unused3[106];
  volatile cyg_uint16 rec_ram[32];
  volatile cyg_int16  tran_ram[32];
  volatile cyg_uint8  comd_ram[32];
} qsmcm_port_t;

//----------------------------------------------------------------
// And here is how we will build the dac interface using this port
//----------------------------------------------------------------
typedef struct qsmcm_dac {
  qsmcm_port_t * port;
  cyg_uint8      cmd_ram;
} qsmcm_dac_t;

#endif // QSPI_H
