##=============================================================================
##
##      vectors.S
##
##      x86 exception vectors
##
##=============================================================================
#####COPYRIGHTBEGIN####
#
# -------------------------------------------
# The contents of this file are subject to the Cygnus eCos Public License
# Version 1.0 (the "License"); you may not use this file except in
# compliance with the License.  You may obtain a copy of the License at
# http://sourceware.cygnus.com/ecos
# 
# Software distributed under the License is distributed on an "AS IS"
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the
# License for the specific language governing rights and limitations under
# the License.
# 
# The Original Code is eCos - Embedded Cygnus Operating System, released
# September 30, 1998.
# 
# The Initial Developer of the Original Code is Cygnus.  Portions created
# by Cygnus are Copyright (C) 1998,1999 Cygnus Solutions.  All Rights Reserved.
# -------------------------------------------
#
#####COPYRIGHTEND####
##=============================================================================
#######DESCRIPTIONBEGIN####
##
## Author(s):   jskov
## Contributors:jskov
## Date:        1999-01-07
## Purpose:     x86 exception vectors
## Description: This file defines the code placed into the exception
##              vectors. It also contains the first level default VSRs
##              that save and restore state for both exceptions and
##              interrupts.
##
######DESCRIPTIONEND####
##
##=============================================================================

#include <pkgconf/hal.h>
#include <pkgconf/system.h>

#==============================================================================

    .file   "vectors.S"

# The Linux synthetic target defines its own startup.
#ifdef CYGPKG_HAL_I386_LINUX
// Maybe we have more than just linux...
#define VECTORS_OK
    .extern _linux_entry
    .text
    .globl _start

_start:
    jmp   _linux_entry

// pjo, 27 sep 1999: Um, no.
// #else  ## ifdef CYGPKG_HAL_I386_LINUX
#endif

#ifdef CYGPKG_HAL_I386_PC
#define VECTORS_OK
    .extern _pc_entry
    .text
    .globl _start
_start:

#ifdef CYG_HAL_STARTUP_FLOPPY

/*
This code is loaded from a floppy disk when the PC powers up.
*/
	.code16

	.extern _end
	.extern set_debug_traps
	.extern breakpoint

	sectorsPerTrack = 18
	bytesPerSector = 512
	bytesPerTrack = sectorsPerTrack * bytesPerSector
	dptLength = 3 /* words. */

	cld				/* always count up. */

/* Configure a stack that we can use. */
	movl $_start, %eax
	movw %ax, %sp
	shr $4, %eax
	andl $0xF000, %eax
	movw %ax, %ss

/* Ask the BIOS for info about the amount of RAM available.  We push these
	onto the stack for later use.
*/
	xorl %eax, %eax
	movb $0x88, %ah		/* Get the amount of extended memory. */
	int $0x15
	shl $10, %eax
	pushl %eax

	xorl %eax, %eax
	int $0x12			/* Get the amount of standard memory. */
	shl $10, %eax
	pushl %eax


/* Read the rest of the image to _start.  This code works by reading a track
	at a time...
*/
	movl $_end, %eax
	movl $_start, %ebx		/* Our destination address. */
	subl %ebx, %eax			/* Number of bytes in the image. */
	movl $1, %ecx			/* Track/sector to read from (starts at 1). */

0:
	cmpl $0, %eax
	jle 1f

	pushl %eax			/* Save the number of bytes we want. */
	pushl %ebx			/* Save our current address. */
	pushl %ecx			/* Save our disk location. */

/* Read in a track with head 0. */
	movl %ebx, %eax			/* Put our address into ES:BX. */
	shr $4, %eax
	movw %ax, %es
	andb $0xF, %ebx
	movw $0, %dx			/* Disk 0, head 0 */
	movb $0x02, %ah
	movb sectorsPerTrack, %al	/* Read the entire track. */
	movb $1, %cl
	int $0x13			/* CX points to our track/sector. */

/* So go ahead and resume execution at the real starting address.  This
	only serves to move us quickly to the real starting location; and has
	no effect after reading additional tracks.  If we didn't jump after
	reading the first track, then we limit ourselves to reading images of
	30k bytes max before overwriting us at 0x7C00.
*/
	ljmp $0, $2f
	hlt

	.align 4
2:

	popl %ecx
	popl %ebx
	popl %eax

/* Add our length to the address. */
	addl $bytesPerTrack, %ebx
	subl $bytesPerTrack, %eax

/* Maybe read in a track with head 1. */
	cmpl $0, %eax
	jle 1f

	pushl %eax			/* Save the number of bytes we want. */
	pushl %ebx			/* Save our current address. */
	pushl %ecx

	movl %ebx, %eax			/* Put our address into ES:BX. */
	shr $4, %eax
	movw %ax, %es
	andb $0xF, %ebx
	movw $0x0100, %dx		/* Disk 0, head 1 */
	movb $0x02, %ah
	movb sectorsPerTrack, %al	/* Read the entire track. */
	movb $1, %cl
	int $0x13			/* CX points to our track/sector. */

	popl %ecx
	popl %ebx
	popl %eax

/* Add our length to the address. */
	addl $bytesPerTrack, %ebx
	subl $bytesPerTrack, %eax

/* Move to the next track. */
	addb $0x1, %ch

	jmp 0b

/* Write the 0x55/0xAA signature at the end of the first block.  Without
	this signature the BIOS won't consider this block to be bootable.
*/
	. = _start + 510
	.byte 0x55
	.byte 0xAA


1:

/* Lets be nice and wait for the diskette drive motor to go off before continuing. */
	movw $0x40, %ax
	movw %ax, %es
	movl $0x40, %ebx
2:	es
	movb (%ebx), %al
	cmpb $0, %al
	jne 2b

/* Disable interrupt handling. */
	cli

/* Configure GDT and IDT. */
	movl $gdt, %eax
	and $0xFFFF, %eax
	word
	cs
	lgdt (%eax)

	movl $idt, %eax
	and $0xFFFF, %eax
	word
	cs
	lidt (%eax)

/* Switch to protected mode. */
	smsw %eax
	orb $1, %al
	lmsw %eax
	ljmp $8, $protected

	hlt

	.align	4, 0xFF
gdt:
	.word	gdtEnd - gdtStart
	.long	gdtStart

	.align	4, 0xFF
idt:
	.word	0x07FF		/* Allow space for 256 interrupt vectors. */
	.long	0

gdtStart:
/* Selector 0x00 == invalid. */
	.word	0x0000
	.word	0x0000
	.byte	0x00
	.byte	0x00
	.byte	0x00
	.byte	0x00

/* Selector 0x08 == code. */
	.word	0xFFFF
	.word	0x0000
	.byte	0x00
	.byte	0x9B
	.byte	0xCF
	.byte	0x00

/* Selector 0x10 == data. */
	.word	0xFFFF
	.word	0x0000
	.byte	0x00
	.byte	0x93
	.byte	0xCF
	.byte	0x00

	.align	4, 0xFF
gdtEnd:


	.code32
protected:
	movw $0x10, %ax
	movw %ax, %ds
	movw %ax, %es
	movw %ax, %fs
	movw %ax, %gs

/* Make our new stack point to the same place as the old one. */
	xorl %ebx, %ebx
	movw %ss, %bx
	shl $4, %ebx
	addl %esp, %ebx
	movw %ax, %ss
	movl %ebx, %esp
	movl $0, %ebp

/* Reset the flags register. */
	pushl $0
	popfl

/* _pc_entry() takes a pointer to our startup array (which only has standard
	and extended memory sizes in it, on the stack).
*/
	movl %esp, %ebx		/* They are the last parameters on the stack. */
	pushl %ebx
#endif /* CYG_HAL_STARTUP_FLOPPY */

/* Clear out BSS.  */
	movl $_end, %ecx
	movl $__bss_start, %edi
	subl %edi, %ecx
	addl $3, %ecx		/* Make sure we get all of the bytes. */
	shr $2, %ecx		/* We'll use a more efficient 32-bit store. */
	xorl %eax, %eax		/* Store zeros. */
	rep
	stosl

/* Start running the system. */
    jmp _pc_entry

	.align 4
	.globl _breakinst
_breakinst:
	int $3
	ret

	.align 4
	.globl hal_pc_reset
hal_pc_reset:
	movw $92, %dx
	movb $1, %ax
	outb %ax, %dx
	hlt


#endif /* CYGPKG_HAL_I386_PC */

#ifndef VECTORS_OK
// pjo (end of changes) ...

#==============================================================================
# Real startup code. We jump here from the various reset vectors to set up the
# world.

    .text
    .globl _start

_start: 
#error "Not defined."

#endif ## ifndef CYGPKG_HAL_I386_LINUX

#------------------------------------------------------------------------------
# end of vectors.S
