/*
	hal_intr.c
*/

#	include <pkgconf/hal.h>
#	include <cyg/infra/cyg_type.h>
#	include <cyg/infra/cyg_ass.h>
#	include <cyg/hal/hal_arch.h>
#	include <cyg/hal/hal_intr.h>
#	include <cyg/hal/drv_api.h>



extern void hal_pc_generic_interrupt(void) ;
extern char hal_pc_interrupt_vector ;
extern char hal_pc_generic_interrupt_start ;
extern char hal_pc_generic_interrupt_end ;

int hal_pc_exception_handler(int vector, void * routine);

#ifdef CYGIMP_HAL_COMMON_INTERRUPTS_USE_INTERRUPT_STACK
char __interrupt_stack_base[CYGNUM_HAL_COMMON_INTERRUPTS_STACK_SIZE] ;
char * __interrupt_stack = &(__interrupt_stack_base[CYGNUM_HAL_COMMON_INTERRUPTS_STACK_SIZE]) ;
#endif /* CYGIMP_HAL_COMMON_INTERRUPTS_USE_INTERRUPT_STACK */


/*
	hal_pc_generic_interrupt
*/
	asm("
		.align 4, 0xCC
		.globl hal_pc_generic_interrupt
	hal_pc_generic_interrupt_start:
	hal_pc_generic_interrupt:
		pusha
		movl 0xC(%esp), %eax
		pushl %eax
		movl $hal_pc_generic_interrupt_x, %eax
		call *%eax
	hal_pc_generic_interrupt_end:
		");

/* --- */
	asm("
		.align 4, 0xCC
		.globl hal_pc_generic_interrupt_x
	hal_pc_generic_interrupt_x:
		movl $hal_pc_interrupt, %eax
		call *%eax
		popl %eax	" /* get rid of ESP */ "
		popl %eax	" /* get rid of EIP */ "
		popa
		iret
		");




// define HAL_PC_INTERRUPT_ROUTINE_SIZE (&hal_pc_generic_interrupt_end - &hal_pc_generic_interrupt_start)
#define HAL_PC_INTERRUPT_ROUTINE_SIZE (16)
typedef char hal_pc_interrupt_routine_t[HAL_PC_INTERRUPT_ROUTINE_SIZE] ;

hal_pc_interrupt_routine_t hal_pc_interrupt_routine[CYGNUM_HAL_ISR_COUNT] ;


#ifdef CYGFUN_HAL_COMMON_KERNEL_SUPPORT
void interrupt_end(cyg_uint32 isr_ret, cyg_interrupt * intr, HAL_SavedRegisters * sr);
#endif /* CYGFUN_HAL_COMMON_KERNEL_SUPPORT */


int hal_pc_interrupt(int eip, int * processorRegs)
{
	int vector, r ;
	cyg_ISR_t * routine ;
	char * p = (char*) hal_pc_interrupt_routine ;
	HAL_SavedRegisters regs ;

#ifdef CYGFUN_HAL_COMMON_KERNEL_SUPPORT
	extern cyg_uint32 cyg_scheduler_sched_lock ;
#endif /* CYGFUN_HAL_COMMON_KERNEL_SUPPORT */

#ifdef CYGFUN_HAL_COMMON_KERNEL_SUPPORT
	cyg_scheduler_sched_lock++ ;
#endif /* CYGFUN_HAL_COMMON_KERNEL_SUPPORT */

/* Save the registers into regs. */
	regs.esp = processorRegs[4] ;
	regs.ebp = processorRegs[5] ;
	regs.ebx = processorRegs[3] ;
	regs.esi = processorRegs[6] ;
	regs.edi = processorRegs[7] ;
	regs.eip = eip ;

/* Compute the vector we're called from. */
	eip -= (int) p ;
	vector = eip / HAL_PC_INTERRUPT_ROUTINE_SIZE ;

	routine = (cyg_ISR_t *) cyg_hal_interrupt_handlers[vector] ;
	r = routine(vector, cyg_hal_interrupt_data[vector]);

#ifdef CYGFUN_HAL_COMMON_KERNEL_SUPPORT
	interrupt_end(r, (cyg_interrupt*) cyg_hal_interrupt_objects[vector], &regs) ;
#endif /* CYGFUN_HAL_COMMON_KERNEL_SUPPORT */

#ifdef CYGFUN_HAL_COMMON_KERNEL_SUPPORT
//	cyg_scheduler_sched_lock-- ;
#endif /* CYGFUN_HAL_COMMON_KERNEL_SUPPORT */

	return r ;
}



void hal_pc_interrupt_in_use(cyg_vector_t vector, int * inUse)
{
}


void hal_pc_interrupt_attach(cyg_vector_t vector, cyg_ISR_t routine,
		CYG_ADDRWORD parameter, void * object)
{
	int l ;
	char * d ;
	short * q ;
	CYG_ADDRWORD r ;

	l = &hal_pc_generic_interrupt_end - &hal_pc_generic_interrupt_start  ;

/* Let's make sure that hal_pc_interrupt_routine entries are large enough. */
	CYG_ASSERT(l <= HAL_PC_INTERRUPT_ROUTINE_SIZE, "HAL_PC_INTERRUPT_ROUTINE_SIZE is too small");

/* Put the desired routine and parameter into the table. */
	cyg_hal_interrupt_data[vector] = (cyg_uint32) parameter ;
	cyg_hal_interrupt_handlers[vector] = (CYG_ADDRWORD) routine ;
	cyg_hal_interrupt_objects[vector] = (CYG_ADDRWORD) object ;

	d = hal_pc_interrupt_routine[vector] ;

/* Initialize the entry we're interested in using. */
	memset(d, HAL_BREAKINST, HAL_PC_INTERRUPT_ROUTINE_SIZE);
	memcpy(d, hal_pc_generic_interrupt, l) ;

/* Now write the vector into the IDT. */
	q = (short*) (vector * 8) ;
	r = (CYG_ADDRWORD) d ;
	q[0] = (r & 0xFFFF) ;
	q[1] = 8 ;
	q[2] = 0x8E00 ;
	q[3] = (r >> 16) ;
}



void hal_pc_interrupt_detach(cyg_vector_t vector, cyg_ISR_t routine)
{
}


