/*
	i386_stub.h

- pjo, 27 sep 1999
*/

#ifndef CYGONCE_HAL_I386_STUB_H
#define CYGONCE_HAL_I386_STUB_H


#define NUMREGS 				(16)
#define REGSIZE(x)				(((x) < CS)? 4 : 2)


enum regnames
{	EAX, ECX, EDX, EBX, ESP, EBP, ESI, EDI,
	PC /* also known as eip */,
	PS /* also known as eflags */,
	CS, SS, DS, ES, FS, GS
};

typedef enum regnames regnames_t ;
typedef unsigned long target_register_t ;

#define PS_C			0x00000001
#define PS_Z			0x00000040
#define PS_V			0x00000080
#define PS_T			0x00000100

#define SP				(ESP)
#define EIP				(PC)


/* Find out what our last trap was. */
extern int __get_trap_number(void) ;

/* Given a trap number, compute the signal code for it. */
extern int __computeSignal(unsigned int trap_number) ;

/* Enable single stepping after the next user resume instruction. */
extern void __single_step(void) ;
extern void __clear_single_step(void) ;

extern void __install_breakpoints(void) ;
extern void __clear_breakpoints(void) ;


#endif /* CYGONCE_HAL_I386_STUB_H */
