/*
 * COPYRIGHT (c) 1993-1995 FRAME TECHNOLOGY CORPORATION
 *
 * This source code contained herein is proprietary and
 * confidential information of Frame Technology Corporation,
 * San Jose, CA and is covered by the U.S. and other copyright
 * and trade secret protection.  Unauthorized adaptation,
 * distribution, use or display is prohibited and may be
 * subject to civil and criminal penalties.  Disclosure to
 * others is prohibited.  For the terms and conditions of
 * source code use refer to your Frame Technology source code
 * license agreement.
 */


#include "fm_sgml.h"
#include "fstrings.h"
#include "fmemory.h"
#include "futils.h"

static IntT exportULink FARGS((SwEventT *eventp));

/*
 * Sample event handler for SGML Writer
 */
SrwErrorT Sw_EventHandler(eventp, swObj)
SwEventT *eventp;
SwConvObjT swObj;
{
	if ((eventp->evtype == SW_EVT_TEXT_INSET) && !swObj)
		return exportULink(eventp);

	return Sw_Convert(eventp, swObj);
}


/*
 * set the URL attribute to the filename of the text inset
 * in the ULink element
 */
static SrwErrorT exportULink(eventp)
SwEventT *eventp;
{
	F_ObjHandleT docId;
	SwConvObjT docObj;
	StringT s, tiFilePath;

	docObj = Sw_GetCurConvObjOfType(SW_OBJ_DOC);
	if (!docObj)
	{
		docObj = Sw_GetCurConvObjOfType(SW_OBJ_BOOK_COMP);
		if (!docObj)
			return(SRW_E_FAILURE);
	}
	docId = Sw_GetDocId(docObj);
	if (!docId)
		return(SRW_E_FAILURE);

	tiFilePath = F_ApiGetString(docId, eventp->fm_objid, FP_TiFile);
	if (!tiFilePath)
		return(SRW_E_FAILURE);
	s = F_StrNew(F_StrLen(tiFilePath) + 32);
	F_Sprintf(s, "<ulink url=\"%s\"></ulink>", tiFilePath);
	Sw_WriteString(SW_LOC_INSTANCE, s);
	F_StrFree(s);
	return(SRW_E_SUCCESS);
}

