;; $Id: dbl10n.dsl,v 1.1.1.7 1999/01/28 15:21:13 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; If you create a new version of this file, please send it to
;; Norman Walsh, ndw@nwalsh.com.  Please use the ISO 639 language
;; code to identify the language.  Append a subtag as per RFC 1766,
;; if necessary.

;; The generated text for cross references to elements.  See dblink.dsl
;; for a discussion of how substitution is performed on the %x and #x
;; keywords.
;;

;; The following language codes from ISO 639 are recognized:
;; de - German (previously dege)
;; da - Danish (previously dk)
;; es - Spanish
;; fi - Finnish
;; fr - French
;; it - Italian
;; nl - Dutch
;; pl - Polish
;; pt - Portuguese
;; ru - Russian
;; sv - Swedish (previously svse)
;; en - English (previously usen)
;; no - Norwegian (previously bmno) ???

;; The following language codes are recognized for historical reasons:

;; bmno - Norwegian (Norsk Bokmal) ???
;; dege - German
;; dk   - Danish
;; svse - Swedish
;; usen - English

(define %default-language% "en")
(define %gentext-language% #f)
(define %gentext-use-xref-lang% #f)

(define ($lang$ #!optional (target (current-node)) (xref-context #f))
  (if %gentext-language%
      (case-fold-down %gentext-language%)
      (if (or xref-context %gentext-use-xref-lang%)
	  (let loop ((here target))
	    (if (node-list-empty? here)
		(case-fold-down %default-language%)
		(if (attribute-string "LANG" here)
		    (case-fold-down (attribute-string "LANG" here))
		    (loop (parent here)))))
	  (if (inherited-attribute-string "LANG")
	      (case-fold-down (inherited-attribute-string "LANG"))
	      (case-fold-down %default-language%)))))

;; bmno - Norwegian (Norsk Bokmal) ???
;; dege - German
;; dk   - Danish
;; svse - Swedish
;; usen - English

(define (gentext-xref-strings target)
  (let ((giname (if (string? target) (normalize target) (gi target)))
	(lang   (if (string? target) ($lang$) ($lang$ target))))
    (case lang
      ;; ISO 639/ISO 3166/RFC 1766
      <![%l10n-da[ (("da") (gentext-da-xref-strings giname)) ]]>
      <![%l10n-de[ (("de") (gentext-de-xref-strings giname)) ]]>
      <![%l10n-en[ (("en") (gentext-en-xref-strings giname)) ]]>
      <![%l10n-es[ (("es") (gentext-es-xref-strings giname)) ]]>
      <![%l10n-fi[ (("fi") (gentext-fi-xref-strings giname)) ]]>
      <![%l10n-fr[ (("fr") (gentext-fr-xref-strings giname)) ]]>
      <![%l10n-it[ (("it") (gentext-it-xref-strings giname)) ]]>
      <![%l10n-nl[ (("nl") (gentext-nl-xref-strings giname)) ]]>
      <![%l10n-no[ (("no") (gentext-no-xref-strings giname)) ]]>
      <![%l10n-pl[ (("pl") (gentext-pl-xref-strings giname)) ]]>
      <![%l10n-pt[ (("pt") (gentext-pt-xref-strings giname)) ]]>
      <![%l10n-ru[ (("ru") (gentext-ru-xref-strings giname)) ]]>
      <![%l10n-sv[ (("sv") (gentext-sv-xref-strings giname)) ]]>
      ;; Historical
      <![%l10n-da[ (("dk")   (gentext-da-xref-strings giname)) ]]>
      <![%l10n-de[ (("dege") (gentext-de-xref-strings giname)) ]]>
      <![%l10n-en[ (("usen") (gentext-en-xref-strings giname)) ]]>
      <![%l10n-no[ (("bmno") (gentext-no-xref-strings giname)) ]]>
      <![%l10n-sv[ (("svse") (gentext-sv-xref-strings giname)) ]]>
      (else (error "L10N ERROR: gentext-xref-strings")))))

(define (auto-xref-indirect-connector before) 
  (case ($lang$)
    <![%l10n-da[ (("da") (da-auto-xref-indirect-connector before)) ]]>
    <![%l10n-de[ (("de") (de-auto-xref-indirect-connector before)) ]]>
    <![%l10n-en[ (("en") (en-auto-xref-indirect-connector before)) ]]>
    <![%l10n-es[ (("es") (es-auto-xref-indirect-connector before)) ]]>
    <![%l10n-fi[ (("fi") (fi-auto-xref-indirect-connector before)) ]]>
    <![%l10n-fr[ (("fr") (fr-auto-xref-indirect-connector before)) ]]>
    <![%l10n-it[ (("it") (it-auto-xref-indirect-connector before)) ]]>
    <![%l10n-nl[ (("nl") (nl-auto-xref-indirect-connector before)) ]]>
    <![%l10n-no[ (("no") (no-auto-xref-indirect-connector before)) ]]>
    <![%l10n-pl[ (("pl") (pl-auto-xref-indirect-connector before)) ]]>
    <![%l10n-pt[ (("pt") (pt-auto-xref-indirect-connector before)) ]]>
    <![%l10n-ru[ (("ru") (ru-auto-xref-indirect-connector before)) ]]>
    <![%l10n-sv[ (("sv") (sv-auto-xref-indirect-connector before)) ]]>

    <![%l10n-da[ (("dk") (da-auto-xref-indirect-connector before)) ]]>
    <![%l10n-de[ (("dege") (de-auto-xref-indirect-connector before)) ]]>
    <![%l10n-en[ (("usen") (en-auto-xref-indirect-connector before)) ]]>
    <![%l10n-no[ (("bmno") (no-auto-xref-indirect-connector before)) ]]>
    <![%l10n-sv[ (("svse") (sv-auto-xref-indirect-connector before)) ]]>
    (else (error "L10N ERROR: auto-xref-indirect-connector"))))

(define (generate-toc-in-front)
  (case ($lang$)
    <![%l10n-da[ (("da") %generate-da-toc-in-front%) ]]>
    <![%l10n-de[ (("de") %generate-de-toc-in-front%) ]]>
    <![%l10n-en[ (("en") %generate-en-toc-in-front%) ]]>
    <![%l10n-es[ (("es") %generate-es-toc-in-front%) ]]>
    <![%l10n-fi[ (("fi") %generate-fi-toc-in-front%) ]]>
    <![%l10n-fr[ (("fr") %generate-fr-toc-in-front%) ]]>
    <![%l10n-it[ (("it") %generate-it-toc-in-front%) ]]>
    <![%l10n-nl[ (("nl") %generate-nl-toc-in-front%) ]]>
    <![%l10n-no[ (("no") %generate-no-toc-in-front%) ]]>
    <![%l10n-pl[ (("pl") %generate-pl-toc-in-front%) ]]>
    <![%l10n-pt[ (("pt") %generate-pt-toc-in-front%) ]]>
    <![%l10n-ru[ (("ru") %generate-ru-toc-in-front%) ]]>
    <![%l10n-sv[ (("sv") %generate-sv-toc-in-front%) ]]>

    <![%l10n-da[ (("dk") %generate-da-toc-in-front%) ]]>
    <![%l10n-de[ (("dege") %generate-de-toc-in-front%) ]]>
    <![%l10n-en[ (("usen") %generate-en-toc-in-front%) ]]>
    <![%l10n-no[ (("bmno") %generate-no-toc-in-front%) ]]>
    <![%l10n-sv[ (("svse") %generate-sv-toc-in-front%) ]]>
    (else (error "L10N ERROR: generate-toc-in-front"))))

(define (gentext-element-name target)
  (let ((giname (if (string? target) (normalize target) (gi target)))
	(lang   (if (string? target) ($lang$) ($lang$ target #t))))
    (case lang
      <![%l10n-da[ (("da") (gentext-da-element-name giname)) ]]>
      <![%l10n-de[ (("de") (gentext-de-element-name giname)) ]]>
      <![%l10n-en[ (("en") (gentext-en-element-name giname)) ]]>
      <![%l10n-es[ (("es") (gentext-es-element-name giname)) ]]>
      <![%l10n-fi[ (("fi") (gentext-fi-element-name giname)) ]]>
      <![%l10n-fr[ (("fr") (gentext-fr-element-name giname)) ]]>
      <![%l10n-it[ (("it") (gentext-it-element-name giname)) ]]>
      <![%l10n-nl[ (("nl") (gentext-nl-element-name giname)) ]]>
      <![%l10n-no[ (("no") (gentext-no-element-name giname)) ]]>
      <![%l10n-pl[ (("pl") (gentext-pl-element-name giname)) ]]>
      <![%l10n-pt[ (("pt") (gentext-pt-element-name giname)) ]]>
      <![%l10n-ru[ (("ru") (gentext-ru-element-name giname)) ]]>
      <![%l10n-sv[ (("sv") (gentext-sv-element-name giname)) ]]>

      <![%l10n-da[ (("dk")   (gentext-da-element-name giname)) ]]>
      <![%l10n-de[ (("dege") (gentext-de-element-name giname)) ]]>
      <![%l10n-en[ (("usen") (gentext-en-element-name giname)) ]]>
      <![%l10n-no[ (("bmno") (gentext-no-element-name giname)) ]]>
      <![%l10n-sv[ (("svse") (gentext-sv-element-name giname)) ]]>
      (else (error "L10N ERROR: gentext-element-name")))))

(define (gentext-element-name-space target)
  (let ((giname (if (string? target) (normalize target) (gi target)))
	(lang   (if (string? target) ($lang$) ($lang$ target))))
    (case lang
      <![%l10n-da[ (("da") (gentext-da-element-name-space giname)) ]]>
      <![%l10n-de[ (("de") (gentext-de-element-name-space giname)) ]]>
      <![%l10n-en[ (("en") (gentext-en-element-name-space giname)) ]]>
      <![%l10n-es[ (("es") (gentext-es-element-name-space giname)) ]]>
      <![%l10n-fi[ (("fi") (gentext-fi-element-name-space giname)) ]]>
      <![%l10n-fr[ (("fr") (gentext-fr-element-name-space giname)) ]]>
      <![%l10n-it[ (("it") (gentext-it-element-name-space giname)) ]]>
      <![%l10n-nl[ (("nl") (gentext-nl-element-name-space giname)) ]]>
      <![%l10n-no[ (("no") (gentext-no-element-name-space giname)) ]]>
      <![%l10n-pl[ (("pl") (gentext-pl-element-name-space giname)) ]]>
      <![%l10n-pt[ (("pt") (gentext-pt-element-name-space giname)) ]]>
      <![%l10n-ru[ (("ru") (gentext-ru-element-name-space giname)) ]]>
      <![%l10n-sv[ (("sv") (gentext-sv-element-name-space giname)) ]]>

      <![%l10n-da[ (("dk")   (gentext-da-element-name-space giname)) ]]>
      <![%l10n-de[ (("dege") (gentext-de-element-name-space giname)) ]]>
      <![%l10n-en[ (("usen") (gentext-en-element-name-space giname)) ]]>
      <![%l10n-no[ (("bmno") (gentext-no-element-name-space giname)) ]]>
      <![%l10n-sv[ (("svse") (gentext-sv-element-name-space giname)) ]]>
      (else (error "L10N ERROR: gentext-element-name-space")))))

(define (gentext-intra-label-sep target)
  (let ((giname (if (string? target) (normalize target) (gi target)))
	(lang   (if (string? target) ($lang$) ($lang$ target))))
    (case lang
      <![%l10n-da[ (("da") (gentext-da-intra-label-sep giname)) ]]>
      <![%l10n-de[ (("de") (gentext-de-intra-label-sep giname)) ]]>
      <![%l10n-en[ (("en") (gentext-en-intra-label-sep giname)) ]]>
      <![%l10n-es[ (("es") (gentext-es-intra-label-sep giname)) ]]>
      <![%l10n-fi[ (("fi") (gentext-fi-intra-label-sep giname)) ]]>
      <![%l10n-fr[ (("fr") (gentext-fr-intra-label-sep giname)) ]]>
      <![%l10n-it[ (("it") (gentext-it-intra-label-sep giname)) ]]>
      <![%l10n-nl[ (("nl") (gentext-nl-intra-label-sep giname)) ]]>
      <![%l10n-no[ (("no") (gentext-no-intra-label-sep giname)) ]]>
      <![%l10n-pl[ (("pl") (gentext-pl-intra-label-sep giname)) ]]>
      <![%l10n-pt[ (("pt") (gentext-pt-intra-label-sep giname)) ]]>
      <![%l10n-ru[ (("ru") (gentext-ru-intra-label-sep giname)) ]]>
      <![%l10n-sv[ (("sv") (gentext-sv-intra-label-sep giname)) ]]>

      <![%l10n-da[ (("dk")   (gentext-da-intra-label-sep giname)) ]]>
      <![%l10n-de[ (("dege") (gentext-de-intra-label-sep giname)) ]]>
      <![%l10n-en[ (("usen") (gentext-en-intra-label-sep giname)) ]]>
      <![%l10n-no[ (("bmno") (gentext-no-intra-label-sep giname)) ]]>
      <![%l10n-sv[ (("svse") (gentext-sv-intra-label-sep giname)) ]]>
      (else (error "L10N ERROR: gentext-intra-label-sep")))))

(define (gentext-label-title-sep target)
  (let ((giname (if (string? target) (normalize target) (gi target)))
	(lang   (if (string? target) ($lang$) ($lang$ target))))
    (case lang
      <![%l10n-da[ (("da") (gentext-da-label-title-sep giname)) ]]>
      <![%l10n-de[ (("de") (gentext-de-label-title-sep giname)) ]]>
      <![%l10n-en[ (("en") (gentext-en-label-title-sep giname)) ]]>
      <![%l10n-es[ (("es") (gentext-es-label-title-sep giname)) ]]>
      <![%l10n-fi[ (("fi") (gentext-fi-label-title-sep giname)) ]]>
      <![%l10n-fr[ (("fr") (gentext-fr-label-title-sep giname)) ]]>
      <![%l10n-it[ (("it") (gentext-it-label-title-sep giname)) ]]>
      <![%l10n-nl[ (("nl") (gentext-nl-label-title-sep giname)) ]]>
      <![%l10n-no[ (("no") (gentext-no-label-title-sep giname)) ]]>
      <![%l10n-pl[ (("pl") (gentext-pl-label-title-sep giname)) ]]>
      <![%l10n-pt[ (("pt") (gentext-pt-label-title-sep giname)) ]]>
      <![%l10n-ru[ (("ru") (gentext-ru-label-title-sep giname)) ]]>
      <![%l10n-sv[ (("sv") (gentext-sv-label-title-sep giname)) ]]>

      <![%l10n-da[ (("dk")   (gentext-da-label-title-sep giname)) ]]>
      <![%l10n-de[ (("dege") (gentext-de-label-title-sep giname)) ]]>
      <![%l10n-en[ (("usen") (gentext-en-label-title-sep giname)) ]]>
      <![%l10n-no[ (("bmno") (gentext-no-label-title-sep giname)) ]]>
      <![%l10n-sv[ (("svse") (gentext-sv-label-title-sep giname)) ]]>
      (else (error "L10N ERROR: gentext-label-title-sep")))))

(define (label-number-format target)
  (let ((giname (if (string? target) (normalize target) (gi target)))
	(lang   (if (string? target) ($lang$) ($lang$ target))))
    (case lang
      <![%l10n-da[ (("da") (da-label-number-format target)) ]]>
      <![%l10n-de[ (("de") (de-label-number-format target)) ]]>
      <![%l10n-en[ (("en") (en-label-number-format target)) ]]>
      <![%l10n-es[ (("es") (es-label-number-format target)) ]]>
      <![%l10n-fi[ (("fi") (fi-label-number-format target)) ]]>
      <![%l10n-fr[ (("fr") (fr-label-number-format target)) ]]>
      <![%l10n-it[ (("it") (it-label-number-format target)) ]]>
      <![%l10n-nl[ (("nl") (nl-label-number-format target)) ]]>
      <![%l10n-no[ (("no") (no-label-number-format target)) ]]>
      <![%l10n-pl[ (("pl") (pl-label-number-format target)) ]]>
      <![%l10n-pt[ (("pt") (pt-label-number-format target)) ]]>
      <![%l10n-ru[ (("ru") (ru-label-number-format target)) ]]>
      <![%l10n-sv[ (("sv") (sv-label-number-format target)) ]]>

      <![%l10n-da[ (("dk")   (da-label-number-format target)) ]]>
      <![%l10n-de[ (("dege") (de-label-number-format target)) ]]>
      <![%l10n-en[ (("usen") (en-label-number-format target)) ]]>
      <![%l10n-no[ (("bmno") (no-label-number-format target)) ]]>
      <![%l10n-sv[ (("svse") (sv-label-number-format target)) ]]>
      (else (error "L10N ERROR: label-number-format")))))

(define ($lot-title$ lotgi)
  (case ($lang$)
    <![%l10n-da[ (("da") ($lot-title-da$ lotgi)) ]]>
    <![%l10n-de[ (("de") ($lot-title-de$ lotgi)) ]]>
    <![%l10n-en[ (("en") ($lot-title-en$ lotgi)) ]]>
    <![%l10n-es[ (("es") ($lot-title-es$ lotgi)) ]]>
    <![%l10n-fi[ (("fi") ($lot-title-fi$ lotgi)) ]]>
    <![%l10n-fr[ (("fr") ($lot-title-fr$ lotgi)) ]]>
    <![%l10n-it[ (("it") ($lot-title-it$ lotgi)) ]]>
    <![%l10n-nl[ (("nl") ($lot-title-nl$ lotgi)) ]]>
    <![%l10n-no[ (("no") ($lot-title-no$ lotgi)) ]]>
    <![%l10n-pl[ (("pl") ($lot-title-pl$ lotgi)) ]]>
    <![%l10n-pt[ (("pt") ($lot-title-pt$ lotgi)) ]]>
    <![%l10n-ru[ (("ru") ($lot-title-ru$ lotgi)) ]]>
    <![%l10n-sv[ (("sv") ($lot-title-sv$ lotgi)) ]]>

    <![%l10n-da[ (("dk")   ($lot-title-da$ lotgi)) ]]>
    <![%l10n-de[ (("dege") ($lot-title-de$ lotgi)) ]]>
    <![%l10n-en[ (("usen") ($lot-title-en$ lotgi)) ]]>
    <![%l10n-no[ (("bmno") ($lot-title-no$ lotgi)) ]]>
    <![%l10n-sv[ (("svse") ($lot-title-sv$ lotgi)) ]]>
    (else (error "L10N ERROR: $lot-title$"))))

(define (gentext-start-quote)
  (case ($lang$)
    <![%l10n-da[ (("da") %gentext-da-start-quote%) ]]>
    <![%l10n-de[ (("de") %gentext-de-start-quote%) ]]>
    <![%l10n-en[ (("en") %gentext-en-start-quote%) ]]>
    <![%l10n-es[ (("es") %gentext-es-start-quote%) ]]>
    <![%l10n-fi[ (("fi") %gentext-fi-start-quote%) ]]>
    <![%l10n-fr[ (("fr") %gentext-fr-start-quote%) ]]>
    <![%l10n-it[ (("it") %gentext-it-start-quote%) ]]>
    <![%l10n-nl[ (("nl") %gentext-nl-start-quote%) ]]>
    <![%l10n-no[ (("no") %gentext-no-start-quote%) ]]>
    <![%l10n-pl[ (("pl") %gentext-pl-start-quote%) ]]>
    <![%l10n-pt[ (("pt") %gentext-pt-start-quote%) ]]>
    <![%l10n-ru[ (("ru") %gentext-ru-start-quote%) ]]>
    <![%l10n-sv[ (("sv") %gentext-sv-start-quote%) ]]>

    <![%l10n-da[ (("dk")   %gentext-da-start-quote%) ]]>
    <![%l10n-de[ (("dege") %gentext-de-start-quote%) ]]>
    <![%l10n-en[ (("usen") %gentext-en-start-quote%) ]]>
    <![%l10n-no[ (("bmno") %gentext-no-start-quote%) ]]>
    <![%l10n-sv[ (("svse") %gentext-sv-start-quote%) ]]>
    (else (error "L10N ERROR: gentext-start-quote"))))

(define (gentext-end-quote)
  (case ($lang$)
    <![%l10n-da[ (("da") %gentext-da-end-quote%) ]]>
    <![%l10n-de[ (("de") %gentext-de-end-quote%) ]]>
    <![%l10n-en[ (("en") %gentext-en-end-quote%) ]]>
    <![%l10n-es[ (("es") %gentext-es-end-quote%) ]]>
    <![%l10n-fi[ (("fi") %gentext-fi-end-quote%) ]]>
    <![%l10n-fr[ (("fr") %gentext-fr-end-quote%) ]]>
    <![%l10n-it[ (("it") %gentext-it-end-quote%) ]]>
    <![%l10n-nl[ (("nl") %gentext-nl-end-quote%) ]]>
    <![%l10n-no[ (("no") %gentext-no-end-quote%) ]]>
    <![%l10n-pl[ (("pl") %gentext-pl-end-quote%) ]]>
    <![%l10n-pt[ (("pt") %gentext-pt-end-quote%) ]]>
    <![%l10n-ru[ (("ru") %gentext-ru-end-quote%) ]]>
    <![%l10n-sv[ (("sv") %gentext-sv-end-quote%) ]]>

    <![%l10n-da[ (("dk")   %gentext-da-end-quote%) ]]>
    <![%l10n-de[ (("dege") %gentext-de-end-quote%) ]]>
    <![%l10n-en[ (("usen") %gentext-en-end-quote%) ]]>
    <![%l10n-no[ (("bmno") %gentext-no-end-quote%) ]]>
    <![%l10n-sv[ (("svse") %gentext-sv-end-quote%) ]]>
    (else (error "L10N ERROR: gentext-end-quote"))))

(define (gentext-by)
  (case ($lang$)
    <![%l10n-da[ (("da") %gentext-da-by%) ]]>
    <![%l10n-de[ (("de") %gentext-de-by%) ]]>
    <![%l10n-en[ (("en") %gentext-en-by%) ]]>
    <![%l10n-es[ (("es") %gentext-es-by%) ]]>
    <![%l10n-fi[ (("fi") %gentext-fi-by%) ]]>
    <![%l10n-fr[ (("fr") %gentext-fr-by%) ]]>
    <![%l10n-it[ (("it") %gentext-it-by%) ]]>
    <![%l10n-nl[ (("nl") %gentext-nl-by%) ]]>
    <![%l10n-no[ (("no") %gentext-no-by%) ]]>
    <![%l10n-pl[ (("pl") %gentext-pl-by%) ]]>
    <![%l10n-pt[ (("pt") %gentext-pt-by%) ]]>
    <![%l10n-ru[ (("ru") %gentext-ru-by%) ]]>
    <![%l10n-sv[ (("sv") %gentext-sv-by%) ]]>

    <![%l10n-da[ (("dk")   %gentext-da-by%) ]]>
    <![%l10n-de[ (("dege") %gentext-de-by%) ]]>
    <![%l10n-en[ (("usen") %gentext-en-by%) ]]>
    <![%l10n-no[ (("bmno") %gentext-no-by%) ]]>
    <![%l10n-sv[ (("svse") %gentext-sv-by%) ]]>
    (else (error "L10N ERROR: gentext-by"))))

(define (gentext-edited-by)
  (case ($lang$)
    <![%l10n-da[ (("da") %gentext-da-edited-by%) ]]>
    <![%l10n-de[ (("de") %gentext-de-edited-by%) ]]>
    <![%l10n-en[ (("en") %gentext-en-edited-by%) ]]>
    <![%l10n-es[ (("es") %gentext-es-edited-by%) ]]>
    <![%l10n-fi[ (("fi") %gentext-fi-edited-by%) ]]>
    <![%l10n-fr[ (("fr") %gentext-fr-edited-by%) ]]>
    <![%l10n-it[ (("it") %gentext-it-edited-by%) ]]>
    <![%l10n-nl[ (("nl") %gentext-nl-edited-by%) ]]>
    <![%l10n-no[ (("no") %gentext-no-edited-by%) ]]>
    <![%l10n-pl[ (("pl") %gentext-pl-edited-by%) ]]>
    <![%l10n-pt[ (("pt") %gentext-pt-edited-by%) ]]>
    <![%l10n-ru[ (("ru") %gentext-ru-edited-by%) ]]>
    <![%l10n-sv[ (("sv") %gentext-sv-edited-by%) ]]>

    <![%l10n-da[ (("dk")   %gentext-da-edited-by%) ]]>
    <![%l10n-de[ (("dege") %gentext-de-edited-by%) ]]>
    <![%l10n-en[ (("usen") %gentext-en-edited-by%) ]]>
    <![%l10n-no[ (("bmno") %gentext-no-edited-by%) ]]>
    <![%l10n-sv[ (("svse") %gentext-sv-edited-by%) ]]>
    (else (error "L10N ERROR: gentext-edited-by"))))

(define (gentext-page)
  (case ($lang$)
    <![%l10n-da[ (("da") %gentext-da-page%) ]]>
    <![%l10n-de[ (("de") %gentext-de-page%) ]]>
    <![%l10n-en[ (("en") %gentext-en-page%) ]]>
    <![%l10n-es[ (("es") %gentext-es-page%) ]]>
    <![%l10n-fi[ (("fi") %gentext-fi-page%) ]]>
    <![%l10n-fr[ (("fr") %gentext-fr-page%) ]]>
    <![%l10n-it[ (("it") %gentext-it-page%) ]]>
    <![%l10n-nl[ (("nl") %gentext-nl-page%) ]]>
    <![%l10n-no[ (("no") %gentext-no-page%) ]]>
    <![%l10n-pl[ (("pl") %gentext-pl-page%) ]]>
    <![%l10n-pt[ (("pt") %gentext-pt-page%) ]]>
    <![%l10n-ru[ (("ru") %gentext-ru-page%) ]]>
    <![%l10n-sv[ (("sv") %gentext-sv-page%) ]]>

    <![%l10n-da[ (("dk")   %gentext-da-page%) ]]>
    <![%l10n-de[ (("dege") %gentext-de-page%) ]]>
    <![%l10n-en[ (("usen") %gentext-en-page%) ]]>
    <![%l10n-no[ (("bmno") %gentext-no-page%) ]]>
    <![%l10n-sv[ (("svse") %gentext-sv-page%) ]]>
    (else (error "L10N ERROR: gentext-page"))))

(define (gentext-and)
  (case ($lang$)
    <![%l10n-da[ (("da") %gentext-da-and%) ]]>
    <![%l10n-de[ (("de") %gentext-de-and%) ]]>
    <![%l10n-en[ (("en") %gentext-en-and%) ]]>
    <![%l10n-es[ (("es") %gentext-es-and%) ]]>
    <![%l10n-fi[ (("fi") %gentext-fi-and%) ]]>
    <![%l10n-fr[ (("fr") %gentext-fr-and%) ]]>
    <![%l10n-it[ (("it") %gentext-it-and%) ]]>
    <![%l10n-nl[ (("nl") %gentext-nl-and%) ]]>
    <![%l10n-no[ (("no") %gentext-no-and%) ]]>
    <![%l10n-pl[ (("pl") %gentext-pl-and%) ]]>
    <![%l10n-pt[ (("pt") %gentext-pt-and%) ]]>
    <![%l10n-ru[ (("ru") %gentext-ru-and%) ]]>
    <![%l10n-sv[ (("sv") %gentext-sv-and%) ]]>

    <![%l10n-da[ (("dk")   %gentext-da-and%) ]]>
    <![%l10n-de[ (("dege") %gentext-de-and%) ]]>
    <![%l10n-en[ (("usen") %gentext-en-and%) ]]>
    <![%l10n-no[ (("bmno") %gentext-no-and%) ]]>
    <![%l10n-sv[ (("svse") %gentext-sv-and%) ]]>
    (else (error "L10N ERROR: gentext-and"))))

(define (gentext-bibl-pages)
  (case ($lang$)
    <![%l10n-da[ (("da") %gentext-da-bibl-pages%) ]]>
    <![%l10n-de[ (("de") %gentext-de-bibl-pages%) ]]>
    <![%l10n-en[ (("en") %gentext-en-bibl-pages%) ]]>
    <![%l10n-es[ (("es") %gentext-es-bibl-pages%) ]]>
    <![%l10n-fi[ (("fi") %gentext-fi-bibl-pages%) ]]>
    <![%l10n-fr[ (("fr") %gentext-fr-bibl-pages%) ]]>
    <![%l10n-it[ (("it") %gentext-it-bibl-pages%) ]]>
    <![%l10n-nl[ (("nl") %gentext-nl-bibl-pages%) ]]>
    <![%l10n-no[ (("no") %gentext-no-bibl-pages%) ]]>
    <![%l10n-pl[ (("pl") %gentext-pl-bibl-pages%) ]]>
    <![%l10n-pt[ (("pt") %gentext-pt-bibl-pages%) ]]>
    <![%l10n-ru[ (("ru") %gentext-ru-bibl-pages%) ]]>
    <![%l10n-sv[ (("sv") %gentext-sv-bibl-pages%) ]]>

    <![%l10n-da[ (("dk")   %gentext-da-bibl-pages%) ]]>
    <![%l10n-de[ (("dege") %gentext-de-bibl-pages%) ]]>
    <![%l10n-en[ (("usen") %gentext-en-bibl-pages%) ]]>
    <![%l10n-no[ (("bmno") %gentext-no-bibl-pages%) ]]>
    <![%l10n-sv[ (("svse") %gentext-sv-bibl-pages%) ]]>
    (else (error "L10N ERROR: gentext-bibl-pages"))))

(define (gentext-endnotes)
  (case ($lang$)
    <![%l10n-da[ (("da") %gentext-da-endnotes%) ]]>
    <![%l10n-de[ (("de") %gentext-de-endnotes%) ]]>
    <![%l10n-en[ (("en") %gentext-en-endnotes%) ]]>
    <![%l10n-es[ (("es") %gentext-es-endnotes%) ]]>
    <![%l10n-fi[ (("fi") %gentext-fi-endnotes%) ]]>
    <![%l10n-fr[ (("fr") %gentext-fr-endnotes%) ]]>
    <![%l10n-it[ (("it") %gentext-it-endnotes%) ]]>
    <![%l10n-nl[ (("nl") %gentext-nl-endnotes%) ]]>
    <![%l10n-no[ (("no") %gentext-no-endnotes%) ]]>
    <![%l10n-pl[ (("pl") %gentext-pl-endnotes%) ]]>
    <![%l10n-pt[ (("pt") %gentext-pt-endnotes%) ]]>
    <![%l10n-ru[ (("ru") %gentext-ru-endnotes%) ]]>
    <![%l10n-sv[ (("sv") %gentext-sv-endnotes%) ]]>

    <![%l10n-da[ (("dk")   %gentext-da-endnotes%) ]]>
    <![%l10n-de[ (("dege") %gentext-de-endnotes%) ]]>
    <![%l10n-en[ (("usen") %gentext-en-endnotes%) ]]>
    <![%l10n-no[ (("bmno") %gentext-no-endnotes%) ]]>
    <![%l10n-sv[ (("svse") %gentext-sv-endnotes%) ]]>
    (else (error "L10N ERROR: gentext-endnotes"))))

(define (gentext-table-endnotes)
  (case ($lang$)
    <![%l10n-da[ (("da") %gentext-da-table-endnotes%) ]]>
    <![%l10n-de[ (("de") %gentext-de-table-endnotes%) ]]>
    <![%l10n-en[ (("en") %gentext-en-table-endnotes%) ]]>
    <![%l10n-es[ (("es") %gentext-es-table-endnotes%) ]]>
    <![%l10n-fi[ (("fi") %gentext-fi-table-endnotes%) ]]>
    <![%l10n-fr[ (("fr") %gentext-fr-table-endnotes%) ]]>
    <![%l10n-it[ (("it") %gentext-it-table-endnotes%) ]]>
    <![%l10n-nl[ (("nl") %gentext-nl-table-endnotes%) ]]>
    <![%l10n-no[ (("no") %gentext-no-table-endnotes%) ]]>
    <![%l10n-pl[ (("pl") %gentext-pl-table-endnotes%) ]]>
    <![%l10n-pt[ (("pt") %gentext-pt-table-endnotes%) ]]>
    <![%l10n-ru[ (("ru") %gentext-ru-table-endnotes%) ]]>
    <![%l10n-sv[ (("sv") %gentext-sv-table-endnotes%) ]]>

    <![%l10n-da[ (("dk")   %gentext-da-table-endnotes%) ]]>
    <![%l10n-de[ (("dege") %gentext-de-table-endnotes%) ]]>
    <![%l10n-en[ (("usen") %gentext-en-table-endnotes%) ]]>
    <![%l10n-no[ (("bmno") %gentext-no-table-endnotes%) ]]>
    <![%l10n-sv[ (("svse") %gentext-sv-table-endnotes%) ]]>
    (else (error "L10N ERROR: gentext-table-endnotes"))))

(define (gentext-index-see)
  (case ($lang$)
    <![%l10n-da[ (("da") %gentext-da-index-see%) ]]>
    <![%l10n-de[ (("de") %gentext-de-index-see%) ]]>
    <![%l10n-en[ (("en") %gentext-en-index-see%) ]]>
    <![%l10n-es[ (("es") %gentext-es-index-see%) ]]>
    <![%l10n-fi[ (("fi") %gentext-fi-index-see%) ]]>
    <![%l10n-fr[ (("fr") %gentext-fr-index-see%) ]]>
    <![%l10n-it[ (("it") %gentext-it-index-see%) ]]>
    <![%l10n-nl[ (("nl") %gentext-nl-index-see%) ]]>
    <![%l10n-no[ (("no") %gentext-no-index-see%) ]]>
    <![%l10n-pl[ (("pl") %gentext-pl-index-see%) ]]>
    <![%l10n-pt[ (("pt") %gentext-pt-index-see%) ]]>
    <![%l10n-ru[ (("ru") %gentext-ru-index-see%) ]]>
    <![%l10n-sv[ (("sv") %gentext-sv-index-see%) ]]>

    <![%l10n-da[ (("dk")   %gentext-da-index-see%) ]]>
    <![%l10n-de[ (("dege") %gentext-de-index-see%) ]]>
    <![%l10n-en[ (("usen") %gentext-en-index-see%) ]]>
    <![%l10n-no[ (("bmno") %gentext-no-index-see%) ]]>
    <![%l10n-sv[ (("svse") %gentext-sv-index-see%) ]]>
    (else (error "L10N ERROR: gentext-index-see"))))

(define (gentext-index-seealso)
  (case ($lang$)
    <![%l10n-da[ (("da") %gentext-da-index-seealso%) ]]>
    <![%l10n-de[ (("de") %gentext-de-index-seealso%) ]]>
    <![%l10n-en[ (("en") %gentext-en-index-seealso%) ]]>
    <![%l10n-es[ (("es") %gentext-es-index-seealso%) ]]>
    <![%l10n-fi[ (("fi") %gentext-fi-index-seealso%) ]]>
    <![%l10n-fr[ (("fr") %gentext-fr-index-seealso%) ]]>
    <![%l10n-it[ (("it") %gentext-it-index-seealso%) ]]>
    <![%l10n-nl[ (("nl") %gentext-nl-index-seealso%) ]]>
    <![%l10n-no[ (("no") %gentext-no-index-seealso%) ]]>
    <![%l10n-pl[ (("pl") %gentext-pl-index-seealso%) ]]>
    <![%l10n-pt[ (("pt") %gentext-pt-index-seealso%) ]]>
    <![%l10n-ru[ (("ru") %gentext-ru-index-seealso%) ]]>
    <![%l10n-sv[ (("sv") %gentext-sv-index-seealso%) ]]>

    <![%l10n-da[ (("dk")   %gentext-da-index-seealso%) ]]>
    <![%l10n-de[ (("dege") %gentext-de-index-seealso%) ]]>
    <![%l10n-en[ (("usen") %gentext-en-index-seealso%) ]]>
    <![%l10n-no[ (("bmno") %gentext-no-index-seealso%) ]]>
    <![%l10n-sv[ (("svse") %gentext-sv-index-seealso%) ]]>
    (else (error "L10N ERROR: gentext-index-seealso"))))

