;; $Id: dbhtml.dsl,v 1.1 1998/02/18 13:13:39 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

(define (generate-xptr #!optional (nd (current-node)))
  (let loop ((suffix "")
	     (nd nd))
    (let ((eid (id nd)))
      (if eid
	  (string-append "I("
			 eid
			 ")"
			 (if (= (string-length suffix) 0)
			     ""
			     (string-append "C"
					    suffix)))
	  (let ((par (parent nd)))
	    (if (not (node-list-empty? par))
		(loop (string-append "("
				     (number->string (child-number nd))
				     ","
				     (gi nd)
				     ")"
				     suffix)
		      par)
		(string-append (if (= (string-length suffix) 0)
				   "R"
				   "R,C")
			       suffix)))))))

(define (href-to target)
  ;; Return the HTML HREF for the given node.  If nochunks is true, just
  ;; return the fragment identifier.
  (let* ((id (if (attribute-string "ID" target)
		 (attribute-string "ID" target)
		 (generate-xptr target)))
	 (curdepth (directory-depth (html-file (current-node))))
	 (entfile (html-file target))
	 (fragid (if (chunk? target)
		     ""
		     (string-append "#" id))))
    (if nochunks
	fragid
	(string-append (copy-string "../" curdepth) entfile fragid))))
	
(define (link-target idstring)
  ;; Return the HTML HREF for the given idstring.  For RefEntrys, this is
  ;; just the name of the file, for anything else it's the name of the file
  ;; with the fragment identifier for the specified id.
  (href-to (element-with-id idstring)))

;; ----------------------------------------------------------------------

(define (html-document title-sosofo body-sosofo)
  (let ((doc-sosofo 
	 (if (or (chunk?) (node-list=? (current-node) (sgml-root-element)))
	     (make element gi: "HTML"
		   (make element gi: "HEAD"
			 (make element gi: "TITLE"
			       title-sosofo)
			 ($html-header-meta$))
		   (make element gi: "BODY" 
			 attributes: %body-attr%
			 (header-navigation (current-node))
			 body-sosofo
			 (footer-navigation (current-node))))
	     body-sosofo)))
    (if (chunk?)
	(make entity
	  system-id: (html-file)
	  (make document-type
	    name: "HTML"
	    public-id: %html-pubid%)
	  doc-sosofo)
	(if (node-list=? (current-node) (sgml-root-element))
	    (make sequence
	      (make document-type
		name: "HTML"
		public-id: %html-pubid%)
	      doc-sosofo)
	    doc-sosofo))))

;; ----------------------------------------------------------------------

(define ($block-container$)
  (make element gi: "DIV"
	attributes: (list
		     (list "CLASS" (gi)))
	(process-children)))

(define ($paragraph$)
  (let ((footnotes (select-elements (descendants (current-node)) "FOOTNOTE"))
	(tgroup (have-ancestor? "TGROUP")))
    (make sequence
      (make element gi: "P"
	    (process-children))
      (if (or tgroup (node-list-empty? footnotes))
	  (empty-sosofo)
	  (make element gi: "BLOCKQUOTE"
		attributes: (list
			     (list "DIV" "FOOTNOTES"))
		(with-mode footnote-mode
		  (process-node-list footnotes)))))))

(define ($indent-para-container$)
  (make element gi: "BLOCKQUOTE"
	attributes: (list
		     (list "CLASS" (gi)))
	(process-children)))

(define ($bold-seq$ #!optional (sosofo (process-children)))
  (make element gi: "B"
	attributes: (list
		     (list "CLASS" (gi)))
	sosofo))

(define ($italic-seq$ #!optional (sosofo (process-children)))
  (make element gi: "I"
	attributes: (list
		     (list "CLASS" (gi)))
	sosofo))

(define ($bold-italic-seq$ #!optional (sosofo (process-children)))
  (make element gi: "B"
	attributes: (list
		     (list "CLASS" (gi)))
	(make element gi: "I"
	      sosofo)))

(define ($mono-seq$ #!optional (sosofo (process-children)))
  (make element gi: "TT"
	attributes: (list
		     (list "CLASS" (gi)))
	sosofo))

(define ($italic-mono-seq$ #!optional (sosofo (process-children)))
  (make element gi: "TT"
	attributes: (list
		     (list "CLASS" (gi)))
	(make element gi: "I"
	      sosofo)))

(define ($bold-mono-seq$ #!optional (sosofo (process-children)))
  (make element gi: "TT"
	attributes: (list
		     (list "CLASS" (gi)))
	(make element gi: "B"
	      sosofo)))

(define ($charseq$ #!optional (sosofo (process-children)))
  (make sequence
    sosofo))

;; ----------------------------------------------------------------------

(define ($html-header-meta$)
  (let loop ((hl (append (list 
			  (list "CREATOR" %stylesheet-version%))
			 %html-meta-tags%)))
    (if (null? hl)
	(empty-sosofo)
	(make sequence
	  (make empty-element gi: "META"
		attributes: (list
			     (list "NAME" (car (car hl)))
			     (list "CONTENT" (car (cdr (car hl))))))
	  (loop (cdr hl))))))

