;; $Id: dbdivis.dsl,v 1.1 1998/02/18 13:13:37 rosalia Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://www.berkshire.net/~norm/dsssl/
;;

;; ============================= DIVISIONS ==============================

(define ($division$) 
  (make element gi: "DIV"
	attributes: (list
		     (list "CLASS" (gi)))
	($division-title$)
	(process-children)))

(define ($division-title$)
  (let* ((info (cond
		((equal? (gi) "SET")
		 (select-elements (children (current-node)) "SETINFO"))
		((equal? (gi) "BOOK")
		 (select-elements (children (current-node)) "BOOKINFO"))
		(else 
		 (select-elements (children (current-node)) "DOCINFO"))))
	 (exp-children (expand-children (children info) '("BOOKBIBLIO" 
							  "BIBLIOMISC"
							  "BIBLIOSET")))
	 (parent-titles (select-elements (children (current-node)) "TITLE"))
	 (info-titles   (select-elements exp-children "TITLE"))
	 (titles        (if (node-list-empty? parent-titles)
			    info-titles
			    parent-titles))
	 (subtitles     (select-elements exp-children "SUBTITLE"))
	 (nsep (gentext-label-title-sep (gi))))
    (make sequence
      (make element gi: "H1"
	    (make element gi: "A"
		  attributes: (list (list "NAME" (element-id)))
		  (if (string=? (element-label (current-node)) "")
		      (empty-sosofo)
		      (literal (element-label (current-node)) nsep))
		  (element-title-sosofo (current-node))))
      (if (node-list-empty? subtitles) 
	  (empty-sosofo)
	  (with-mode subtitle-mode
	    (make element gi: "H2"
		  (process-node-list subtitles)))))))

(element SET ($division$))
(element (SET TITLE) (empty-sosofo))

(define ($book-body$)
  ;; Handle two cases:
  ;;   If there's a BOOKINFO, just process children.  BOOKINFO will handle
  ;;      generation of a title page and/or a TOC (see dbttlpg.dsl and 
  ;;      dbinfo.dsl)
  ;;   If there's no BOOKINFO, generate a simple page sequence containing
  ;;      the TOC, if a TOC is desired
  ;;
  (let* ((btitle (select-elements (children (current-node)) "TITLE"))
	 (binfo  (select-elements (children (current-node)) "BOOKINFO"))
	 (exp-children (if (node-list-empty? binfo)
			   (empty-node-list)
			   (expand-children (children (current-node))
					    '("BOOKBIBLIO" 
					      "BIBLIOMISC"
					      "BIBLIOSET"))))
	 (title  (if (node-list-empty? btitle)
		     (select-elements exp-children "TITLE")
		     btitle))
	 (subtitle (select-elements exp-children "SUBTITLE"))
	 (dedic  (select-elements (children (current-node)) "DEDICATION")))
    (make sequence
      (if (node-list-empty? binfo)
	  ($division-title$)
	  (with-mode titlepage-mode
	    (process-node-list binfo)))
      
      (if (node-list-empty? dedic)
	  (empty-sosofo)
	  (with-mode dedication-mode
	    (process-node-list dedic)))
      
      (if (and %generate-toc% %generate-toc-in-front%)
	  (build-toc (current-node)
		     (toc-depth (current-node)))
	  (empty-sosofo))

      (process-children))))

(element BOOK 
  (let* ((btitle (select-elements (children (current-node)) "TITLE"))
	 (binfo  (select-elements (children (current-node)) "BOOKINFO"))
	 (exp-children (if (node-list-empty? binfo)
			   (empty-node-list)
			   (expand-children (children (current-node))
					    '("BOOKBIBLIO" 
					      "BIBLIOMISC"
					      "BIBLIOSET"))))
	 (title  (if (node-list-empty? btitle)
		     (select-elements exp-children "TITLE")
		     btitle))
	 (title-sosofo (with-mode title-mode
			 (process-node-list (node-list-first title)))))
    (html-document title-sosofo ($book-body$))))

;; If the book title is present, then:
;;   If there's a BOOKINFO, we will have used that to make the title page,
;;      so ignore the BOOK TITLE
;;   Otherwise, generate a $divtitlepage$ with the BOOK TITLE
;;
(element (BOOK TITLE) (empty-sosofo))

(define ($part-separator$) 
  (if (or (not nochunks) (node-list=? (current-node) (sgml-root-element)))
      (empty-sosofo)
      (make empty-element gi: "HR")))

(define ($part-body$)
  (make sequence
    ($part-separator$)
    ($division-title$)
    (if %generate-part-toc%
	(make sequence
	  (build-toc (current-node) (toc-depth (current-node)))
	  (process-children))
	(process-children))))

(element PART
  (let* ((title (select-elements (children (current-node)) "TITLE"))
	 (title-sosofo (with-mode title-mode 
			 (process-node-list (node-list-first title)))))
    (html-document title-sosofo ($part-body$))))

(element (PART TITLE) (empty-sosofo))

(element PARTINTRO 
  (make element gi: "DIV"
	attributes: (list (list "CLASS" (gi)))
	(process-children)))

(element (PARTINTRO TITLE)
  (make element gi: "H1"
	(process-children)))
