#! /bin/sh

STYLESHEET=/usr/lib/sgml/stylesheets/cygnus-both.dsl
ADMON_GRAPHICS=/usr/lib/sgml/stylesheets/nwalsh-modular/images/*.gif

if [ $# -gt 2 ]
then
  echo "Usage: `basename $0` [filename.sgml]" >&2
  exit 1
fi

if [ $# -eq 1 ]
then
  if [ ! -r $1 ]
  then
    echo Cannot read \"$1\".  Exiting. >&2
    exit 1
  fi
  if echo $1 | egrep -i '\.sgml$|\.sgm$' >/dev/null 2>&1
  then
    output="`echo $1 | sed 's,\.sgml$,.dvi,;s,\.sgm$,.dvi,'`"
  fi
fi

echo OUTPUT FILE NAME IS $output

TMPFN=`echo $1 | sed 's/\.sgml//'`

jade -t tex -d ${STYLESHEET}\#print -o ${TMPFN}.tex $1

jadetex ${TMPFN}.tex

# if there are unresolved references, re-run jadetex, twice 
if egrep '^LaTeX Warning: There were undefined references.$' ${TMPFN}.log >/dev/null 2>&1
then
    jadetex ${TMPFN}.tex
    jadetex ${TMPFN}.tex
fi

exit 0
