/***************************************************************************
                               kstviewbox.cpp
                             -------------------
    begin                : Jun 14, 2005
    copyright            : (C) 2005 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kst.h"
#include "editviewobjectdialog.h" 
#include "kstviewbox.h"

#include <kglobal.h>
#include <klocale.h>

#include <qmetaobject.h>
#include <qpainter.h>
#include <qmap.h>
#include <qpair.h>

KstViewBox::KstViewBox()
: KstBorderedViewObject("Box") {
  _xRound = 0;
  _yRound = 0;
  _cornerStyle = Qt::MiterJoin;
  _layoutActions |= Delete | Raise | Lower | RaiseToTop | LowerToBottom | Rename | MoveTo | Copy | CopyTo;
  setTransparent(true);
  _transparentFill = false;
}


KstViewBox::KstViewBox(const QDomElement& e)
: KstBorderedViewObject(e) {
  
  QDomNode n = e.firstChild();
  while (!n.isNull()) {
    QDomElement el = n.toElement(); 
    if (!el.isNull()) {
      if (metaObject()->findProperty(el.tagName().latin1(), true) > -1) {
        setProperty(el.tagName().latin1(), QVariant(el.text()));  
      }  
    }
    n = n.nextSibling();      
  }
  
  // these always have these values
  _type = "Box";
  _layoutActions |= Delete | Raise | Lower | RaiseToTop | LowerToBottom | Rename | MoveTo | Copy | CopyTo;
  setTransparent(true);
}


KstViewBox::~KstViewBox() {
}


void KstViewBox::paint(KstPaintType type, QPainter& p, const QRegion& bounds) {
  QPen pen(borderColor(), borderWidth());
  pen.setJoinStyle(_cornerStyle);
  if (borderWidth() == 0) {
    pen.setStyle(Qt::NoPen);
  }
  p.setPen(pen);
  if (_transparentFill) {
    p.setBrush(Qt::NoBrush);  
  } else {
    p.setBrush(_foregroundColor);
  }
  p.drawRoundRect(_geom, _xRound, _yRound);
  
  // do this last so the focus rectangle isn't covered up
  KstViewObject::paint(type, p, bounds); // skip over the immediate parent
}


void KstViewBox::save(QTextStream& ts, const QString& indent) {
  ts << indent << "<" << type() << ">" << endl;
  KstBorderedViewObject::save(ts, indent + "  ");
  ts << indent << "</" << type() << ">" << endl;
}


void KstViewBox::setXRound(int rnd) {
  int crnd;
  if (rnd < 0) {
    crnd = 0;  
  } else if (rnd > 99) {
    crnd = 99;  
  } else {
    crnd = rnd;  
  }
  if (_xRound != crnd) {
    setDirty();
  }
  _xRound = crnd;
}


void KstViewBox::setYRound(int rnd) {
  int crnd;
  if (rnd < 0) {
    crnd = 0;  
  } else if (rnd > 99) {
    crnd = 99;  
  } else {
    crnd = rnd;  
  }
  if (_yRound != crnd) {
    setDirty();
  }
  _yRound = crnd;
}


int KstViewBox::xRound() const {
  return _xRound;
}


int KstViewBox::yRound() const {
  return _yRound;
}


void KstViewBox::setCornerStyle(Qt::PenJoinStyle style) {
  if (_cornerStyle != style) {
    setDirty();
  }
  _cornerStyle = style;
}


Qt::PenJoinStyle KstViewBox::cornerStyle() const {
  return _cornerStyle;
}


bool KstViewBox::transparentFill() const {
  return _transparentFill;
}


void KstViewBox::setTransparentFill(bool yes) {
  _transparentFill = yes;
}


QMap<QString, QVariant > KstViewBox::widgetHints(const QString& propertyName) const {
  QMap<QString, QVariant> map = KstBorderedViewObject::widgetHints(propertyName);
  if (!map.empty()) {
    return map;  
  }
  if (propertyName == "xRound") {
    map.insert(QString("_kst_widgetType"), QString("QSpinBox"));
    map.insert(QString("_kst_label"), i18n("X Roundness"));
    map.insert(QString("minValue"), 0);   
  } else if (propertyName == "yRound") {
    map.insert(QString("_kst_widgetType"), QString("QSpinBox"));
    map.insert(QString("_kst_label"), i18n("Y Roundness"));
    map.insert(QString("minValue"), 0);  
  } else if (propertyName == "foreColor") {
    map.insert(QString("_kst_widgetType"), QString("KColorButton"));
    map.insert(QString("_kst_label"), i18n("Fill Color"));
  } else if (propertyName == "transparentFill") {
    map.insert(QString("_kst_widgetType"), QString("QCheckBox"));
    map.insert(QString("_kst_label"), QString::null);
    map.insert(QString("text"), i18n("Transparent fill"));
  }
  return map;
}
#include "kstviewbox.moc"
// vim: ts=2 sw=2 et
