/***************************************************************************
                              bind_legend.h
                             ---------------
    begin                : Nov 08 2005
    copyright            : (C) 2005 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BIND_LEGEND_H
#define BIND_LEGEND_H

#include "bind_viewobject.h"

#include <kstviewlegend.h>

#include <kjs/interpreter.h>
#include <kjs/object.h>

/* @class Legend
   @inherits ViewObject
   @collection ViewObjectCollection
   @description A plot legend.
*/
class KstBindLegend : public KstBindViewObject {
  public:
    /* @constructor
       @arg Window window The window to place the new legend in.  May also be a
                          string containing the name of an existing Window.
       @description Creates a new legend and places it in the Window <i>window</i>.
    */
    KstBindLegend(KJS::ExecState *exec, KstViewLegendPtr d, const char *name = 0L);
    KstBindLegend(KJS::ExecState *exec, KJS::Object *globalObject = 0L, const char *name = 0L);
    ~KstBindLegend();

    KJS::Object construct(KJS::ExecState *exec, const KJS::List& args);
    KJS::Value call(KJS::ExecState *exec, KJS::Object& self, const KJS::List& args);
    KJS::Value get(KJS::ExecState *exec, const KJS::Identifier& propertyName) const;
    void put(KJS::ExecState *exec, const KJS::Identifier& propertyName, const KJS::Value& value, int attr = KJS::None);
    KJS::ReferenceList propList(KJS::ExecState *exec, bool recursive = true);
    bool hasProperty(KJS::ExecState *exec, const KJS::Identifier& propertyName) const;

    int methodCount() const;
    int propertyCount() const;

    /* @property string font
       @description Used to set or get the current font used for the label.
    */
    void setFont(KJS::ExecState *exec, const KJS::Value& value);
    KJS::Value font(KJS::ExecState *exec) const;
    /* @property number fontSize
       @description Contains the size of the font used to draw the label.
    */
    void setFontSize(KJS::ExecState *exec, const KJS::Value& value);
    KJS::Value fontSize(KJS::ExecState *exec) const;
    /* @property boolean scalarReplacement
       @description Determines if the contents of the legend should be
                    interpreted in order to substitute variable reference
                    constructs.  Default is true.
    */
    void setScalarReplacement(KJS::ExecState *exec, const KJS::Value& value);
    KJS::Value scalarReplacement(KJS::ExecState *exec) const;

  protected:
    KstBindLegend(int id, const char *name = 0L);
    void addBindings(KJS::ExecState *exec, KJS::Object& obj);
    static KstBindViewObject *bindFactory(KJS::ExecState *exec, KstViewObjectPtr obj);
};


#endif

// vim: ts=2 sw=2 et
