


#include <qcstring.h>
#include <qimage.h>
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <qcanvas.h>
#include "qcanvas_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

QCanvasImp::QCanvasImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

QCanvasImp::~QCanvasImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void QCanvasImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasImp *meth = new QCanvasImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void QCanvasImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_setTiles_5, "setTiles" },
        { Method_setBackgroundPixmap_6, "setBackgroundPixmap" },
        { Method_backgroundPixmap_7, "backgroundPixmap" },
        { Method_setBackgroundColor_8, "setBackgroundColor" },
        { Method_backgroundColor_9, "backgroundColor" },
        { Method_setTile_10, "setTile" },
        { Method_tile_11, "tile" },
        { Method_tilesHorizontally_12, "tilesHorizontally" },
        { Method_tilesVertically_13, "tilesVertically" },
        { Method_tileWidth_14, "tileWidth" },
        { Method_tileHeight_15, "tileHeight" },
        { Method_resize_16, "resize" },
        { Method_width_17, "width" },
        { Method_height_18, "height" },
        { Method_size_19, "size" },
        { Method_rect_20, "rect" },
        { Method_onCanvas_21, "onCanvas" },
        { Method_onCanvas_22, "onCanvas" },
        { Method_validChunk_23, "validChunk" },
        { Method_validChunk_24, "validChunk" },
        { Method_chunkSize_25, "chunkSize" },
        { Method_retune_26, "retune" },
        { Method_sameChunk_27, "sameChunk" },
        { Method_setChangedChunk_28, "setChangedChunk" },
        { Method_setChangedChunkContaining_29, "setChangedChunkContaining" },
        { Method_setAllChanged_30, "setAllChanged" },
        { Method_setChanged_31, "setChanged" },
        { Method_setUnchanged_32, "setUnchanged" },
        { Method_addItemToChunk_33, "addItemToChunk" },
        { Method_removeItemFromChunk_34, "removeItemFromChunk" },
        { Method_addItemToChunkContaining_35, "addItemToChunkContaining" },
        { Method_removeItemFromChunkContaining_36, "removeItemFromChunkContaining" },
        { Method_allItems_37, "allItems" },
        { Method_collisions_38, "collisions" },
        { Method_collisions_39, "collisions" },
        { Method_collisions_40, "collisions" },
        { Method_drawArea_41, "drawArea" },
        { Method_addView_42, "addView" },
        { Method_removeView_43, "removeView" },
        { Method_drawCanvasArea_44, "drawCanvasArea" },
        { Method_drawViewArea_45, "drawViewArea" },
        { Method_addItem_46, "addItem" },
        { Method_addAnimation_47, "addAnimation" },
        { Method_removeItem_48, "removeItem" },
        { Method_removeAnimation_49, "removeAnimation" },
        { Method_setAdvancePeriod_50, "setAdvancePeriod" },
        { Method_setUpdatePeriod_51, "setUpdatePeriod" },
        { Method_setDoubleBuffering_52, "setDoubleBuffering" },
	{ 0, 0 }
    };

    int idx = 0;
    QCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            QCanvasImp *meth = new QCanvasImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a QCanvas pointer from an Object.
 */
QCanvas *QCanvasImp::toQCanvas( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        QObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<QCanvas *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;

    if ( op->typeName() != "QCanvas" )
        return 0;

    return op->toNative<QCanvas>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object QCanvasImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvas_1:
             return QCanvas_1( exec, args );
             break;

         case Constructor_QCanvas_2:
             return QCanvas_2( exec, args );
             break;

         case Constructor_QCanvas_3:
             return QCanvas_3( exec, args );
             break;

         default:
             break;
    }

    QString msg = i18n("QCanvasCons has no constructor with id '%1'.").arg(id);
    KJS::Object err = KJS::Error::create( exec, KJS::ReferenceError, msg.utf8() );
    exec->setException( err );
    return err;
}


KJS::Object QCanvasImp::QCanvas_1( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter QObject *
    return KJS::Object();

    QObject * arg0; // Dummy

    const char *arg1 = (args.size() >= 2) ? args[1].toString(exec).ascii() : 0;


    // We should now create an instance of the QCanvas object

    QCanvas *ret = new QCanvas(

          arg0,
          arg1 );


}

KJS::Object QCanvasImp::QCanvas_2( KJS::ExecState *exec, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);


    // We should now create an instance of the QCanvas object

    QCanvas *ret = new QCanvas(

          arg0,
          arg1 );
	return KJS::Object();

}

KJS::Object QCanvasImp::QCanvas_3( KJS::ExecState *exec, const KJS::List &args )
{

    // Unsupported parameter QPixmap
    return KJS::Object();

    QPixmap arg0; // Dummy

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

    int arg3 = extractInt(exec, args, 3);

    int arg4 = extractInt(exec, args, 4);


    // We should now create an instance of the QCanvas object

    QCanvas *ret = new QCanvas(

          arg0,
          arg1,
          arg2,
          arg3,
          arg4 );


}

KJS::Value QCanvasImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = QCanvasImp::toQCanvas( self );

    switch( id ) {

    case Method_setTiles_5:
        return setTiles_5( exec, self, args );
        break;

    case Method_setBackgroundPixmap_6:
        return setBackgroundPixmap_6( exec, self, args );
        break;

    case Method_backgroundPixmap_7:
        return backgroundPixmap_7( exec, self, args );
        break;

    case Method_setBackgroundColor_8:
        return setBackgroundColor_8( exec, self, args );
        break;

    case Method_backgroundColor_9:
        return backgroundColor_9( exec, self, args );
        break;

    case Method_setTile_10:
        return setTile_10( exec, self, args );
        break;

    case Method_tile_11:
        return tile_11( exec, self, args );
        break;

    case Method_tilesHorizontally_12:
        return tilesHorizontally_12( exec, self, args );
        break;

    case Method_tilesVertically_13:
        return tilesVertically_13( exec, self, args );
        break;

    case Method_tileWidth_14:
        return tileWidth_14( exec, self, args );
        break;

    case Method_tileHeight_15:
        return tileHeight_15( exec, self, args );
        break;

    case Method_resize_16:
        return resize_16( exec, self, args );
        break;

    case Method_width_17:
        return width_17( exec, self, args );
        break;

    case Method_height_18:
        return height_18( exec, self, args );
        break;

    case Method_size_19:
        return size_19( exec, self, args );
        break;

    case Method_rect_20:
        return rect_20( exec, self, args );
        break;

    case Method_onCanvas_21:
        return onCanvas_21( exec, self, args );
        break;

    case Method_onCanvas_22:
        return onCanvas_22( exec, self, args );
        break;

    case Method_validChunk_23:
        return validChunk_23( exec, self, args );
        break;

    case Method_validChunk_24:
        return validChunk_24( exec, self, args );
        break;

    case Method_chunkSize_25:
        return chunkSize_25( exec, self, args );
        break;

    case Method_retune_26:
        return retune_26( exec, self, args );
        break;

    case Method_sameChunk_27:
        return sameChunk_27( exec, self, args );
        break;

    case Method_setChangedChunk_28:
        return setChangedChunk_28( exec, self, args );
        break;

    case Method_setChangedChunkContaining_29:
        return setChangedChunkContaining_29( exec, self, args );
        break;

    case Method_setAllChanged_30:
        return setAllChanged_30( exec, self, args );
        break;

    case Method_setChanged_31:
        return setChanged_31( exec, self, args );
        break;

    case Method_setUnchanged_32:
        return setUnchanged_32( exec, self, args );
        break;

    case Method_addItemToChunk_33:
        return addItemToChunk_33( exec, self, args );
        break;

    case Method_removeItemFromChunk_34:
        return removeItemFromChunk_34( exec, self, args );
        break;

    case Method_addItemToChunkContaining_35:
        return addItemToChunkContaining_35( exec, self, args );
        break;

    case Method_removeItemFromChunkContaining_36:
        return removeItemFromChunkContaining_36( exec, self, args );
        break;

    case Method_allItems_37:
        return allItems_37( exec, self, args );
        break;

    case Method_collisions_38:
        return collisions_38( exec, self, args );
        break;

    case Method_collisions_39:
        return collisions_39( exec, self, args );
        break;

    case Method_collisions_40:
        return collisions_40( exec, self, args );
        break;

    case Method_drawArea_41:
        return drawArea_41( exec, self, args );
        break;

    case Method_addView_42:
        return addView_42( exec, self, args );
        break;

    case Method_removeView_43:
        return removeView_43( exec, self, args );
        break;

    case Method_drawCanvasArea_44:
        return drawCanvasArea_44( exec, self, args );
        break;

    case Method_drawViewArea_45:
        return drawViewArea_45( exec, self, args );
        break;

    case Method_addItem_46:
        return addItem_46( exec, self, args );
        break;

    case Method_addAnimation_47:
        return addAnimation_47( exec, self, args );
        break;

    case Method_removeItem_48:
        return removeItem_48( exec, self, args );
        break;

    case Method_removeAnimation_49:
        return removeAnimation_49( exec, self, args );
        break;

    case Method_setAdvancePeriod_50:
        return setAdvancePeriod_50( exec, self, args );
        break;

    case Method_setUpdatePeriod_51:
        return setUpdatePeriod_51( exec, self, args );
        break;

    case Method_setDoubleBuffering_52:
        return setDoubleBuffering_52( exec, self, args );
        break;

    default:
        break;
    }

    QString msg = i18n( "QCanvasImp has no method with id '%1'." ).arg( id );
    KJS::Object err = KJS::Error::create( exec, KJS::ReferenceError, msg.utf8() );
    exec->setException( err );
    return err;
}


KJS::Value QCanvasImp::setTiles_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter QPixmap
    return KJS::Value();

    QPixmap arg0; // Dummy

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

    int arg3 = extractInt(exec, args, 3);

    int arg4 = extractInt(exec, args, 4);

      instance->setTiles(
       arg0,
       arg1,
       arg2,
       arg3,
       arg4 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::setBackgroundPixmap_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    QPixmap arg0 = extractQPixmap(exec, args, 0);

      instance->setBackgroundPixmap(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::backgroundPixmap_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    QPixmap ret;
      ret = instance->backgroundPixmap(  );

       return convertToValue( exec, ret );

}

KJS::Value QCanvasImp::setBackgroundColor_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    QColor arg0 = extractQColor(exec, args, 0);

      instance->setBackgroundColor(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::backgroundColor_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->backgroundColor(  );
      return KJS::Value(); // Returns 'QColor'

}

KJS::Value QCanvasImp::setTile_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

      instance->setTile(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::tile_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      int ret;
      ret = instance->tile(
       arg0,
       arg1 );
      return KJS::Number( ret );

}

KJS::Value QCanvasImp::tilesHorizontally_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->tilesHorizontally(  );
      return KJS::Number( ret );

}

KJS::Value QCanvasImp::tilesVertically_13( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->tilesVertically(  );
      return KJS::Number( ret );

}

KJS::Value QCanvasImp::tileWidth_14( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->tileWidth(  );
      return KJS::Number( ret );

}

KJS::Value QCanvasImp::tileHeight_15( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->tileHeight(  );
      return KJS::Number( ret );

}

KJS::Value QCanvasImp::resize_16( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      instance->resize(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::width_17( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->width(  );
      return KJS::Number( ret );

}

KJS::Value QCanvasImp::height_18( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->height(  );
      return KJS::Number( ret );

}

KJS::Value QCanvasImp::size_19( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    QSize ret;
      ret = instance->size(  );

       return convertToValue( exec, ret );

}

KJS::Value QCanvasImp::rect_20( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    QRect ret;
      ret = instance->rect(  );

       return convertToValue( exec, ret );

}

KJS::Value QCanvasImp::onCanvas_21( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      bool ret;
      ret = instance->onCanvas(
       arg0,
       arg1 );
      return KJS::Boolean( ret );

}

KJS::Value QCanvasImp::onCanvas_22( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    QPoint arg0 = extractQPoint(exec, args, 0);

      bool ret;
      ret = instance->onCanvas(
       arg0 );
      return KJS::Boolean( ret );

}

KJS::Value QCanvasImp::validChunk_23( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      bool ret;
      ret = instance->validChunk(
       arg0,
       arg1 );
      return KJS::Boolean( ret );

}

KJS::Value QCanvasImp::validChunk_24( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    QPoint arg0 = extractQPoint(exec, args, 0);

      bool ret;
      ret = instance->validChunk(
       arg0 );
      return KJS::Boolean( ret );

}

KJS::Value QCanvasImp::chunkSize_25( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->chunkSize(  );
      return KJS::Number( ret );

}

KJS::Value QCanvasImp::retune_26( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      instance->retune(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::sameChunk_27( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

    int arg3 = extractInt(exec, args, 3);

      bool ret;
      ret = instance->sameChunk(
       arg0,
       arg1,
       arg2,
       arg3 );
      return KJS::Boolean( ret );

}

KJS::Value QCanvasImp::setChangedChunk_28( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      instance->setChangedChunk(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::setChangedChunkContaining_29( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

    int arg1 = extractInt(exec, args, 1);

      instance->setChangedChunkContaining(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::setAllChanged_30( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->setAllChanged(  );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::setChanged_31( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    QRect arg0 = extractQRect(exec, args, 0);

      instance->setChanged(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::setUnchanged_32( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    QRect arg0 = extractQRect(exec, args, 0);

      instance->setUnchanged(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::addItemToChunk_33( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter QCanvasItem *
    return KJS::Value();

    QCanvasItem * arg0; // Dummy

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

      instance->addItemToChunk(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::removeItemFromChunk_34( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter QCanvasItem *
    return KJS::Value();

    QCanvasItem * arg0; // Dummy

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

      instance->removeItemFromChunk(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::addItemToChunkContaining_35( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter QCanvasItem *
    return KJS::Value();

    QCanvasItem * arg0; // Dummy

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

      instance->addItemToChunkContaining(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::removeItemFromChunkContaining_36( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter QCanvasItem *
    return KJS::Value();

    QCanvasItem * arg0; // Dummy

    int arg1 = extractInt(exec, args, 1);

    int arg2 = extractInt(exec, args, 2);

      instance->removeItemFromChunkContaining(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::allItems_37( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->allItems(  );
      return KJS::Value(); // Returns 'QCanvasItemList'

}

KJS::Value QCanvasImp::collisions_38( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    QPoint arg0 = extractQPoint(exec, args, 0);

      instance->collisions(
       arg0 );
      return KJS::Value(); // Returns 'QCanvasItemList'

}

KJS::Value QCanvasImp::collisions_39( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    QRect arg0 = extractQRect(exec, args, 0);

      instance->collisions(
       arg0 );
      return KJS::Value(); // Returns 'QCanvasItemList'

}

KJS::Value QCanvasImp::collisions_40( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    QPointArray arg0; // TODO (hack for qcanvas)

    // Unsupported parameter const QCanvasItem *
    return KJS::Value();

    const QCanvasItem * arg1; // Dummy

    bool arg2 = extractBool(exec, args, 2);

      instance->collisions(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns 'QCanvasItemList'

}

KJS::Value QCanvasImp::drawArea_41( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    QRect arg0 = extractQRect(exec, args, 0);

    // Unsupported parameter QPainter *
    return KJS::Value();

    QPainter * arg1; // Dummy

    bool arg2 = extractBool(exec, args, 2);

      instance->drawArea(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::addView_42( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter QCanvasView *
    return KJS::Value();

    QCanvasView * arg0; // Dummy

      instance->addView(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::removeView_43( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter QCanvasView *
    return KJS::Value();

    QCanvasView * arg0; // Dummy

      instance->removeView(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::drawCanvasArea_44( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    QRect arg0 = extractQRect(exec, args, 0);

    // Unsupported parameter QPainter *
    return KJS::Value();

    QPainter * arg1; // Dummy

    bool arg2 = extractBool(exec, args, 2);

      instance->drawCanvasArea(
       arg0,
       arg1,
       arg2 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::drawViewArea_45( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter QCanvasView *
    return KJS::Value();

    QCanvasView * arg0; // Dummy

    // Unsupported parameter QPainter *
    return KJS::Value();

    QPainter * arg1; // Dummy

    QRect arg2 = extractQRect(exec, args, 2);

    bool arg3 = extractBool(exec, args, 3);

      instance->drawViewArea(
       arg0,
       arg1,
       arg2,
       arg3 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::addItem_46( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter QCanvasItem *
    return KJS::Value();

    QCanvasItem * arg0; // Dummy

      instance->addItem(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::addAnimation_47( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter QCanvasItem *
    return KJS::Value();

    QCanvasItem * arg0; // Dummy

      instance->addAnimation(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::removeItem_48( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter QCanvasItem *
    return KJS::Value();

    QCanvasItem * arg0; // Dummy

      instance->removeItem(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::removeAnimation_49( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter QCanvasItem *
    return KJS::Value();

    QCanvasItem * arg0; // Dummy

      instance->removeAnimation(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::setAdvancePeriod_50( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

      instance->setAdvancePeriod(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::setUpdatePeriod_51( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

      instance->setUpdatePeriod(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value QCanvasImp::setDoubleBuffering_52( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    bool arg0 = extractBool(exec, args, 0);

      instance->setDoubleBuffering(
       arg0 );
      return KJS::Value(); // Returns void

}


} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:


