/***************************************************************************
                          krelais.h  -  description
                             -------------------
    begin                : Wed Feb 12 21:36:24 CET 2003
    copyright            : (C) 2003 by Burkhard Brauer     (* Elektromeister *) 
    email                : BurkhardBrauer@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRELAIS_H
#define KRELAIS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kmainwindow.h>
#include <kmenubar.h>
#include <kpopupmenu.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kstdaction.h>
#include <kaboutdata.h>
#include <kglobal.h>
#include <kstddirs.h>

#include <kaction.h>


#include <qwidget.h>
#include <qfont.h>
#include <qstatusbar.h>
#include <qpainter.h>
#include <qcolordialog.h>
#include <qtimer.h>
#include <qinputdialog.h>
#include <qfiledialog.h>
#include <qlineedit.h>
#include <qcolor.h>
#include <qpoint.h>
#include <math.h>

 int const BILD_BREITE = 1024, BILD_HOEHE = 700;

// Bit Konstanten setzen
const int 	KEIN_BAUTEIL=0;
const int		SI_RELAIS=1;
const int 	VERBINDUNG_VERTIKAL=2;
const int 	VERBINDUNG_HORIZONTAL=4;
const int 	SCHLIESSER=8;
const int  	OEFFNER=16;
const int		RELAIS=32;
const int		SE_RELAIS=64;
const int	   TASTER_SCHLIESSER=128;
const int		TASTER_OEFFNER=256;
const int		LAMPE=512;
const int  	SCHALTER_SCHLIESSER=1024;
const int  	SCHALTER_OEFFNER=2048;
//
const int   VERBINDUNG=VERBINDUNG_VERTIKAL | VERBINDUNG_HORIZONTAL;
//
const int 	AKTIVE_BAUTEILE=RELAIS | SE_RELAIS | SI_RELAIS;
// Schaltelemente
const int	AKTIVE_SCHALTELEMENTE=SCHLIESSER | OEFFNER;
const int   PASSIVE_SCHALTELEMENTE=TASTER_SCHLIESSER | TASTER_OEFFNER | SCHALTER_SCHLIESSER | SCHALTER_OEFFNER;
const int	SCHALTELEMENTE=AKTIVE_SCHALTELEMENTE | PASSIVE_SCHALTELEMENTE;
//
const int	AZEIGEN=LAMPE;

enum Aktionen{KEINE_AKTION,START,STOP,CPOPIEREN};

enum StatusBauteil {OFF,ON};

// **** Menpunkte ****
enum {M_LADEN=10,M_SPEICHERN,M_SPEICHERN_ALS,M_LOESCHEN,M_QUIT,M_VERBINDUNG,M_SCHLIESSER,M_OEFFNER,M_RELAIS,M_SE_RELAIS,
			M_SI_RELAIS,M_TASTER_SCHLIESSER,M_TASTER_OEFFNER,M_SCHALTER_SCHLIESSER,M_LAMPE,M_START,M_STOP,
			M_FAST_HELP_SIMULATION, M_FAST_HELP_INSTALL};


/** KRelais is the base class of the project */
class KRelais : public KMainWindow
{
  Q_OBJECT 
    	QPixmap  	ZeichnenPuffer,
							RelaisOFF,RelaisON,RelaisSeOFF,RelaisSeON,RelaisSiOFF,RelaisSiON,
  							SchliesserOFF,SchliesserON,OeffnerOFF,OeffnerON,
							TasterSchliesserON,TasterSchliesserOFF,TasterOeffnerON,TasterOeffnerOFF,
							SchalterSchliesserON,SchalterSchliesserOFF,
							LampeON,LampeOFF,HintergrundMaske,Rechteck,
							SchliesserSeOFF,SchliesserSeON,SchliesserSiOFF,SchliesserSiON,
							OeffnerSeON,OeffnerSeOFF,OeffnerSiON,OeffnerSiOFF;
	QPoint   posXY[80];
	QPainter paint;
protected:
  	void paintEvent(QPaintEvent*);
  	void resizeEvent(QResizeEvent*);
  	void moveEvent(QMoveEvent*);
 	void mousePressEvent(QMouseEvent*);
  	void mouseMoveEvent(QMouseEvent*);
	void mouseReleaseEvent(QMouseEvent*);
private:

int BauteilArt;
StatusBauteil Status;
Aktionen Aktion;

struct /* Knoten */
{	int x,y;
	bool Spannung;
}	Knoten[80];

struct  BauteilStruct
{	int  art;
	int  x,y;
	bool status;
	bool AnzeigeStatus;
	bool Spannung;
	int  Zuordnung;
	bool StartTimer;
	int  Startzeit;
	int  Laufzeit;
}  Bauteil[80];

struct VerbindungStruct /* fr Vertikale Verbindungen */
{	int x,y;
  	bool Verbindung;
	bool Spannung;
} Vertikale[80],Horizontale[80];

	void BauteilReset(int Nr);
	void WaagerechtDurchrechnen();
	void SenkrechtDurchrechnen(int Spalte);
	void BauteileDurchrechnen(int Nr);
	void Bauteil_schalten(int MausX,int MausY);
	void Bauteile_plazieren(int MausX,int MausY);
	void Bauteil_loeschen(int MausX,int MauseY);
   void Verbindung_Horizontal_zeichnen(int Nr);
	void Verbindung_Vertikal_zeichnen(int Nr);
	void Schliesser_zeichnen(int Nr, StatusBauteil Status);
	void Oeffner_zeichnen(int Nr, StatusBauteil Status);
  	void Relais_zeichnen(int Nr, StatusBauteil Status);
   void SE_Relais_zeichnen(int Nr,StatusBauteil Status); // Anzugsverzgertes Relais
	void SI_Relais_zeichnen(int Nr,StatusBauteil Status);  // Abfallverzgertes Relais
	void Schalter_Schliesser_zeichnen(int Nr, StatusBauteil Status);
	void Taster_Schliesser_zeichnen(int Nr, StatusBauteil Status);
	void Taster_Oeffner_zeichnen(int Nr, StatusBauteil Status);
	void Lampe_zeichnen(int Nr, StatusBauteil Status);
	void ResetLogisch();
	void ResetStructe();
	void SE_Relais();
	void SI_Relais();
	void Speichern();
   void SpeichernAls();
	void Laden();
public:
	QStatusBar *statusbar;
	KMenuBar *menu;
	QTimer *timer;
	QColor PenFarbe,BrushFarbe;
	QFileDialog *fileName;
	QLineEdit *Kommentar[12];
	QColor Hintergrund;
public slots:
	void MenueItem(int MenuPunkt);
    void timerSimulation();
 public:
    /** construtor */
    KRelais();
    /** destructor */
    ~KRelais();
};

#endif
