/***************************************************************************
                          kconnectionlist.cpp  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Jonathon Sim
    email                : jonathonsim@iname.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kconnectionlist.h"
#include <klocale.h>
#include <qpushbutton.h>
#include <klineedit.h>
#include <klistview.h>
#include "ksynkconnection.h"
#include <qlayout.h>
#include <kiconloader.h>
#include "global.h"

#include <assert.h>

KConnectionList::KConnectionList(QWidget *parent, const char *name)
    : ConnectionList(parent, name)
{
    ConnectionKListView->clear();
    connect(ConnectionKListView,SIGNAL(selectionChanged()),this,
            SLOT(slotSelectionChanged()) );
    connect(ConnectionKListView,SIGNAL(clicked ( QListViewItem *  )),
            this,SLOT(slotSelectionChanged()) );
}

KConnectionList::~KConnectionList()
{
}


/** Adds a connection to the list */
void KConnectionList::addConnection(const KSynkConnection& thenewconnection)
{
    KSynkConnection* newconnection = new KSynkConnection(thenewconnection) ;
    connectiondict.insert(newconnection->getName(),newconnection);
    //Update the list
    (void) new KListViewItem(ConnectionKListView,newconnection->getName(),
                             newconnection->getRemoteURL().prettyURL(),
                             newconnection->getLocalURL().prettyURL());
}

/** Removes the selected connection  */
void KConnectionList::deleteSelectedConnection()
{
    if ( ConnectionKListView->selectedItem() )
        deleteConnection( ConnectionKListView->selectedItem()->text (0) );
}

void KConnectionList::deleteConnection( const QString& name )
{
    connectiondict.remove( name );
    delete findItemByName( name );
}

/** Changes the selected connection to the new connection. */
void KConnectionList::changeSelectedConnection(const KSynkConnection thenewconnection)
{
    if (ConnectionKListView->selectedItem())
    {
        changeConnection( ConnectionKListView->selectedItem()->text(0),
                          thenewconnection );
    }
}

void KConnectionList::changeConnection( const QString& name,
                                        const KSynkConnection& conn )
{
    connectiondict.remove( name ) ;
    KSynkConnection* newconnection=new KSynkConnection( conn ) ;
    connectiondict.insert(newconnection->getName(),newconnection);
    //Update the list
    QListViewItem *item = findItemByName( name );
    assert( item );

    item->setText(0,newconnection->getName());
    item->setText(1,newconnection->getRemoteURL().prettyURL());
    item->setText(2,newconnection->getLocalURL().prettyURL());
}

/** Returns the currently selected connection */
const KSynkConnection * KConnectionList::selectedConnection()
{
    if (ConnectionKListView->selectedItem()) {
        return connectiondict[ConnectionKListView->selectedItem()->text (0)];
    }
    else {
        return 0;
    }
}
/** Handles change of selection */
void KConnectionList::slotSelectionChanged()
{
    QListViewItem *item = ConnectionKListView->currentItem();
    if ( item && !item->isSelected() )
        item->setSelected( true );
    emit signalSelectionChanged();
}

/** A pointer to the given connection, or 0 if there is none */
const KSynkConnection* KConnectionList::getConnection(const QString & name) const
{
    return connectiondict[name];
}

/** Returns the list of  connections */
KConnectionList::List  * KConnectionList::connectionList()
{
    KConnectionList::List * list = new KConnectionList::List;
    list->setAutoDelete(false);
    QListViewItem * item = ConnectionKListView->firstChild();
    for ( ; item; item = item->nextSibling() )
        list->append(connectiondict[item->text(0)]);

    return list;	
}

QListViewItem * KConnectionList::findItemByName( const QString& name )
{
    QListViewItem *item = ConnectionKListView->selectedItem();
    if ( item && item->text( 0 ) == name  )
        return item;

    QListViewItemIterator it( ConnectionKListView );
    for( ; it.current(); ++it )
    {
        if ( it.current()->text( 0 ) == name )
            return it.current();
    }

    return 0L;
}

void KConnectionList::setInitialSelection()
{
    slotSelectionChanged();
}

#include "kconnectionlist.moc"
