// -*- c++ -*-
/***************************************************************************
                           soundwidgetimpl.h
                           -------------------
    begin                : Sun Sep 6 2003
    copyright            : (C) 2003 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef SOUNDWIDGETIMPL_H
#define SOUNDWIDGETIMPL_H

#include "soundwidget.h"
#include "pluginfactory.h"
#include "settingsdialogpage.h"

class ConfigData;
class KConfig;
class Kdetv;

/**
 * @author Dirk Ziegelmeier <dziegel@gmx.de>
 */

class SoundWidgetImpl : public SoundWidget, public SettingsDialogPage
{
    Q_OBJECT
	
public: 
    SoundWidgetImpl(QWidget*, Kdetv*, ConfigData*);
    ~SoundWidgetImpl();


public slots:
    virtual void setup();
    virtual void apply();
    virtual void defaults();

    
private slots:
    void mixerSelectionChanged(const QString& mixer);
    void configurePlugin();
    

private:
    PluginDesc* getPluginDesc(const QString& mixer);

    QString     _prevMixer;
    Kdetv*      _ktv;
    ConfigData* _cfg;
};
#endif
