__all__=('BoolOption', 'True', 'False')
import string
import SCons.Errors
__true_strings =('y', 'yes', 'true', 't', '1', 'on' , 'all' )
__false_strings=('n', 'no', 'false', 'f', '0', 'off', 'none')
True, False=1, 0
def _text2bool(val):
    lval=string.lower(val)
    if lval in __true_strings: return True
    if lval in __false_strings: return False
    raise ValueError("Invalid value for boolean option: %s" % val)
def _validator(key, val, env):
    if not env[key] in (True, False):
        raise SCons.Errors.UserError(
            'Invalid value for boolean option %s: %s' % (key, env[key]))
def BoolOption(key, help, default):
    return (key, '%s (yes|no)' % help, default, _validator, _text2bool)
