/***************************************************************************
                          notetreedlg.h  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*********************************************************************
	--- Qt Architect generated file ---

	File: notetreedlg.h
	Last generated: Mon Sep 27 20:14:48 1999

 *********************************************************************/

#ifndef NoteTreeDlg_included
#define NoteTreeDlg_included

#include "notetreedlgdata.h"
#include "kaspabase.h"
#include <klistview.h>



class NoteTreeItem:public QListViewItem {

private:
	NoteTreeItem(const NoteTreeItem&);
	NoteTreeItem& operator=(const NoteTreeItem&);

public:
	NoteTreeItem (NoteTreeItem *parent, Oid o, const char *theText, QPixmap pm=QPixmap(), bool _publnote=true):
		QListViewItem(parent, theText), oid(o), publnote(_publnote) { setPixmap(0, pm); };
	NoteTreeItem (KListView *parent, Oid o, const char *theText, QPixmap pm=QPixmap(), bool _publnote=true):
		QListViewItem(parent, theText), oid(o), publnote(_publnote) { setPixmap(0, pm); };
	Oid oid;
  bool publnote;
};	

class NoteTreeDlg : public NoteTreeDlgData
{
    Q_OBJECT

private:
		NoteTreeDlg(const NoteTreeDlg&);
		NoteTreeDlg& operator=(const NoteTreeDlg&);

    void addItem(NoteTitle *notes, Oid parentoid, NoteTreeItem *parentitem);
public:

    NoteTreeDlg(NoteTitle *n, PublTitle *p=0L, QWidget* parent = 0L, const char* name = 0L);

    virtual ~NoteTreeDlg();

    Oid getOid();

private:
	NoteTitle *notes;
	PublTitle *publs;
};


class NoteListView: public KListView {

 public:
 NoteListView(QWidget *parent = 0, const char *name = 0):
   KListView (parent, name) {};

 protected:
 void startDrag() {
    NoteTreeItem *i=dynamic_cast<NoteTreeItem*>(currentItem());
    if(!i->publnote)
      KListView::startDrag();
 }
};

#endif



