//-*-Mode: C++;-*-
/***************************************************************************
 * pairs.h  -  description                              
 * -------------------                                         
 * begin                : Sat Aug 14 1999 
 * copyright            : (C) 1999 by Rajko Albrecht
 * email                : Rajko.Albrecht@informatik.tu-chemnitz.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <string>
#include <utility>
#include "kmysqladmin/helpers/specials.h"

// $Id: pairs.h,v 2.9 2003/02/09 17:54:35 ral Exp $
#ifndef _pairs_h_included
#define _pairs_h_included

// a struct of voted pairs. Voted means - only the first entry is used for
// comparsion
template<class T1,class T2> struct voted_pair : public std::pair<T1,T2>
{
    voted_pair();
    voted_pair(const T1&a,const T2&b);
    virtual ~voted_pair();
};

template <class T1, class T2> inline voted_pair<T1,T2>::voted_pair()
	:std::pair<T1,T2>()
{
}

template <class T1, class T2> inline voted_pair<T1,T2>::voted_pair(const T1&a,const T2&b)
	:std::pair<T1,T2>(a,b)
{
}

template <class T1, class T2> inline voted_pair<T1,T2>::~voted_pair()
{
    std::pair<T1,T2>::~pair();
}

template <class T1, class T2> inline bool operator==(const voted_pair<T1, T2>& x, const voted_pair<T1, T2>& y) 
{
    return x.first == y.first;
}

template <class T1, class T2> inline bool operator<(const voted_pair<T1, T2>& x, const voted_pair<T1, T2>& y) 
{
    return x.first < y.first;
}

template <class T1, class T2> inline bool operator>(const voted_pair<T1, T2>& x, const voted_pair<T1, T2>& y) 
{
    return x.first > y.first;
}

typedef std::pair<std::string,unsigned int> string_int_pair;

inline bool operator==(const string_int_pair&x,const string_int_pair&y) 
{
    return strcasecmp(x.first.c_str(),y.first.c_str())==0;
}

inline bool operator<(const string_int_pair&x,const string_int_pair&y) 
{
    return strcasecmp(x.first.c_str(),y.first.c_str())<0;
}

inline bool operator>(const string_int_pair&x,const string_int_pair&y) 
{
    return strcasecmp(x.first.c_str(),y.first.c_str())>0;
}

typedef std::pair<std::string,std::string> string_pair;

inline bool operator==(const string_pair&x,const string_pair&y) 
{
    return strcasecmp(x.first.c_str(),y.first.c_str())==0;
}

inline bool operator>(const string_pair&x,const string_pair&y) 
{
    return strcasecmp(x.first.c_str(),y.first.c_str())>0;
}

inline bool operator<(const string_pair&x,const string_pair&y) 
{
    return strcasecmp(x.first.c_str(),y.first.c_str())<0;
}

#endif
