/***************************************************************************
                          partmemo.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: partmemomemo.cpp
	Last generated: Sun Sep 26 14:08:25 1999

 *********************************************************************/

#include <kapp.h>
#include <qstring.h>
#include <kiconloader.h>
#include <kmessagebox.h>

#include "partmemo.h"
#include "kaspawidget.h"
#include "resource.h"
#include "selectiondlg.h"
#include "notetreedlg.h"
#include <qmessagebox.h>
#include <klocale.h>
#include <kmdcodec.h>
#include <kprinter.h>
#include <qsimplerichtext.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>

#define Inherited PartMemoData

CommandSetup partmemocs[] = { {ID_PARTMEMO_DELREC,    RW},
                              {ID_PARTMEMO_SHOWPART,  RW+RO},
                              {ID_PARTMEMO_SHOWPUBL,  RW+RO},
                              {ID_PARTMEMO_FLUSH,     RW},
                              {ID_PARTMEMO_PRINT,     RW+RO},
                              {ID_PARTMEMO_RESET,     RW+RO+INV} };


// PartMemoBase-Constructor reads row matching WHERE-Clause.
PartMemo::PartMemo(KaspaURL url, Sql *conn, QWidget* parent,	const char* name):
	Inherited( parent, name)
{
//	debug("PartMemo::PartMemo(QString, QWidget, char*)");
  partmemo = new PartBase(url.where(), conn);
  ASSERT(partmemo);
	QString s("kaspa://partmemo#where part.no="); s+=QString().setNum(partmemo->id());
	_url=s;
  setupEditorConnections();
}

PartMemo::~PartMemo()
{
//	debug("PartMemo::~PartMemo()");
	delete partmemo;
}

bool PartMemo::isValid() {
	try {
	  return partmemo->isValid();
	} catch(KaspaErr& err) {
		handleWarning(err);
		return false;
	}
}

void PartMemo::reread() {
	setWorkingGUI();
	try {
	  partmemo->reset();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
 	setFields();
}

void PartMemo::setFields() {
	try {
	  if(isValid()) {
			setWorkingGUI();
			PublTitle *pt=partmemo->getPartPubl();
			if(!pt) { KMessageBox::error(this, i18n("Part has no Publication!")); return; }
      emit setCaption(QString(pt->getTitle())+" : "+QString(partmemo->getTitle()));
  		no->setText(QString().setNum(partmemo->getNumber()));
		  publtitle->setText(pt->getTitle());
  		parttitle->setText(partmemo->getTitle());
	  	memo->setText(QCString(partmemo->getMemo()));
			delete pt;
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
	setupGUI();
}

void PartMemo::flush() {
	setWorkingGUI();
	save();
	setupGUI();
}

void PartMemo::save(bool block) {
	try {
	  if(isValid() && !isReadOnly() && !isWorking()) {
    	  if(strcmp(QCString(memo->text()), partmemo->getMemo()))
      	  partmemo->setMemo(QCString(memo->text()));
	      partmemo->flush(block);
  	}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

void PartMemo::setInvalidGUI() {
	Inherited::setInvalidGUI();
	lockGUI();
	for(unsigned int i=0; i<sizeof(partmemocs)/sizeof(CommandSetup); i++)
		emit enableCommand(partmemocs[i].command, ((partmemocs[i].setup&INV)==INV));
}	

void PartMemo::setReadWriteGUI() {
 	Inherited::setReadWriteGUI();
 	unlockGUI();
	for(unsigned int i=0; i<sizeof(partmemocs)/sizeof(CommandSetup); i++)
		emit enableCommand(partmemocs[i].command, ((partmemocs[i].setup&RW)==RW));
}

void PartMemo::setWorkingGUI() {
	Inherited::setWorkingGUI();
	if(isReadOnly() || !isValid())
		lockGUI();
	else
		unlockGUI();
	memo->setEnabled(true);
	for(unsigned int i=0; i<sizeof(partmemocs)/sizeof(CommandSetup); i++)
		emit enableCommand(partmemocs[i].command, ((partmemocs[i].setup&WORK)==WORK));
}

void PartMemo::setReadOnlyGUI() {
	Inherited::setReadOnlyGUI();
	memo->setEnabled(false);
	for(unsigned int i=0; i<sizeof(partmemocs)/sizeof(CommandSetup); i++)
		emit enableCommand(partmemocs[i].command, ((partmemocs[i].setup&RO)==RO));
}


void PartMemo::del() {
	try {
	  if(isValid() && !isReadOnly() && !isWorking()&&deleteDlg()) {
			setWorkingGUI();
	  	partmemo->deleteRec();
		  setInvalidGUI();
		}
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

bool PartMemo::closeRequest() {
//	setWorkingGUI();
	save(true);
	setupGUI();
  return true;
}

void PartMemo::showPart() {
	requestPart(partmemo->id());
}

void PartMemo::print() {
  if(!memo) return;

  KPrinter printer;
  printer.setFullPage( true );
  printer.setDocName("Kaspaliste Memo");
  printer.setCreator("kaspaliste");


  if(printer.setup(this))
  {

    PublTitle *pt=partmemo->getPartPubl();
    if(!pt) { KMessageBox::error(this, i18n("Part has no Publication!")); return; }
    QString publtitle=pt->getTitle();
    QString year=pt->getYear();
    QString parttitle=partmemo->getTitle();
    delete pt;

    QString city;
    QString publisher;
    PublisherName *pn=partmemo->getPublPublisher();
    if(pn) {
      city=pn->getAddress();
      publisher=pn->getTitle();
    }
    delete pn;

    AuthorName *parta=partmemo->getPartAuthors();
    AuthorName *publa=partmemo->getPublAuthors();

    bool has_partauthors=(parta!=0L);
    bool has_publauthors=(publa!=0L);

    QString partauthors;
    if(has_partauthors) {
      partauthors=parta->getLastName()+QString(",")+parta->getFirstName();
      if(parta->getNext()) partauthors+=" et. al.";
    }

    QString publauthors;
    if(has_publauthors) {
      publauthors=publa->getLastName()+QString(",")+publa->getFirstName();
      if(publa->getNext()) publauthors+=" et. al.";
    }
    delete parta;
    delete publa;

    QString bib;
    if(has_partauthors)
      bib=partauthors+":"+parttitle+".In:"+publauthors+":"+publtitle+"."+
            (city.isEmpty()?QString(""):city+":")+(publisher.isEmpty()?QString(""):publisher+",")+year;
    else
      bib=(has_publauthors?publauthors+":":QString(""))+publtitle+"."+
            (city.isEmpty()?QString(""):city+":")+(publisher.isEmpty()?QString(""):publisher+",")+
            year+","+parttitle;

    QPainter p( &printer );
    // Check that there is a valid device to print to.
    if ( !p.device() ) return;  	
    QPaintDeviceMetrics metrics( p.device() );
    int dpix = metrics.logicalDpiX();
    int dpiy = metrics.logicalDpiY();
    const int bmargin = 72; // pt
    const int hmargin = 10;
    QRect body( bmargin * dpix / 72, bmargin * dpiy / 72,
            metrics.width() - bmargin * dpix / 72 * 2,
            metrics.height() - 2 * bmargin * dpiy / 72 );

/*

    QRect body( bmargin * dpix / 72, (bmargin+head) * dpiy / 72,
            metrics.width() - bmargin * dpix / 72 * 2,
            metrics.height() - (2*bmargin+head) * dpiy / 72 );

    QRect header( bmargin * dpix / 72, bmargin * dpiy / 72,
            metrics.width() - bmargin * dpix / 72 * 2,
            (bmargin+head) * dpiy / 72 );
*/

    QFont font( "times", 10 );
    QPen pen(black, 3);
    p.setPen(pen);
    QRect br=p.boundingRect(body.left(), body.top(), body.width(), body.height(),
               Qt::AlignLeft | Qt::WordBreak, bib);

    const int header=br.height()+hmargin;
    QSimpleRichText richText( memo->text(), font, memo->context(), memo->styleSheet(),
            memo->mimeSourceFactory(), body.height() );
    richText.setWidth( &p, body.width() );
    QRect view( body );
    int page = 1;
    p.setFont(QFont("times", 12));
    p.drawText(body.left(), body.top(), body.width(), header+10,
               Qt::AlignLeft | Qt::WordBreak, bib);

    p.drawLine(body.left(), body.top()+br.height()+5, body.right(), body.top()+br.height()+5);
    
    do {
      richText.draw( &p, body.left(), body.top()+header, view, colorGroup() );
      view.moveBy( 0, view.height());
      p.translate( 0 , -body.height());
      p.setFont( font );
      p.drawText( view.right() - p.fontMetrics().width( QString::number( page ) ),
              view.bottom() + p.fontMetrics().ascent() + 5, QString::number( page ) );
      if ( view.top()  >= richText.height()+page*header)
        break;
      printer.newPage();
      page++;
    } while (TRUE);
  }
}


void PartMemo::showPubl() {
	PublTitle *pt=partmemo->getPartPubl();
	if(!pt) { KMessageBox::error(this, i18n("Part has no Publication!")); return; }
	requestPublication(pt->getOid());
	delete pt;
}

KToolBar *PartMemo::getToolBar() {
	KaspaToolBar *toolbar = new KaspaToolBar(topLevelWidget());
	toolbar->insertButton(BarIcon("showpubl.png"), ID_PARTMEMO_SHOWPUBL, SIGNAL(clicked()),
				this, SLOT(showPubl()), true, i18n("Show Publication") );
	toolbar->insertButton(BarIcon("showpart.png"), ID_PARTMEMO_SHOWPART, SIGNAL(clicked()),
				this, SLOT(showPart()), true, i18n("Show Part") );

	toolbar->insertLineSeparator();
	toolbar->insertButton(BarIcon("filedel.png"), ID_PARTMEMO_DELREC, SIGNAL(clicked()),
				this, SLOT(del()), true, i18n("Delete Record") );

	toolbar->insertLineSeparator();
	toolbar->insertButton(BarIcon("filefloppy.png"), ID_PARTMEMO_FLUSH, SIGNAL(clicked()),
				this, SLOT(flush()), true, i18n("Save Changes") );
	toolbar->insertButton(BarIcon("reload.png"), ID_PARTMEMO_RESET, SIGNAL(clicked()),
				this, SLOT(reread()), true, i18n("Revert Record") );

	toolbar->insertLineSeparator();
	toolbar->insertButton(BarIcon("fileprint.png"), ID_PARTMEMO_PRINT, SIGNAL(clicked()),
				this, SLOT(print()), true, i18n("Print Text") );

	toolbar->insertLineSeparator();

  setupToolbar(toolbar);

	toolbar->setBarPos(KToolBar::Top);
	toolbar->enable(KToolBar::Show);
	return toolbar;
}
